/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.remote.gui.modules.importexport.GenericExportHandler;
import com.inet.shared.servlet.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;

public class DownloadProcess
extends ServiceMethod<Void, Void>
implements GenericExportHandler<TicketProcessFolder, TicketProcess> {
    public String getMethodName() {
        return "ticketprocess.downloadprocess";
    }

    public Void invoke(HttpServletRequest request, HttpServletResponse response, Void input) throws IOException {
        String id = request.getParameter("processid");
        String folder = request.getParameter("folderid");
        String subfolder = request.getParameter("includesubfolder");
        if (id == null && folder == null) {
            throw new FileNotFoundException();
        }
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        if (StringFunctions.isEmpty((String)id)) {
            boolean includeFolder = subfolder != null && "true".equals(subfolder);
            TicketProcessFolder processFolder = ticketProcessManager.getRootFolder();
            if (!StringFunctions.isEmpty((String)folder)) {
                processFolder = ticketProcessManager.getFolder(GUID.valueOf((String)folder));
            }
            if (processFolder == null) {
                throw new FileNotFoundException(folder);
            }
            this.writeFullZip(response, "processes", processFolder, includeFolder);
        } else {
            TicketProcess process = ticketProcessManager.getProcess(GUID.valueOf((String)id));
            if (process == null) {
                throw new FileNotFoundException(id);
            }
            ServletUtils.setContentDisposition((HttpServletResponse)response, (String)(GenericExportHandler.filterString((String)process.getName()) + ".process"), (boolean)false);
            this.writeWidgetData((OutputStream)response.getOutputStream(), process);
        }
        return null;
    }

    public short getMethodType() {
        return 2;
    }

    public List<TicketProcess> getWidgetsFromFolder(TicketProcessFolder folder) {
        return folder.getProcesses();
    }

    @Nonnull
    public @Nonnull List<@Nonnull TicketProcessFolder> getSubFoldersFromFolder(TicketProcessFolder folder) {
        return folder.getSubFolders();
    }
}

