/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.validation;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessValidationException;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessErrorCodes;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessProgressingConditionValue;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.ProcessAnalyser;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.TicketBranch;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.UnreachableActivitiesCheck;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DeadPathCheck {
    private TicketProcess process;
    private Set<TicketBranch> allPaths;
    private TicketBranch mainPath;
    private ProcessAnalyser analyser;

    public DeadPathCheck(ProcessAnalyser analyser) {
        this.analyser = analyser;
        this.allPaths = analyser.allPaths;
        this.mainPath = analyser.mainPath;
        this.process = analyser.process;
    }

    private DeadPathCheck(TicketProcess process) {
        this.process = process;
    }

    private FutureMaps _findUnreachableConditionsAndDeadPaths(int dispatched, @Nullable ProcessTickets processTickets, UnreachableCheck unreachableConditionCheck) {
        ActivityStatus mainActivity;
        HashMap parallelActivities = new HashMap();
        if (processTickets == null) {
            mainActivity = new ActivityStatus(this.process.getStart(), -9123, dispatched);
        } else {
            mainActivity = new ActivityStatus(this.process.getActivity((GUID)processTickets.getMainTicket().getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY)), processTickets.getMainTicket().getStatusID(), processTickets.getMainTicket().isDispatched() ? 2 : 1);
            processTickets.getSubTickets().entrySet().stream().forEach(e -> {
                ActivityStatus subStart = new ActivityStatus(this.process.getActivity((GUID)((TicketVO)e.getValue()).getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY)), ((TicketVO)e.getValue()).getStatusID(), ((TicketVO)e.getValue()).isDispatched() ? 2 : 1);
                parallelActivities.put((GUID)e.getKey(), subStart);
            });
        }
        FutureMap finishFuturePerTicket = new FutureMap();
        FutureMap finishedFuturePerActivity = new FutureMap();
        FutureMap visitedFuturePerActivity = new FutureMap();
        FutureMaps futureMaps = new FutureMaps();
        futureMaps.finishedActivites = finishedFuturePerActivity;
        futureMaps.finishedTickets = finishFuturePerTicket;
        futureMaps.visitedActivites = visitedFuturePerActivity;
        futureMaps.completableActivityStatus = new HashMap<ActivityStatus, CompletableFuture<Boolean>>();
        this.process.getParallelTickets().forEach(pt -> {
            if (pt.isDeactivated()) {
                return;
            }
            ActivityStatus startActivityId = (ActivityStatus)parallelActivities.get(pt.getId());
            if (startActivityId != null) {
                this.resolveActivities(startActivityId, finishFuturePerTicket.accessCondition(pt.getId()), futureMaps, unreachableConditionCheck);
                return;
            }
            ActivityStatus start = new ActivityStatus((ParallelTicket)pt);
            if (pt.getStartCondition().isEmpty()) {
                this.resolveActivities(start, finishFuturePerTicket.accessCondition(pt.getId()), futureMaps, unreachableConditionCheck);
            } else {
                String message = TicketProcessManager.MSG.getMsg("validation.condition.usedInParalelTicket", new Object[]{pt.getName()});
                CompletableFuture<Void> whenConditionsDone = this.createFutureResolvingWhenAllConditionsAreCompleted(pt.getStartCondition(), futureMaps, message, (ParallelTicket)pt, null, unreachableConditionCheck);
                whenConditionsDone.whenComplete((r, e) -> this.resolveActivities(start, finishFuturePerTicket.accessCondition(pt.getId()), futureMaps, unreachableConditionCheck));
            }
        });
        this.resolveActivities(mainActivity, null, futureMaps, unreachableConditionCheck);
        return futureMaps;
    }

    private ActivityStatus statusAfterAction(ActivityStatus currentStatus, ActionVO actionVO, Activity targetActivity) {
        int isDispatched = currentStatus.isDispatched;
        switch (actionVO.getId()) {
            case -3: 
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                isDispatched = 2;
                break;
            }
        }
        if (actionVO.getStatusID() == 150 || actionVO.getStatusID() == 260) {
            isDispatched = 2;
        }
        return new ActivityStatus(targetActivity, actionVO.getStatusID() == -100 ? currentStatus.status : actionVO.getStatusID(), isDispatched);
    }

    private boolean isActionPossibleOnStatus(int targetAction, ActivityStatus a) {
        TicketPermissionContext permissionInfo;
        ActionVO action = (ActionVO)ActionManager.getInstance().get(targetAction);
        if (action == null) {
            return false;
        }
        int testWithStatus = a.status;
        if (a.status == -9123) {
            if (targetAction == -2) {
                return false;
            }
            if (targetAction == 5) {
                return a.isDispatched != 2;
            }
            if (a.isDispatched == 1) {
                testWithStatus = 0;
            } else if (a.isDispatched == 2) {
                testWithStatus = 250;
            } else {
                return true;
            }
        }
        if (a.isDispatched == 3 && targetAction == 5 && Status.isOpenStatus((int)testWithStatus)) {
            return true;
        }
        if (targetAction == -36 && Status.isOpenStatus((int)testWithStatus)) {
            return true;
        }
        MutableTicketAttributes attributes = new MutableTicketAttributes();
        attributes.put((TicketAttribute)Tickets.ATTRIBUTE_BUNDLE_ID, (Object)2333444);
        attributes.put((TicketAttribute)Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID, (Object)1234567);
        attributes.put((TicketAttribute)Tickets.ATTRIBUTE_STATUS_ID, (Object)testWithStatus);
        if (a.isDispatched != 1) {
            attributes.put((TicketAttribute)Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID, (Object)4555668);
            permissionInfo = TicketPermissionContext.artificialSupporterForDispatchedTicket();
        } else {
            permissionInfo = TicketPermissionContext.artificialDispatcherForInquiry();
        }
        MutableTicketData fields = new MutableTicketData();
        fields.put((TicketField)Tickets.FIELD_ITIL_ID, (Object)((Integer)Tickets.FIELD_ITIL_ID.getDefaultValue()));
        TicketVOSingle ticket = TicketVOSingle.create((int)2333444, (MutableTicketAttributes)attributes, (MutableTicketData)fields);
        try (UserAccountScope p = UserAccountScope.createPrivileged();){
            ActionCheckError checkAction = TicketManager.getTicketActionChecker().checkAction(action, (TicketVO)ticket, permissionInfo);
            if (checkAction != null) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    void checkForDeadPathsAndThrow(int dispatched, @Nullable ProcessTickets processTickets) {
        FutureMaps futureMaps = this._findUnreachableConditionsAndDeadPaths(dispatched, null, null);
        for (FutureMap map : new FutureMap[]{futureMaps.finishedTickets, futureMaps.finishedActivites, futureMaps.visitedActivites}) {
            for (GUID id : map.futures.keySet()) {
                ParallelTicket pt;
                if (map.query(id).isDone()) continue;
                String message = map.wasUsedInAutoTransition(id);
                if (message != null) {
                    throw new ProcessValidationException(message, this.process, map.getActivityWhereUsed(id));
                }
                message = map.wasUsedInParallelTicket(id);
                if (message == null || this.isParallelTicketDisconnected(pt = map.getParallelTicketWhereUsed(id), futureMaps)) continue;
                throw new ProcessValidationException(message, this.process, pt);
            }
        }
        Iterator<String> iterator = futureMaps.unFulfillableALL_TICKETS_FINISHED.iterator();
        if (iterator.hasNext()) {
            String string = (String)iterator.next();
            throw new ProcessValidationException(string, this.process);
        }
        if (futureMaps.completableActivityStatus.values().stream().allMatch(f -> !f.isDone())) {
            throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.noEndExists", new Object[0]), TicketProcessErrorCodes.DEAD_PATH, this.process, null);
        }
        for (Map.Entry entry : futureMaps.completableActivityStatus.entrySet()) {
            if (((CompletableFuture)entry.getValue()).isDone()) continue;
            StatusVO statusVO = (StatusVO)StatusManager.getInstance().get(((ActivityStatus)entry.getKey()).status);
            String displayValue = ((ActivityStatus)entry.getKey()).status == -9123 ? "<any open status>" : statusVO.getDisplayValue();
            throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.noWaytoEndTicketOrProcess", new Object[]{((ActivityStatus)entry.getKey()).a.getName(), displayValue}), TicketProcessErrorCodes.DEAD_PATH, this.process, ((ActivityStatus)entry.getKey()).a);
        }
        if (dispatched == 3) {
            block3: for (TicketBranch ticketBranch : this.allPaths) {
                for (Activity act : ticketBranch.getActivities()) {
                    boolean allAreDisconnected;
                    if (futureMaps.completableActivityStatus.keySet().stream().anyMatch(as -> as.a == act)) continue;
                    if (ticketBranch.getPt() != null && !ticketBranch.getPt().getStartCondition().isEmpty() && (allAreDisconnected = this.isParallelTicketDisconnected(ticketBranch.getPt(), futureMaps))) continue block3;
                    throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.notreachable.byallowedActions", new Object[]{act.getName()}), this.process, act);
                }
            }
        }
        if (processTickets != null) {
            for (TicketVO ticketVO : processTickets.allTickets()) {
                String ticketName;
                CompletableFuture<Boolean> completableFuture;
                int status = ticketVO.getStatusID();
                Activity activity = this.process.getActivity((GUID)ticketVO.getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY));
                if (this.isStatusWhichCanAlwaysAppear(status) && futureMaps.completableActivityStatus.keySet().stream().anyMatch(as -> as.a.equals(activity)) || (completableFuture = futureMaps.completableActivityStatus.get(new ActivityStatus(activity, status, ticketVO.isDispatched() ? 2 : 1))) != null || (completableFuture = futureMaps.completableActivityStatus.get(new ActivityStatus(activity, -9123, 3))) != null) continue;
                String statusName = ((StatusVO)StatusManager.getInstance().get(status)).getDisplayValue();
                if (ticketVO == processTickets.getMainTicket()) {
                    ticketName = TicketProcessManager.MSG.getMsg("validation.mainTicket", new Object[0]);
                } else {
                    GUID parallelId = (GUID)processTickets.getSubTickets().entrySet().stream().filter(e -> e.getValue() == ticket).findFirst().get().getKey();
                    ticketName = TicketProcessManager.MSG.getMsg("validation.parallelTicket", new Object[]{processTickets.getProcess().getParallelTicket(parallelId).getName()});
                }
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.statuscombinationNoLongerExists", new Object[]{activity.getName(), statusName, ticketName, ticketVO.getID()}), this.process, activity);
            }
        }
        new UnreachableActivitiesCheck(this.analyser, this)._checkForUnreachableActivities(futureMaps);
    }

    private boolean resolveActivities(ActivityStatus activityStatus, CompletableFuture<Boolean> owningTicket, FutureMaps futureMaps, UnreachableCheck unreachableCheck) {
        boolean result;
        boolean bl = result = !Status.isClosedOrDeletedStatus((int)activityStatus.status) && activityStatus.a.getType() != Activity.Type.FinishProcess;
        if (futureMaps.completableActivityStatus.containsKey(activityStatus)) {
            return result;
        }
        CompletableFuture<Boolean> hasWayToFinishTicketOrProcess = new CompletableFuture<Boolean>();
        futureMaps.completableActivityStatus.put(activityStatus, hasWayToFinishTicketOrProcess);
        if (Status.isClosedOrDeletedStatus((int)activityStatus.status) || activityStatus.a.getType() == Activity.Type.FinishProcess) {
            hasWayToFinishTicketOrProcess.complete(Boolean.TRUE);
            if (owningTicket != null) {
                owningTicket.complete(Boolean.TRUE);
            }
            if (unreachableCheck != null) {
                return result;
            }
        }
        if (activityStatus.a.getType() == Activity.Type.FinishProcess) {
            return result;
        }
        futureMaps.finishedActivites.accessCondition(activityStatus.a.getId());
        futureMaps.visitedActivites.accessCondition(activityStatus.a.getId()).complete(Boolean.TRUE);
        Activity reactivationActivity = null;
        for (ActivityTransition tra : activityStatus.a.getFollowUpActivities()) {
            ActionVO action = (ActionVO)ActionManager.getInstance().get(tra.getActionid());
            if (action == null) continue;
            if (action.getId() == -2) {
                reactivationActivity = tra.getNextActivity();
            }
            if (!this.isActionPossibleOnStatus(action.getId(), activityStatus)) continue;
            ActivityStatus statusAfterAction = this.statusAfterAction(activityStatus, action, tra.getNextActivity());
            Runnable resolveNextActivity = () -> {
                if (this.resolveActivities(statusAfterAction, owningTicket, futureMaps, unreachableCheck)) {
                    futureMaps.finishedActivites.accessCondition(activityStatus.a.getId()).complete(Boolean.TRUE);
                }
                futureMaps.completableActivityStatus.get(statusAfterAction).whenComplete((b, th) -> hasWayToFinishTicketOrProcess.complete((Boolean)b));
            };
            if (tra.getConditionsForAutoTransition().isEmpty()) {
                resolveNextActivity.run();
                continue;
            }
            List<ProcessCondition<?>> conditionsForAutoTransition = tra.getConditionsForAutoTransition();
            String message = TicketProcessManager.MSG.getMsg("validation.condition.usedInTransition", new Object[]{activityStatus.a.getName(), tra.getNextActivity().getName()});
            CompletableFuture<Void> whenConditionsDone = this.createFutureResolvingWhenAllConditionsAreCompleted(conditionsForAutoTransition, futureMaps, message, null, activityStatus.a, unreachableCheck);
            whenConditionsDone.whenComplete((r, e) -> resolveNextActivity.run());
        }
        Iterator<Object> iterator = activityStatus.a.getPossibleActions().iterator();
        while (iterator.hasNext()) {
            int action = (Integer)iterator.next();
            if (!this.isActionPossibleOnStatus(action, activityStatus)) continue;
            ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(action);
            if (action == -34 || action == -19) continue;
            Activity targetActivity = activityStatus.a;
            if (action == -12 && reactivationActivity != null) {
                targetActivity = reactivationActivity;
            }
            ActivityStatus statusAfterAction = this.statusAfterAction(activityStatus, actionVO, targetActivity);
            this.resolveActivities(statusAfterAction, owningTicket, futureMaps, unreachableCheck);
            futureMaps.completableActivityStatus.get(statusAfterAction).whenComplete((b, th) -> hasWayToFinishTicketOrProcess.complete((Boolean)b));
        }
        return result;
    }

    private CompletableFuture<Boolean> conditionWasRequested(FutureMap map, ProcessCondition<ProcessProgressingConditionValue> pc, String message, ParallelTicket pt, Activity a, UnreachableCheck unreachableCheck) {
        ProcessProgressingConditionValue value = pc.getValue();
        if (value.isIgnoreIfNoLongerReachable() && (unreachableCheck == null || !unreachableCheck.equalsCondition(pc))) {
            CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
            result.complete(Boolean.TRUE);
            return result;
        }
        return map.wasUsedIn(value, message, pt, a);
    }

    boolean isParallelTicketDisconnected(ParallelTicket pt, FutureMaps futureMaps) {
        return this.isParallelTicketDisconnected(pt, futureMaps, new HashSet<ParallelTicket>());
    }

    private boolean isParallelTicketDisconnected(ParallelTicket pt, FutureMaps futureMaps, Set<ParallelTicket> accessedTickets) {
        accessedTickets.add(pt);
        if (pt != null && !pt.getStartCondition().isEmpty()) {
            for (ProcessCondition<?> pc : pt.getStartCondition()) {
                FutureMap map = null;
                if (pc.getType().equals(ConditionType.TICKET_FINISHED.getTypeIdentifier())) {
                    map = futureMaps.finishedTickets;
                }
                if (pc.getType().equals(ConditionType.ACTIVITY_FINISHED.getTypeIdentifier())) {
                    map = futureMaps.finishedActivites;
                }
                if (pc.getType().equals(ConditionType.ACTIVITY_VISITED.getTypeIdentifier())) {
                    map = futureMaps.visitedActivites;
                }
                if (map != null) {
                    ProcessProgressingConditionValue value = ConditionType.TICKET_FINISHED.convert(pc.getConditionData());
                    if (!map.query(value.getItemId()).isDone()) {
                        ParallelTicket targetPT;
                        if (pc.getType().equals(ConditionType.TICKET_FINISHED.getTypeIdentifier())) {
                            targetPT = this.process.getParallelTicket(value.getItemId());
                        } else {
                            if (map.wasAccessed(value.getItemId())) {
                                return false;
                            }
                            TicketBranch parent = this.analyser.findParentOfActivity(value.getItemId());
                            if (parent == null) continue;
                            if (parent == this.mainPath) {
                                return false;
                            }
                            targetPT = parent.getPt();
                        }
                        if (accessedTickets.contains(targetPT)) {
                            return false;
                        }
                        if (this.isParallelTicketDisconnected(targetPT, futureMaps, accessedTickets)) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private CompletableFuture<Void> createFutureResolvingWhenAllConditionsAreCompleted(List<ProcessCondition<?>> conditions, FutureMaps futuremaps, String whereItIsUsed, ParallelTicket pt, Activity a, UnreachableCheck unreachableCheck) {
        List<CompletableFuture> conditionFutures = conditions.stream().map(pc -> {
            String message = TicketProcessManager.MSG.getMsg("validation.condition.notPossible", new Object[]{pc.getDisplayString(this.process), whereItIsUsed});
            if (pc.getType().equals(ConditionType.TICKET_FINISHED.getTypeIdentifier())) {
                return this.conditionWasRequested(futuremaps.finishedTickets, (ProcessCondition<ProcessProgressingConditionValue>)pc, message, pt, a, unreachableCheck);
            }
            if (pc.getType().equals(ConditionType.ACTIVITY_FINISHED.getTypeIdentifier())) {
                return this.conditionWasRequested(futuremaps.finishedActivites, (ProcessCondition<ProcessProgressingConditionValue>)pc, message, pt, a, unreachableCheck);
            }
            if (pc.getType().equals(ConditionType.ACTIVITY_VISITED.getTypeIdentifier())) {
                return this.conditionWasRequested(futuremaps.visitedActivites, (ProcessCondition<ProcessProgressingConditionValue>)pc, message, pt, a, unreachableCheck);
            }
            if (pc.getType().equals(ConditionType.ALL_TICKETS_FINISHED.getTypeIdentifier())) {
                return this.evaluateAllTicketsFinishedCondition(futuremaps, message);
            }
            CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
            completableFuture.complete(Boolean.TRUE);
            return completableFuture;
        }).collect(Collectors.toList());
        CompletableFuture<Void> whenConditionsDone = CompletableFuture.allOf(conditionFutures.toArray(new CompletableFuture[conditionFutures.size()]));
        return whenConditionsDone;
    }

    private CompletableFuture<Boolean> evaluateAllTicketsFinishedCondition(FutureMaps futuremaps, String message) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        for (ParallelTicket pt : this.process.getParallelTickets()) {
            GUID id;
            if (pt.isDeactivated() || futuremaps.finishedTickets.query(id = pt.getId()).isDone() || !futuremaps.finishedTickets.wasAccessed(id)) continue;
            futuremaps.unFulfillableALL_TICKETS_FINISHED.add(message);
            return result;
        }
        result.complete(Boolean.TRUE);
        return result;
    }

    public static boolean checkConditionIsNowUnreachable(TicketProcess process, ProcessTickets tickets, ConditionType<ProcessProgressingConditionValue> type, ProcessProgressingConditionValue conditionValue) {
        FutureMap myMap;
        UnreachableCheck unreachableCheck = new UnreachableCheck();
        unreachableCheck.conditionValue = conditionValue;
        unreachableCheck.type = type;
        FutureMaps futureMaps = new DeadPathCheck(process)._findUnreachableConditionsAndDeadPaths(tickets.getMainTicket().isDispatched() ? 2 : 1, tickets, unreachableCheck);
        if (type == ConditionType.ACTIVITY_FINISHED) {
            myMap = futureMaps.finishedActivites;
        } else if (type == ConditionType.ACTIVITY_VISITED) {
            myMap = futureMaps.visitedActivites;
        } else if (type == ConditionType.TICKET_FINISHED) {
            myMap = futureMaps.finishedTickets;
        } else {
            throw new UnsupportedOperationException();
        }
        CompletableFuture<Boolean> completableFuture = myMap.query(conditionValue.getItemId());
        return !completableFuture.isDone();
    }

    private boolean isStatusWhichCanAlwaysAppear(int status) {
        switch (status) {
            case 100: 
            case 102: 
            case 103: 
            case 109: {
                return true;
            }
        }
        return false;
    }

    private static class ActivityStatus {
        private Activity a;
        int status;
        int isDispatched;

        public ActivityStatus(Activity a, int status, int isDispatched) {
            this.a = a;
            this.status = status;
            this.isDispatched = isDispatched;
        }

        public ActivityStatus(ParallelTicket pt) {
            this.a = pt.getStart();
            ProcessValueReference processValueReference = pt.getStart().getIncomingTicketData().get(Tickets.FIELD_RESOURCE_GUID);
            if (!(processValueReference == null || processValueReference.hasConcreteValue() && processValueReference.getValue() == null)) {
                this.status = 100;
                this.isDispatched = 2;
            } else {
                this.status = 0;
                this.isDispatched = 1;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
            result = 31 * result + this.isDispatched;
            result = 31 * result + this.status;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActivityStatus other = (ActivityStatus)obj;
            if (this.a == null ? other.a != null : !this.a.equals(other.a)) {
                return false;
            }
            if (this.isDispatched != other.isDispatched) {
                return false;
            }
            return this.status == other.status;
        }
    }

    static class FutureMap {
        private HashMap<GUID, CompletableFuture<Boolean>> futures = new HashMap();
        private Map<GUID, String> requestedKeys_parallel = new HashMap<GUID, String>();
        private Map<GUID, ParallelTicket> requestedKeys_parallel_Tickets = new HashMap<GUID, ParallelTicket>();
        private Map<GUID, String> requestedKeys_auto = new HashMap<GUID, String>();
        private Map<GUID, Activity> requestedKeys_auto_Activity = new HashMap<GUID, Activity>();
        private Set<GUID> accessedKeys = new HashSet<GUID>();

        FutureMap() {
        }

        public boolean wasAccessed(GUID id) {
            return this.accessedKeys.contains(id);
        }

        public CompletableFuture<Boolean> query(GUID key) {
            return this.get_(key);
        }

        public CompletableFuture<Boolean> accessCondition(GUID key) {
            this.accessedKeys.add(key);
            return this.get_(key);
        }

        private CompletableFuture<Boolean> get_(GUID key) {
            CompletableFuture<Boolean> v = this.futures.get(key);
            if (v == null) {
                v = new CompletableFuture();
                this.futures.put(key, v);
            }
            return v;
        }

        public CompletableFuture<Boolean> wasUsedIn(ProcessProgressingConditionValue data, String whereItIsUsed, ParallelTicket usedInParallelTicketsCondition, Activity a) {
            if (usedInParallelTicketsCondition != null) {
                this.requestedKeys_parallel.put(data.getItemId(), whereItIsUsed);
                this.requestedKeys_parallel_Tickets.put(data.getItemId(), usedInParallelTicketsCondition);
            } else {
                this.requestedKeys_auto.put(data.getItemId(), whereItIsUsed);
                this.requestedKeys_auto_Activity.put(data.getItemId(), a);
            }
            return this.get_(data.getItemId());
        }

        public String wasUsedInAutoTransition(GUID key) {
            return this.requestedKeys_auto.get(key);
        }

        public String wasUsedInParallelTicket(GUID key) {
            return this.requestedKeys_parallel.get(key);
        }

        public ParallelTicket getParallelTicketWhereUsed(GUID key) {
            return this.requestedKeys_parallel_Tickets.get(key);
        }

        public Activity getActivityWhereUsed(GUID key) {
            return this.requestedKeys_auto_Activity.get(key);
        }
    }

    static class FutureMaps {
        private FutureMap visitedActivites;
        private FutureMap finishedActivites;
        private FutureMap finishedTickets;
        private Map<ActivityStatus, CompletableFuture<Boolean>> completableActivityStatus;
        private List<String> unFulfillableALL_TICKETS_FINISHED = new ArrayList<String>();

        FutureMaps() {
        }
    }

    private static class UnreachableCheck {
        ConditionType<ProcessProgressingConditionValue> type;
        ProcessProgressingConditionValue conditionValue;

        private UnreachableCheck() {
        }

        public boolean equalsCondition(ProcessCondition<ProcessProgressingConditionValue> pc) {
            return pc.getType().equals(this.type.getTypeIdentifier()) && pc.getValue().equals(this.conditionValue);
        }
    }
}

