/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.id.GUID;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonData
@Immutable
public class ActivityTransition {
    private transient Activity nextActivity;
    private GUID nextActivityId;
    private String actionLabel;
    private int actionid;
    private List<ProcessCondition<?>> conditionsForAutoTransition;
    private ReaStepTextVO autoTransitionText;

    private ActivityTransition() {
    }

    public ActivityTransition(GUID nextActivityId, String actionLabel, int actionid) {
        this(nextActivityId, actionLabel, actionid, Collections.emptyList(), null);
    }

    public ActivityTransition(Activity nextActivity, int actionid) {
        this(nextActivity.getId(), null, actionid, Collections.emptyList(), null);
        this.nextActivity = nextActivity;
    }

    public ActivityTransition(GUID nextActivityId, String actionLabel, int actionid, List<ProcessCondition<?>> conditionsForAutoTransition, @Nullable String autoTransitionText) {
        Objects.requireNonNull(nextActivityId);
        Objects.requireNonNull(conditionsForAutoTransition);
        this.nextActivityId = nextActivityId;
        this.actionLabel = actionLabel;
        this.actionid = actionid;
        this.conditionsForAutoTransition = Collections.unmodifiableList(conditionsForAutoTransition);
        this.autoTransitionText = autoTransitionText == null ? ReaStepTextVO.empty() : ReaStepTextVO.of((String)autoTransitionText, (boolean)false);
    }

    public Activity getNextActivity() {
        return this.nextActivity;
    }

    public GUID getNextActivityId() {
        return this.nextActivityId;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public int getActionid() {
        return this.actionid;
    }

    public List<ProcessCondition<?>> getConditionsForAutoTransition() {
        return this.conditionsForAutoTransition;
    }

    void restoreReferences(List<Activity> activities, TicketProcess process, Activity parentActivity) {
        if (this.nextActivity == null) {
            for (Activity activity : activities) {
                if (!this.nextActivityId.equals((Object)activity.getId())) continue;
                this.nextActivity = activity;
                break;
            }
            if (this.nextActivity == null) {
                throw new IllegalStateException("Activity not found: " + String.valueOf(this.nextActivityId));
            }
            if (this.conditionsForAutoTransition == null) {
                this.conditionsForAutoTransition = Collections.emptyList();
            }
            for (int index = 0; index < this.conditionsForAutoTransition.size(); ++index) {
                GUID itemId;
                ProcessCondition<?> pc = this.conditionsForAutoTransition.get(index);
                if (pc.getType().equals(ConditionType.TICKET_FINISHED.getTypeIdentifier())) {
                    itemId = ConditionType.TICKET_FINISHED.convert(pc.getConditionData()).getItemId();
                    try {
                        process.getParallelTicket(itemId);
                    }
                    catch (IllegalStateException ee) {
                        String whereUsed = TicketProcessManager.MSG.getMsg("validation.condition.usedInTransition", new Object[]{parentActivity.getName(), this.nextActivity.getName()});
                        throw new IllegalStateException(TicketProcessManager.MSG.getMsg("validation.condition.autoTransition.ticketNotFound", new Object[]{whereUsed, index + 1, itemId}));
                    }
                }
                if (!pc.getType().equals(ConditionType.ACTIVITY_FINISHED.getTypeIdentifier()) && !pc.getType().equals(ConditionType.ACTIVITY_VISITED.getTypeIdentifier()) || process.getActivity(itemId = ConditionType.ACTIVITY_FINISHED.convert(pc.getConditionData()).getItemId()) != null) continue;
                String whereUsed = TicketProcessManager.MSG.getMsg("validation.condition.usedInTransition", new Object[]{parentActivity.getName(), this.nextActivity.getName()});
                throw new IllegalStateException(TicketProcessManager.MSG.getMsg("validation.condition.autoTransition.activityNotFound", new Object[]{whereUsed, index + 1, itemId}));
            }
            if (this.autoTransitionText == null) {
                this.autoTransitionText = ReaStepTextVO.empty();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionLabel == null ? 0 : this.actionLabel.hashCode());
        result = 31 * result + this.actionid;
        result = 31 * result + (this.autoTransitionText == null ? 0 : this.autoTransitionText.hashCode());
        result = 31 * result + (this.conditionsForAutoTransition == null ? 0 : this.conditionsForAutoTransition.hashCode());
        result = 31 * result + (this.nextActivityId == null ? 0 : this.nextActivityId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivityTransition other = (ActivityTransition)obj;
        if (this.actionLabel == null ? other.actionLabel != null : !this.actionLabel.equals(other.actionLabel)) {
            return false;
        }
        if (this.actionid != other.actionid) {
            return false;
        }
        if (this.autoTransitionText == null ? other.autoTransitionText != null : !this.autoTransitionText.equals((Object)other.autoTransitionText)) {
            return false;
        }
        if (this.conditionsForAutoTransition == null ? other.conditionsForAutoTransition != null : !this.conditionsForAutoTransition.equals(other.conditionsForAutoTransition)) {
            return false;
        }
        return !(this.nextActivityId == null ? other.nextActivityId != null : !this.nextActivityId.equals((Object)other.nextActivityId));
    }

    public String toString() {
        return "ActivityTransition [nextActivityId=" + String.valueOf(this.nextActivityId) + ", actionLabel=" + this.actionLabel + ", actionid=" + this.actionid + "]";
    }

    public boolean isAutoTransition() {
        return !this.conditionsForAutoTransition.isEmpty();
    }

    public String getAutoTransitionText() {
        return this.autoTransitionText.getText();
    }
}

