/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.search;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.TicketProcessManagerImpl;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.fields.TicketAttributeProcessChildTickets;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.FieldDisplayNameProvider;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class ProcessSubViewGrouping
extends SimpleSubViewGrouping {
    private static final String SINGLE = "s";
    private static final String PROCESS = "p";

    public ProcessSubViewGrouping() {
        super("ticketprocess");
    }

    public String getDisplayName() {
        return FieldDisplayNameProvider.getDisplayNameFor((I18nMessages)TicketProcessManager.MSG, (String)TicketProcessManager.ATTRIBUTE_PROCESS.getKey());
    }

    public String getDescription() {
        return FieldDisplayNameProvider.getDisplayNameFor((I18nMessages)TicketProcessManager.MSG, (String)(TicketProcessManager.ATTRIBUTE_PROCESS.getKey() + ".view.description"));
    }

    public void appendMarker(SearchCommand command) {
        super.appendMarker(command);
        SearchCondition marker = new SearchCondition("subject", SearchCondition.SearchTermOperator.StartsWith, (Object)"");
        command.addBoostingExpression((SearchExpression)marker);
    }

    public List<SubView<?>> getSubViews(@Nonnull TicketViewFactory parent, @Nonnull GUID accountID, Locale locale, @Nonnull Set<Integer> ticketIDs) {
        IndexSearchEngine engine = TicketManager.getReader().getSearchEngine();
        ArrayList result = new ArrayList();
        if (parent instanceof ProcessesView) {
            String processName = ((ProcessesView)parent).getFilterID();
            SearchCommand createSearchCommand = parent.createSearchCommand(accountID, locale, engine);
            createSearchCommand.getSearchExpression().add((SearchExpression)new SearchCondition("ticketprocess", SearchCondition.SearchTermOperator.Equals, (Object)processName));
            createSearchCommand.getSearchExpression().add((SearchExpression)new SearchCondition(TicketProcessManager.ATTRIBUTE_MAIN_TICKET.getKey(), SearchCondition.SearchTermOperator.Equals, null));
            createSearchCommand.getSearchExpression().add((SearchExpression)new SearchCondition("process.hasChild", SearchCondition.SearchTermOperator.Equals, (Object)TicketAttributeProcessChildTickets.Searchtag.TRUE));
            createSearchCommand.getSearchExpression().add((SearchExpression)new SearchCondition("bundleslave", SearchCondition.SearchTermOperator.Equals, (Object)"0"));
            Set search = engine.simpleSearch(createSearchCommand);
            List sorted = new ArrayList(search);
            sorted.sort((a, b) -> a.compareTo((Integer)b));
            if (sorted.size() > 200) {
                sorted = sorted.subList(0, 200);
            }
            sorted.forEach(id -> {
                TicketVO ticket = TicketManager.getReaderForSystem().getTicket(id.intValue());
                if (ticket != null) {
                    result.add(new SingleProcessView(((ProcessesView)parent).getParent(), (Integer)id, "#" + id + " " + ticket.getSubject()));
                }
            });
            return result;
        }
        Iterator it = engine.createDisplayValuesIterator(TicketProcessManager.ATTRIBUTE_PROCESS.getSearchTag(), (Comparable)((Object)""));
        HashMap<String, String> descriptions = new HashMap<String, String>();
        for (TicketProcess ticketProcess : TicketProcessManagerImpl.INSTANCE.getProcesses()) {
            descriptions.put(ticketProcess.getName(), ticketProcess.getDescription());
        }
        while (it.hasNext()) {
            SearchResult tickets;
            String name;
            String originalName = name = (String)it.next();
            Object description = (String)descriptions.get(name);
            if (!descriptions.containsKey(name) && !(tickets = engine.search(new SearchCommand(new SearchExpression[]{new SearchCondition("ticketprocess", SearchCondition.SearchTermOperator.Equals, (Object)name.toLowerCase())}))).getEntries().isEmpty()) {
                try (UserAccountScope s = UserAccountScope.createPrivileged();){
                    TicketVO ticket = TicketManager.getReaderForSystem().getTicket(((Integer)((SearchResultEntry)tickets.getEntries().get(0)).getId()).intValue());
                    TicketProcess process = TicketProcessManager.getProcessOfTicket(ticket);
                    if (process != null) {
                        name = process.getName();
                        description = process.getDescription();
                    }
                }
            }
            int processCount = this.determineProcessCount(parent, accountID, locale, (IndexSearchEngine<Integer>)engine, originalName.toLowerCase());
            String processStr = TicketProcessManager.MSG.getMsg("view.process.tooltip", new Object[]{processCount});
            description = StringFunctions.isEmpty((String)description) ? processStr : processStr + "\n\n" + (String)description;
            String size = " (" + TicketProcessManager.MSG.getMsg("view.process.active", new Object[]{processCount}) + ")";
            result.add(new ProcessesView(parent, name.toLowerCase(), name + size, (String)description));
        }
        return result;
    }

    private int determineProcessCount(TicketViewFactory parent, GUID accountID, Locale locale, IndexSearchEngine<Integer> engine, String processName) {
        SearchCommand createSearchCommand = parent.createSearchCommand(accountID, locale, engine);
        createSearchCommand.getSearchExpression().add((SearchExpression)new SearchCondition("ticketprocess", SearchCondition.SearchTermOperator.Equals, (Object)processName));
        createSearchCommand.getSearchExpression().add((SearchExpression)new SearchCondition("bundleslave", SearchCondition.SearchTermOperator.Equals, (Object)"0"));
        Set ticketsVisibleForUser = engine.simpleSearch(createSearchCommand);
        if (ticketsVisibleForUser.size() < 2) {
            return ticketsVisibleForUser.size();
        }
        HashSet<Integer> mainTickets = new HashSet<Integer>();
        SearchTag searchTag = engine.getTag(TicketProcessManager.ATTRIBUTE_MAIN_TICKET.getKey());
        Iterator it = engine.createEntryIterator(searchTag, null, id -> ticketsVisibleForUser.contains(id));
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Integer attrMainTicket = (Integer)entry.getKey();
            if (attrMainTicket == null) {
                mainTickets.addAll((Collection)entry.getValue());
                continue;
            }
            mainTickets.add(attrMainTicket);
        }
        return mainTickets.size();
    }

    protected Supplier<SearchExpression> getConditionSupplier(String subID, boolean hideSubnodeTickets) {
        if (subID.isEmpty()) {
            return null;
        }
        String id = subID.substring(1);
        if (subID.startsWith(SINGLE)) {
            return () -> this.getSingleProcessExpression(id);
        }
        String decodedId = new String(Base64.getUrlDecoder().decode(id), StandardCharsets.UTF_8).toLowerCase();
        return super.getConditionSupplier(decodedId, hideSubnodeTickets);
    }

    public void patchSearchCommand(Object id, @Nonnull SearchCommand command, @Nonnull GUID accountID) {
        if (id instanceof Integer) {
            AndSearchExpression expressions = command.getSearchExpression();
            Iterator it = expressions.iterator();
            while (it.hasNext()) {
                SearchExpression expr = (SearchExpression)it.next();
                if (expr.getType() != SearchExpression.Type.Condition) continue;
                SearchCondition cond = (SearchCondition)expr;
                if (!this.getKey().equals(cond.getLeftOperand())) continue;
                switch (cond.getOperator()) {
                    case Equals: {
                        it.remove();
                        break;
                    }
                }
            }
            expressions.add((SearchExpression)this.getSingleProcessExpression(id));
            return;
        }
        super.patchSearchCommand(id, command, accountID);
    }

    private OrSearchExpression getSingleProcessExpression(Object mainTicketId) {
        OrSearchExpression or = new OrSearchExpression();
        or.add((Object)new SearchCondition("ticketid", SearchCondition.SearchTermOperator.Equals, mainTicketId));
        or.add((Object)new SearchCondition(TicketProcessManager.ATTRIBUTE_MAIN_TICKET.getKey(), SearchCondition.SearchTermOperator.Equals, mainTicketId));
        return or;
    }

    public String getPreconfiguredDefaultSearchPhrase() {
        return "statusid:<\"300\" statusid:>=\"0\"";
    }

    public String getPreconfiguredDefaultViewName() {
        return "Prozess";
    }

    private class ProcessesView
    extends SubView<String> {
        private final String filterID;

        public ProcessesView(TicketViewFactory parent, String key, String displayName, String description) {
            super(parent, (SubViewGroupingDefinition)ProcessSubViewGrouping.this, (Object)(ProcessSubViewGrouping.PROCESS + Base64.getUrlEncoder().encodeToString(key.getBytes(StandardCharsets.UTF_8))), displayName, description, null);
            this.filterID = key;
        }

        public SubViewGroupingDefinition getSubViewGrouping() {
            return ProcessSubViewGrouping.this;
        }

        public String getFilterID() {
            return this.filterID;
        }
    }

    private class SingleProcessView
    extends SubView<String> {
        private final Integer mainTicketId;

        public SingleProcessView(TicketViewFactory parent, Integer mainTicketId, String displayName) {
            super(parent, (SubViewGroupingDefinition)ProcessSubViewGrouping.this, (Object)(ProcessSubViewGrouping.SINGLE + mainTicketId), displayName, null, null);
            this.mainTicketId = mainTicketId;
        }

        public Object getFilterID() {
            return this.mainTicketId;
        }

        public Map<String, String> getViewExtras() {
            return Map.of("ticketprocess.overview", this.mainTicketId.toString());
        }
    }
}

