/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.helpdesk.plugins.ticketprocess.client.data.UploadProcessRequest;
import com.inet.helpdesk.plugins.ticketprocess.client.data.UploadProcessResponse;
import com.inet.helpdesk.plugins.ticketprocess.client.handler.AbstractTicketProcessHandler;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.modules.importexport.GenericImportHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;

public class UploadProcess
extends AbstractTicketProcessHandler<UploadProcessRequest, UploadProcessResponse>
implements GenericImportHandler<TicketProcessFolder, TicketProcess> {
    public String getMethodName() {
        return "ticketprocess.uploadprocess";
    }

    @Override
    public UploadProcessResponse handle(HttpServletRequest req, HttpServletResponse resp, UploadProcessRequest input) throws IOException {
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<String> existingProcessPathes = new ArrayList<String>();
        AtomicInteger importedProcessesCount = new AtomicInteger(0);
        boolean validateFirst = input.isValidateFirst();
        boolean forceOverwrite = input.isForceOverwrite();
        TicketProcessFolder folder = ticketProcessManager.getRootFolder();
        if (!StringFunctions.isEmpty((String)input.getFolderId())) {
            folder = ticketProcessManager.getFolder(GUID.valueOf((String)input.getFolderId()));
        }
        if (folder == null) {
            throw new ClientMessageException("ticketprocess.error.missingfolder");
        }
        this.iterateParts(req, input.getAttachments(), errorMessages, existingProcessPathes, importedProcessesCount, validateFirst, forceOverwrite, folder);
        if (validateFirst) {
            if (!existingProcessPathes.isEmpty()) {
                return new UploadProcessResponse(errorMessages, existingProcessPathes, importedProcessesCount.get());
            }
            errorMessages.clear();
            importedProcessesCount.set(0);
            this.iterateParts(req, input.getAttachments(), errorMessages, existingProcessPathes, importedProcessesCount, false, forceOverwrite, folder);
        }
        return new UploadProcessResponse(errorMessages, null, importedProcessesCount.get());
    }

    private String createPathOfProcess(TicketProcessFolder folder, TicketProcess ticketProcess) {
        TicketProcessFolder parent = folder;
        Object parentPath = folder.getName();
        while ((parent = parent.getParent()) != null && !parent.getName().isEmpty()) {
            parentPath = parent.getName() + "  /  " + (String)parentPath;
        }
        parentPath = (String)parentPath + (((String)parentPath).isEmpty() ? "" : "  /  ") + ticketProcess.getName();
        return parentPath;
    }

    private String generateUniqueName(TicketProcess process, TicketProcessFolder folder) {
        Set existingNames = folder.getProcesses().stream().filter(p -> !p.getId().equals((Object)process.getId())).map(TicketProcess::getName).map(String::toLowerCase).collect(Collectors.toSet());
        String name = process.getName();
        if (StringFunctions.isEmpty((String)name)) {
            name = "process";
        }
        int i = 1;
        Object newName = name;
        while (existingNames.contains(((String)newName).toLowerCase())) {
            newName = name + " imported" + (String)(i == 1 ? "" : " (" + String.valueOf(i) + ")");
            ++i;
        }
        return newName;
    }

    public GUID importFolder(boolean validateFirst, ZipFile zipFile, String folderName, TicketProcessFolder currentfolder, String currentPath) throws IOException {
        GUID currentFolderId;
        if (currentfolder == null) {
            currentFolderId = GUID.generateNew();
        } else {
            Optional<TicketProcessFolder> findAny = currentfolder.getSubFolders().stream().filter(f -> f.getName().equals(folderName)).findAny();
            if (!findAny.isPresent()) {
                GUID newFolderId = GUID.generateNew();
                currentFolderId = !validateFirst ? ((TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class)).createFolder(newFolderId, currentfolder.getId(), folderName) : newFolderId;
            } else {
                currentFolderId = findAny.get().getId();
            }
        }
        return currentFolderId;
    }

    public void importWidget(InputStream inputStream, TicketProcessFolder folder, List<String> existingPathes, boolean validateFirst, boolean forceOverwrite) throws IOException {
        Optional<TicketProcess> optional;
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        TicketProcess ticketProcess = (TicketProcess)new Json().fromJson(inputStream, TicketProcess.class);
        if (ticketProcess == null) {
            throw new FileNotFoundException("No process in file");
        }
        boolean override = false;
        GUID ticketProcessId = ticketProcess.getId();
        if (ticketProcessManager.getProcess(ticketProcess.getId()) != null) {
            if (folder != null && folder.getProcesses().stream().anyMatch(p -> p.getId().equals((Object)ticketProcessId))) {
                String parentPath = this.createPathOfProcess(folder, ticketProcess);
                existingPathes.add(parentPath);
                if (forceOverwrite || validateFirst) {
                    override = true;
                } else {
                    ticketProcess = new TicketProcess(GUID.generateNew(), ticketProcess.getName(), ticketProcess.getDescription(), ticketProcess.getActivities(), ticketProcess.getStart().getId(), ticketProcess.getParallelTickets(), ticketProcess.getAutoResourceAccess(), ticketProcess.canBeChangedWhenActive());
                }
            } else {
                ticketProcess = new TicketProcess(GUID.generateNew(), ticketProcess.getName(), ticketProcess.getDescription(), ticketProcess.getActivities(), ticketProcess.getStart().getId(), ticketProcess.getParallelTickets(), ticketProcess.getAutoResourceAccess(), ticketProcess.canBeChangedWhenActive());
            }
        }
        String processName = ticketProcess.getName();
        GUID filterId = ticketProcess.getId();
        GUID processFoundId = null;
        if (folder != null && (optional = folder.getProcesses().stream().filter(p -> !p.getId().equals((Object)filterId)).filter(p -> p.getName().equalsIgnoreCase(processName)).findFirst()).isPresent()) {
            processFoundId = optional.get().getId();
        }
        if (processFoundId != null) {
            String parentPath = this.createPathOfProcess(folder, ticketProcess);
            existingPathes.add(parentPath);
            if (forceOverwrite || validateFirst) {
                ticketProcess = new TicketProcess(processFoundId, ticketProcess.getName(), ticketProcess.getDescription(), ticketProcess.getActivities(), ticketProcess.getStart().getId(), ticketProcess.getParallelTickets(), ticketProcess.getAutoResourceAccess(), ticketProcess.canBeChangedWhenActive());
                override = true;
            } else {
                String uniqueName = this.generateUniqueName(ticketProcess, folder);
                if (!uniqueName.equalsIgnoreCase(ticketProcess.getName())) {
                    ticketProcess = new TicketProcess(ticketProcess.getId(), uniqueName, ticketProcess.getDescription(), ticketProcess.getActivities(), ticketProcess.getStart().getId(), ticketProcess.getParallelTickets(), ticketProcess.getAutoResourceAccess(), ticketProcess.canBeChangedWhenActive());
                }
            }
        }
        if (!validateFirst) {
            if (override) {
                ticketProcessManager.updateProcess(ticketProcess);
            } else {
                if (folder == null) {
                    throw new FileNotFoundException("No folder created");
                }
                ticketProcessManager.createProcess(ticketProcess, folder.getId());
            }
        }
    }

    public TicketProcessFolder getFolderById(GUID id) {
        return ((TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class)).getFolder(id);
    }

    public List<String> listOfFilesForFolder() {
        return List.of();
    }
}

