/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessDetailsDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.data.SaveTicketProcessRequest;
import com.inet.helpdesk.plugins.ticketprocess.client.data.SaveTicketProcessResponse;
import com.inet.helpdesk.plugins.ticketprocess.client.handler.AbstractTicketProcessHandler;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessValidationException;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class SaveTicketProcess
extends AbstractTicketProcessHandler<SaveTicketProcessRequest, SaveTicketProcessResponse> {
    public String getMethodName() {
        return "ticketprocess.saveprocess";
    }

    @Override
    public SaveTicketProcessResponse handle(HttpServletRequest req, HttpServletResponse resp, SaveTicketProcessRequest payload) throws IOException {
        TicketProcess t;
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        ProcessDetailsDescription processDescription = payload.getProcess();
        try {
            t = ProcessDetailsDescription.to(processDescription).getProcessDefinition();
            t.validate();
        }
        catch (Throwable e) {
            if (e instanceof ProcessValidationException) {
                ProcessValidationException processException = (ProcessValidationException)e;
                Activity activity = processException.getActivity();
                if (activity != null) {
                    throw new ClientMessageException("<a ng-click=\"scrollToActivity('" + String.valueOf(activity.getId()) + "');\" activityid=\"" + String.valueOf(activity.getId()) + "\">" + e.getMessage() + "</a>", true);
                }
                ParallelTicket parallelTicket = processException.getParallelTicket();
                if (parallelTicket != null) {
                    throw new ClientMessageException("<a ng-click=\"scrollToTicket('" + String.valueOf(parallelTicket.getId()) + "');\" parallelticketid=\"" + String.valueOf(parallelTicket.getId()) + "\" highlightsource=\"true\">" + e.getMessage() + "</a>", true);
                }
            }
            if (e instanceof ClientMessageException) {
                throw e;
            }
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)e));
        }
        String hint = null;
        if (processDescription.getId() == null) {
            if (StringFunctions.isEmpty((String)payload.getProcessFolderId())) {
                ticketProcessManager.createProcess(t);
            } else {
                GUID processFolderGuid = GUID.valueOf((String)payload.getProcessFolderId());
                ticketProcessManager.createProcess(t, processFolderGuid);
            }
        } else {
            TicketProcessManager.UpdateProcessResult updateResult = ticketProcessManager.updateProcess(t);
            if (updateResult.isSynchronous() && !updateResult.isNoIncompatibleProcessesFound()) {
                hint = TicketProcessPlugin.MSG_CLIENT.getMsg("ticketprocess.save.hint.ticketsnotupdated", new Object[0]);
            } else if (!updateResult.isSynchronous()) {
                hint = TicketProcessPlugin.MSG_CLIENT.getMsg("ticketprocess.save.hint.asynchronous", new Object[]{updateResult.getNumOfTickets()});
            }
        }
        return new SaveTicketProcessResponse(t.getId(), hint);
    }
}

