/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.field.SelectOption;
import com.inet.helpdesk.plugins.ticketprocess.client.data.GetTicketProcessFolderListResponse;
import com.inet.helpdesk.plugins.ticketprocess.client.handler.AbstractTicketProcessHandler;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessFolder;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;

public class GetTicketProcessFolderList
extends AbstractTicketProcessHandler<Void, GetTicketProcessFolderListResponse> {
    @Override
    public GetTicketProcessFolderListResponse handle(HttpServletRequest req, HttpServletResponse resp, Void payload) throws IOException {
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        ArrayList<SelectOption> subOptions = new ArrayList<SelectOption>();
        TicketProcessFolder rootFolder = ticketProcessManager.getRootFolder();
        subOptions.add(new SelectOption(null, TicketProcessPlugin.MSG_CLIENT.getMsg("ticketprocess.folder.root", new Object[0]), rootFolder.isEmpty() ? "emptyFolder" : "folder", 0));
        this.browseFolder(rootFolder, subOptions, 1);
        return new GetTicketProcessFolderListResponse(subOptions);
    }

    private void browseFolder(TicketProcessFolder parentFolder, ArrayList<SelectOption> subOptions, int level) {
        ArrayList<TicketProcessFolder> subFolders = new ArrayList<TicketProcessFolder>(parentFolder.getSubFolders());
        subFolders.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        for (TicketProcessFolder ticketProcessFolder : subFolders) {
            subOptions.add(new SelectOption(ticketProcessFolder.getId().toString(), ticketProcessFolder.getName(), ticketProcessFolder.isEmpty() ? "emptyFolder" : "folder", level));
            this.browseFolder(ticketProcessFolder, subOptions, level + 1);
        }
    }

    public String getMethodName() {
        return "ticketprocess.getprocessfolderlist";
    }
}

