/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketAdditionalAccessValue;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessRef;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.Hash;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class UpdateTicketAccessListener
implements TicketEventListener {
    public void handleEvent(TicketEvent event) {
        try (UserAccountScope p = UserAccountScope.createPrivileged();){
            HashSet<Integer> changedMainTicketIds = new HashSet<Integer>();
            for (ChangedTicketVO ch : event.getChangedTickets()) {
                if (!this.someThingOnResourcesWasChangedAndHaveAccessFlagSet(ch)) continue;
                Integer mainTicketId = ch.getNewTicket() != null && TicketProcessManager.getProcessOfTicket(ch.getNewTicket()) != null ? (Integer)ch.getNewTicket().getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET) : (Integer)ch.getOldTicket().getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET);
                if (mainTicketId != null) {
                    changedMainTicketIds.add(mainTicketId);
                    continue;
                }
                changedMainTicketIds.add(ch.getTicketID());
            }
            for (Integer mainTicketId : changedMainTicketIds) {
                TicketVO oldTicket = this.getTicket(mainTicketId, event, true, true);
                TicketVO newTicket = this.getTicket(mainTicketId, event, false, true);
                AllowedResources participatingResourcesOld = this.collectResources(oldTicket, event, true);
                AllowedResources participatingResourcesNew = this.collectResources(newTicket, event, false);
                if (participatingResourcesNew.level == TicketProcess.AdditionalResourceAccess.NONE && participatingResourcesOld.level == TicketProcess.AdditionalResourceAccess.NONE) continue;
                GUID oldProcessId = this.getProcessId(oldTicket);
                GUID newProcessId = this.getProcessId(newTicket);
                if (Objects.equals(newProcessId, oldProcessId)) {
                    this.updateParticipatingResourcesInProcess(newTicket, participatingResourcesOld, participatingResourcesNew, event);
                    continue;
                }
                this.updateParticipatingResourcesInProcess(oldTicket, participatingResourcesOld, new AllowedResources(), event);
                this.updateParticipatingResourcesInProcess(newTicket, new AllowedResources(), participatingResourcesNew, event);
            }
        }
    }

    private void updateParticipatingResourcesInProcess(TicketVO theTicket, AllowedResources participatingResourcesOld, AllowedResources participatingResourcesNew, TicketEvent event) {
        if (theTicket == null) {
            return;
        }
        this.updateTicketAdditionalAccess(theTicket.getID(), participatingResourcesOld, participatingResourcesNew, this.getTicket(theTicket.getID(), event, true, false));
        Map children = (Map)theTicket.getAttribute(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS);
        if (children != null) {
            for (Integer childId : children.values()) {
                TicketVO newTicket;
                TicketVO ticket = this.getTicket(childId, event, true, false);
                if (ticket == null && (newTicket = this.getTicket(childId, event, false, false)) != null) {
                    this.updateTicketAdditionalAccess(childId, new AllowedResources(), participatingResourcesNew, null);
                    continue;
                }
                this.updateTicketAdditionalAccess(childId, participatingResourcesOld, participatingResourcesNew, ticket);
            }
        }
    }

    private void updateTicketAdditionalAccess(int ticketId, AllowedResources participatingResourcesOld, AllowedResources participatingResourcesNew, TicketVO oldOne) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
        if (ticket == null) {
            return;
        }
        TicketAdditionalAccessValue accessValue = (TicketAdditionalAccessValue)ticket.getValue((TicketField)Tickets.FIELD_ADDITIONAL_ACCESS);
        if (accessValue == null) {
            accessValue = new TicketAdditionalAccessValue();
        }
        if (participatingResourcesOld.level == TicketProcess.AdditionalResourceAccess.NONE) {
            this.setAccess(accessValue, participatingResourcesNew);
        } else if (participatingResourcesNew.level == TicketProcess.AdditionalResourceAccess.NONE) {
            this.removeAccess(accessValue, participatingResourcesOld);
        } else if (participatingResourcesNew.level != participatingResourcesOld.level) {
            this.removeAccess(accessValue, participatingResourcesOld);
            this.setAccess(accessValue, participatingResourcesNew);
        } else {
            this.diffAccess(accessValue, participatingResourcesOld, participatingResourcesNew);
        }
        if (!Objects.equals(accessValue, ticket.getValue((TicketField)Tickets.FIELD_ADDITIONAL_ACCESS))) {
            TicketProcess process = TicketProcessManager.getProcessOfTicket(ticket);
            if (process == null && oldOne != null) {
                process = TicketProcessManager.getProcessOfTicket(oldOne);
            }
            if (process != null) {
                try (WithAdditionalReaStepData dat = WithAdditionalReaStepData.create(TicketProcessManager.REASTEP_FIELD_PROCESS, (Object)new ProcessRef(process.getId(), process.getName()));){
                    TicketManager.getManipulator().changeTicketAdditionalAccess(ticketId, accessValue);
                }
            } else {
                TicketManager.getManipulator().changeTicketAdditionalAccess(ticketId, accessValue);
            }
        }
    }

    private void diffAccess(TicketAdditionalAccessValue accessValue, AllowedResources participatingResourcesOld, AllowedResources participatingResourcesNew) {
        HashSet<GUID> toRemove = new HashSet<GUID>(participatingResourcesOld.ressis);
        toRemove.removeAll(participatingResourcesNew.ressis);
        HashSet<GUID> toAdd = new HashSet<GUID>(participatingResourcesNew.ressis);
        toAdd.removeAll(participatingResourcesOld.ressis);
        if (participatingResourcesOld.level == TicketProcess.AdditionalResourceAccess.READ) {
            toRemove.forEach(guid -> accessValue.getReadAccess().remove(Hash.forGroup((GUID)guid)));
            toAdd.forEach(guid -> {
                Hash hash = Hash.forGroup((GUID)guid);
                if (!accessValue.getWriteAccess().contains(hash)) {
                    accessValue.setReadAccessFor(hash);
                }
            });
        } else if (participatingResourcesOld.level == TicketProcess.AdditionalResourceAccess.WRITE) {
            toRemove.forEach(guid -> accessValue.getWriteAccess().remove(Hash.forGroup((GUID)guid)));
            toAdd.forEach(guid -> accessValue.setWriteAccessFor(Hash.forGroup((GUID)guid)));
        }
    }

    private void removeAccess(TicketAdditionalAccessValue accessValue, AllowedResources participatingResources) {
        if (participatingResources.level == TicketProcess.AdditionalResourceAccess.READ) {
            participatingResources.ressis.forEach(guid -> accessValue.getReadAccess().remove(Hash.forGroup((GUID)guid)));
        } else if (participatingResources.level == TicketProcess.AdditionalResourceAccess.WRITE) {
            participatingResources.ressis.forEach(guid -> accessValue.getWriteAccess().remove(Hash.forGroup((GUID)guid)));
        }
    }

    private void setAccess(TicketAdditionalAccessValue accessValue, AllowedResources participatingResources) {
        if (participatingResources.level == TicketProcess.AdditionalResourceAccess.READ) {
            participatingResources.ressis.forEach(guid -> {
                Hash hash = Hash.forGroup((GUID)guid);
                if (!accessValue.getWriteAccess().contains(hash)) {
                    accessValue.setReadAccessFor(hash);
                }
            });
        } else if (participatingResources.level == TicketProcess.AdditionalResourceAccess.WRITE) {
            participatingResources.ressis.forEach(guid -> accessValue.setWriteAccessFor(Hash.forGroup((GUID)guid)));
        }
    }

    private GUID getProcessId(@Nullable TicketVO ticket) {
        if (ticket == null) {
            return null;
        }
        TicketProcess processOfTicket = TicketProcessManager.getProcessOfTicket(ticket);
        if (processOfTicket != null) {
            return processOfTicket.getId();
        }
        return null;
    }

    private AllowedResources collectResources(TicketVO mainTicket, TicketEvent event, boolean oldTicketElseNew) {
        AllowedResources result = new AllowedResources();
        result.level = TicketProcess.AdditionalResourceAccess.NONE;
        result.ressis = new HashSet<GUID>(){

            @Override
            public boolean add(GUID e) {
                if (e == null) {
                    return false;
                }
                return super.add(e);
            }
        };
        if (mainTicket == null) {
            return result;
        }
        TicketProcess process = TicketProcessManager.getProcessOfTicket(mainTicket);
        if (process == null) {
            return result;
        }
        if (process.getAutoResourceAccess() == TicketProcess.AdditionalResourceAccess.NONE) {
            return result;
        }
        result.level = process.getAutoResourceAccess();
        result.ressis.add(mainTicket.getResourceID());
        Map childTickets = (Map)mainTicket.getAttribute(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS);
        for (Integer childId : childTickets.values()) {
            TicketVO childTicket = this.getTicket(childId, event, oldTicketElseNew, true);
            if (childTicket == null) continue;
            result.ressis.add(childTicket.getResourceID());
        }
        for (Activity a : process.getActivities()) {
            ProcessValueReference valueReference = a.getIncomingTicketData().get(Tickets.FIELD_RESOURCE_GUID);
            if (valueReference == null || !valueReference.hasConcreteValue()) continue;
            result.ressis.add((GUID)valueReference.getValue());
        }
        for (ParallelTicket pt : process.getParallelTickets()) {
            for (Activity a : pt.getActivities()) {
                ProcessValueReference valueReference = a.getIncomingTicketData().get(Tickets.FIELD_RESOURCE_GUID);
                if (valueReference == null || !valueReference.hasConcreteValue()) continue;
                result.ressis.add((GUID)valueReference.getValue());
            }
        }
        return result;
    }

    private TicketVO getTicket(Integer id, TicketEvent event, boolean oldTicketElseNew, boolean loadFromCacheIfDoesNotExist) {
        Optional<ChangedTicketVO> optional = event.getChangedTickets().stream().filter(ch -> {
            if (oldTicketElseNew) {
                return ch.getOldTicket() != null && ch.getOldTicket().getID() == id.intValue();
            }
            return ch.getNewTicket() != null && ch.getNewTicket().getID() == id.intValue();
        }).findFirst();
        if (optional.isPresent()) {
            return oldTicketElseNew ? optional.get().getOldTicket() : optional.get().getNewTicket();
        }
        return !loadFromCacheIfDoesNotExist ? null : TicketManager.getReaderForSystem().getTicket(id.intValue());
    }

    private boolean someThingOnResourcesWasChangedAndHaveAccessFlagSet(ChangedTicketVO ch) {
        TicketProcess p2;
        GUID oldRes;
        TicketProcess.AdditionalResourceAccess accessOld;
        TicketProcess.AdditionalResourceAccess accessNew = this.hasGrantAccess(ch.getNewTicket());
        if (accessNew != (accessOld = this.hasGrantAccess(ch.getOldTicket()))) {
            return true;
        }
        if (accessNew == TicketProcess.AdditionalResourceAccess.NONE) {
            return false;
        }
        GUID newRes = ch.getNewTicket().getResourceID();
        if (!Objects.equals(newRes, oldRes = ch.getOldTicket().getResourceID())) {
            return true;
        }
        TicketProcess p1 = TicketProcessManager.getProcessOfTicket(ch.getNewTicket());
        return !Objects.equals(p1, p2 = TicketProcessManager.getProcessOfTicket(ch.getOldTicket()));
    }

    private TicketProcess.AdditionalResourceAccess hasGrantAccess(TicketVO theTicket) {
        if (theTicket == null || theTicket.isSlaveInBundle()) {
            return TicketProcess.AdditionalResourceAccess.NONE;
        }
        TicketProcess processOfTicket = TicketProcessManager.getProcessOfTicket(theTicket);
        return processOfTicket != null ? processOfTicket.getAutoResourceAccess() : TicketProcess.AdditionalResourceAccess.NONE;
    }

    private class AllowedResources {
        Set<GUID> ressis = Collections.emptySet();
        TicketProcess.AdditionalResourceAccess level = TicketProcess.AdditionalResourceAccess.NONE;

        private AllowedResources() {
        }
    }
}

