/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.model.general.RelativeOrAbsoluteDate;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@JsonData
@Immutable
public class ProcessValueReference<FIELDTYPE, VALUE> {
    @Deprecated
    private transient boolean concreteValue;
    private int referenceType;
    public static final int TYPE_CONCRETE = 1;
    public static final int TYPE_REFERENCE = 2;
    public static final int TYPE_REFERENCE_WITH_SUFFIX = 3;
    private GUID parallelTicketId;
    private transient VALUE value;
    private TicketField<FIELDTYPE> field;
    private String valueString;

    private ProcessValueReference() {
    }

    public static <FIELDTYPE, VALUE> ProcessValueReference<FIELDTYPE, VALUE> createConcrete(TicketField<FIELDTYPE> field, @Nonnull VALUE value) {
        ProcessValueReference<FIELDTYPE, VALUE> processValueReference = new ProcessValueReference<FIELDTYPE, VALUE>();
        if (ProcessValueReference.isDateField(field)) {
            if (value != null && !(value instanceof RelativeOrAbsoluteDate)) {
                throw new IllegalArgumentException("Must pass in a RelativeOrAbsoluteDate for dates!");
            }
            processValueReference.value = value;
        } else {
            processValueReference.value = field.copyValue(value);
        }
        processValueReference.valueString = value != null ? new Json().toJson(value) : null;
        processValueReference.field = field;
        processValueReference.referenceType = 1;
        return processValueReference;
    }

    public static <FIELDTYPE, VALUE> ProcessValueReference<FIELDTYPE, VALUE> createReferencing(GUID whichTicket) {
        ProcessValueReference<FIELDTYPE, VALUE> processValueReference = new ProcessValueReference<FIELDTYPE, VALUE>();
        processValueReference.parallelTicketId = whichTicket;
        processValueReference.referenceType = 2;
        return processValueReference;
    }

    public static ProcessValueReference<String, String> createReferencingWithSuffix(GUID whichTicket, TicketField<String> field, String value) {
        ProcessValueReference<String, String> processValueReference = new ProcessValueReference<String, String>();
        processValueReference.parallelTicketId = whichTicket;
        processValueReference.valueString = new Json().toJson((Object)value);
        processValueReference.field = field;
        processValueReference.referenceType = 3;
        return processValueReference;
    }

    public int getReferenceType() {
        this.correctType();
        return this.referenceType;
    }

    public boolean hasConcreteValue() {
        this.correctType();
        return this.getReferenceType() == 1 || this.referenceType == 3;
    }

    public boolean hasReferenceValue() {
        this.correctType();
        return this.getReferenceType() == 2 || this.referenceType == 3;
    }

    public GUID getParallelTicketId() {
        this.correctType();
        if (!this.hasReferenceValue()) {
            throw new UnsupportedOperationException("This cannot be called for concrete values.");
        }
        return this.parallelTicketId;
    }

    public VALUE getValue() {
        this.correctType();
        if (!this.hasConcreteValue()) {
            throw new UnsupportedOperationException("This cannot be called for future value references.");
        }
        if (this.value == null && this.valueString != null) {
            Class<RelativeOrAbsoluteDate> valueType = this.field.getValueType();
            if (ProcessValueReference.isDateField(this.field)) {
                valueType = RelativeOrAbsoluteDate.class;
            }
            this.value = new Json().fromJson(this.valueString, valueType);
        }
        return this.value;
    }

    private void correctType() {
        if (this.referenceType == 0) {
            this.referenceType = this.concreteValue ? 1 : 2;
        }
    }

    public int hashCode() {
        this.correctType();
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.parallelTicketId == null ? 0 : this.parallelTicketId.hashCode());
        result = 31 * result + this.referenceType;
        result = 31 * result + (this.valueString == null ? 0 : this.valueString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.correctType();
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessValueReference other = (ProcessValueReference)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.parallelTicketId == null ? other.parallelTicketId != null : !this.parallelTicketId.equals((Object)other.parallelTicketId)) {
            return false;
        }
        if (this.referenceType != other.referenceType) {
            return false;
        }
        return !(this.valueString == null ? other.valueString != null : !this.valueString.equals(other.valueString));
    }

    public static boolean isDateField(TicketField<?> field) {
        TicketFieldDefinition def;
        Class valueType = field.getValueType();
        return valueType == Long.class && (def = Tickets.getFieldDefinitionByKey((String)field.getKey())) != null && def.getEditDefinition() != null && (def.getEditDefinition().getDisplayType().equals("datevalue") || def.getEditDefinition().getDisplayType().equals("dateonlyvalue"));
    }
}

