/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.validation;

import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessValidationException;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ConditionType;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessCondition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessProgressingConditionValue;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.DeadPathCheck;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.validation.ProcessAnalyser;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class UnreachableActivitiesCheck {
    public static final int MAX_ANALYSE_TIME_MS = 1500;
    private ProcessAnalyser analyser;
    private DeadPathCheck dpc;
    private List<TicketState> states = new ArrayList<TicketState>();
    private TicketProcess process;
    private long startTime;
    private Set<Activity> accessedActivities = new HashSet<Activity>();

    public UnreachableActivitiesCheck(ProcessAnalyser analyser, DeadPathCheck dpc) {
        this.analyser = analyser;
        this.dpc = dpc;
        this.process = analyser.process;
    }

    public void _checkForUnreachableActivities(DeadPathCheck.FutureMaps futureMaps) {
        this.startTime = System.currentTimeMillis();
        HashMap<GUID, TicketStateItem> map = new HashMap<GUID, TicketStateItem>();
        map.put(null, new TicketStateItem(this.process.getStart()));
        for (ParallelTicket pt : this.process.getParallelTickets()) {
            if (pt.isDeactivated()) continue;
            map.put(pt.getId(), new TicketStateItem(null));
        }
        TicketState ticketState = new TicketState(map);
        this.walk(ticketState);
        if (System.currentTimeMillis() > this.startTime + 1500L) {
            return;
        }
        Consumer<List> test = list -> {
            for (Activity a : list) {
                boolean found;
                if (!this.analyser.isReferenced(a) || (found = this.accessedActivities.contains(a))) continue;
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.notreachable", new Object[]{a.getName()}), this.process, a);
            }
        };
        test.accept(this.process.getActivities());
        for (ParallelTicket pt : this.process.getParallelTickets()) {
            if (pt.isDeactivated() || this.dpc.isParallelTicketDisconnected(pt, futureMaps)) continue;
            test.accept(pt.getActivities());
        }
        ticketState.checkCanReachEnd();
        for (TicketState ts : this.states) {
            if (ts.canReachEnd) continue;
            String message = TicketProcessManager.MSG.getMsg("validation.mainTicket", new Object[0]) + ": " + ts.tickets.get(null).activity.getName();
            for (Map.Entry<GUID, TicketStateItem> ticket : ts.tickets.entrySet()) {
                if (ticket.getKey() == null || ticket.getValue().activity == null) continue;
                message = message + ", " + TicketProcessManager.MSG.getMsg("validation.parallelTicket", new Object[]{this.process.getParallelTicket(ticket.getKey()).getName()}) + ": " + ticket.getValue().activity.getName();
            }
            throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.deadpoint", new Object[]{message}), this.process);
        }
    }

    private void walk(TicketState ticketState) {
        if (ticketState == null) {
            return;
        }
        if (System.currentTimeMillis() > this.startTime + 1500L) {
            TicketProcessPlugin.LOGGER.debug((Object)String.format("Stop validating process %s because too high complexity", this.process.getName()));
            return;
        }
        this.states.add(ticketState);
        for (Map.Entry<GUID, TicketStateItem> ticket : ticketState.tickets.entrySet()) {
            Activity a = ticket.getValue().activity;
            if (a == null) continue;
            for (ActivityTransition tr : a.getFollowUpActivities()) {
                if (!tr.isAutoTransition()) {
                    this.walk(ticketState.doChange(ticket.getKey(), tr));
                    continue;
                }
                if (ticketState.allConditionsAreFulfilled(tr.getConditionsForAutoTransition()) != 0) continue;
                this.walk(ticketState.doChange(ticket.getKey(), tr));
            }
            for (Integer action : a.getPossibleActions()) {
                ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(action.intValue());
                if (!Status.isClosedOrDeletedStatus((int)actionVO.getStatusID())) continue;
                this.walk(ticketState.doChange(ticket.getKey(), actionVO));
            }
        }
    }

    private static void modifyStateAccordingToNewActivity(TicketStateItem newTicketState, ActivityTransition toActivity) {
        if (newTicketState.visitedActivities.contains(toActivity.getNextActivityId())) {
            newTicketState.visitedActivities = newTicketState.visitedActivities.subList(0, newTicketState.visitedActivities.indexOf(toActivity.getNextActivityId()) + 1);
        } else {
            newTicketState.visitedActivities.add(toActivity.getNextActivityId());
        }
        newTicketState.closedOrDeleted = Status.isClosedOrDeletedStatus((int)((ActionVO)ActionManager.getInstance().get(toActivity.getActionid())).getStatusID());
        if (toActivity.getNextActivity().getType() == Activity.Type.FinishProcess) {
            newTicketState.closedOrDeleted = true;
        }
    }

    private class TicketStateItem {
        private boolean closedOrDeleted = false;
        private Activity activity;
        private List<GUID> visitedActivities = new ArrayList<GUID>();

        public TicketStateItem(Activity activity) {
            this.activity = activity;
            if (activity != null) {
                this.visitedActivities.add(activity.getId());
            }
        }

        public TicketStateItem copy() {
            TicketStateItem ticketStateItem = new TicketStateItem(this.activity);
            ticketStateItem.closedOrDeleted = this.closedOrDeleted;
            ticketStateItem.visitedActivities = new ArrayList<GUID>(this.visitedActivities);
            return ticketStateItem;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.activity == null ? 0 : this.activity.hashCode());
            result = 31 * result + (this.closedOrDeleted ? 1231 : 1237);
            result = 31 * result + (this.visitedActivities == null ? 0 : this.visitedActivities.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TicketStateItem other = (TicketStateItem)obj;
            if (this.activity == null ? other.activity != null : !this.activity.equals(other.activity)) {
                return false;
            }
            if (this.closedOrDeleted != other.closedOrDeleted) {
                return false;
            }
            return !(this.visitedActivities == null ? other.visitedActivities != null : !this.visitedActivities.equals(other.visitedActivities));
        }
    }

    private class TicketState {
        private Map<GUID, TicketStateItem> tickets;
        private transient List<TicketState> parents = new ArrayList<TicketState>();
        private transient List<TicketState> children = new ArrayList<TicketState>();
        private transient boolean canReachEnd;

        private TicketState(Map<GUID, TicketStateItem> tickets) {
            this.tickets = tickets;
            this.checkConditions();
        }

        private void checkConditions() {
            for (Map.Entry<GUID, TicketStateItem> entry : this.tickets.entrySet()) {
                Activity a = entry.getValue().activity;
                if (a == null) {
                    List<ProcessCondition<?>> startCondition = UnreachableActivitiesCheck.this.process.getParallelTicket(entry.getKey()).getStartCondition();
                    if (this.allConditionsAreFulfilled(startCondition) < 0) continue;
                    entry.getValue().activity = UnreachableActivitiesCheck.this.process.getParallelTicket(entry.getKey()).getStart();
                    entry.getValue().visitedActivities.add(UnreachableActivitiesCheck.this.process.getParallelTicket(entry.getKey()).getStartActivityId());
                    this.checkConditions();
                    return;
                }
                UnreachableActivitiesCheck.this.accessedActivities.add(a);
                for (ActivityTransition activityTransition : a.getFollowUpActivities()) {
                    if (!activityTransition.isAutoTransition() || this.allConditionsAreFulfilled(activityTransition.getConditionsForAutoTransition()) != 1) continue;
                    entry.getValue().activity = activityTransition.getNextActivity();
                    UnreachableActivitiesCheck.modifyStateAccordingToNewActivity(entry.getValue(), activityTransition);
                    this.checkConditions();
                    return;
                }
            }
        }

        private int allConditionsAreFulfilled(List<ProcessCondition<?>> conditions) {
            boolean allLax = false;
            for (ProcessCondition<?> c : conditions) {
                ProcessProgressingConditionValue v;
                boolean lax = false;
                if (c.getValue() instanceof ProcessProgressingConditionValue && (v = (ProcessProgressingConditionValue)c.getValue()).isIgnoreIfNoLongerReachable()) {
                    lax = true;
                }
                if (c.getType().equals(ConditionType.ACTIVITY_FINISHED.getTypeIdentifier())) {
                    if (!this.tickets.values().stream().noneMatch(item -> {
                        GUID desiredId = ((ProcessProgressingConditionValue)c.getValue()).getItemId();
                        return item.visitedActivities.contains(desiredId) && !item.activity.getId().equals((Object)desiredId);
                    })) continue;
                    if (lax) {
                        allLax = true;
                        continue;
                    }
                    return -1;
                }
                if (c.getType().equals(ConditionType.ACTIVITY_VISITED.getTypeIdentifier())) {
                    if (!this.tickets.values().stream().noneMatch(item -> {
                        GUID desiredId = ((ProcessProgressingConditionValue)c.getValue()).getItemId();
                        return item.visitedActivities.contains(desiredId);
                    })) continue;
                    if (lax) {
                        allLax = true;
                        continue;
                    }
                    return -1;
                }
                if (c.getType().equals(ConditionType.TICKET_FINISHED.getTypeIdentifier())) {
                    if (!this.tickets.entrySet().stream().noneMatch(en -> {
                        GUID desiredId = ((ProcessProgressingConditionValue)c.getValue()).getItemId();
                        return en.getKey() != null && ((GUID)en.getKey()).equals((Object)desiredId) && ((TicketStateItem)en.getValue()).closedOrDeleted;
                    })) continue;
                    if (lax) {
                        allLax = true;
                        continue;
                    }
                    return -1;
                }
                if (!c.getType().equals(ConditionType.ALL_TICKETS_FINISHED.getTypeIdentifier()) || !this.tickets.entrySet().stream().anyMatch(en -> en.getKey() != null && ((TicketStateItem)en.getValue()).activity != null && !((TicketStateItem)en.getValue()).closedOrDeleted)) continue;
                return -1;
            }
            return allLax ? 0 : 1;
        }

        public TicketState doChange(GUID ticket, ActivityTransition toActivity) {
            HashMap<GUID, TicketStateItem> newState = new HashMap<GUID, TicketStateItem>();
            for (Map.Entry<GUID, TicketStateItem> en : this.tickets.entrySet()) {
                newState.put(en.getKey(), en.getValue().copy());
            }
            TicketStateItem newTicketState = new TicketStateItem(toActivity.getNextActivity());
            newTicketState.visitedActivities = new ArrayList<GUID>(this.tickets.get((Object)ticket).visitedActivities);
            UnreachableActivitiesCheck.modifyStateAccordingToNewActivity(newTicketState, toActivity);
            newState.put(ticket, newTicketState);
            try {
                TicketState ticketState = new TicketState(newState);
                if (UnreachableActivitiesCheck.this.states.contains(ticketState)) {
                    UnreachableActivitiesCheck.this.states.get((int)UnreachableActivitiesCheck.this.states.indexOf((Object)ticketState)).parents.add(this);
                    return null;
                }
                ticketState.parents.add(this);
                this.children.add(ticketState);
                return ticketState;
            }
            catch (StackOverflowError soe) {
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.auto.loop", new Object[0]), UnreachableActivitiesCheck.this.process, toActivity.getNextActivity());
            }
        }

        public TicketState doChange(GUID ticket, ActionVO action) {
            HashMap<GUID, TicketStateItem> newState = new HashMap<GUID, TicketStateItem>();
            for (Map.Entry<GUID, TicketStateItem> en : this.tickets.entrySet()) {
                newState.put(en.getKey(), en.getValue().copy());
            }
            TicketStateItem newTicketState = new TicketStateItem(this.tickets.get((Object)ticket).activity);
            newTicketState.visitedActivities = new ArrayList<GUID>(this.tickets.get((Object)ticket).visitedActivities);
            newTicketState.closedOrDeleted = Status.isClosedOrDeletedStatus((int)action.getStatusID());
            newState.put(ticket, newTicketState);
            TicketState ticketState = new TicketState(newState);
            if (UnreachableActivitiesCheck.this.states.contains(ticketState)) {
                UnreachableActivitiesCheck.this.states.get((int)UnreachableActivitiesCheck.this.states.indexOf((Object)ticketState)).parents.add(this);
                return null;
            }
            ticketState.parents.add(this);
            this.children.add(ticketState);
            return ticketState;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tickets == null ? 0 : this.tickets.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TicketState other = (TicketState)obj;
            return !(this.tickets == null ? other.tickets != null : !this.tickets.equals(other.tickets));
        }

        void checkCanReachEnd() {
            for (TicketState ts : this.children) {
                ts.checkCanReachEnd();
            }
            if (this.tickets.values().stream().allMatch(ticket -> ticket.closedOrDeleted || ticket.activity == null)) {
                this.markCanReachEnd();
            }
        }

        private void markCanReachEnd() {
            if (this.canReachEnd) {
                return;
            }
            this.canReachEnd = true;
            for (TicketState ts : this.parents) {
                ts.markCanReachEnd();
            }
        }
    }
}

