/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.helpdesk.plugins.ticketprocess.client.data.CreateFolderRequest;
import com.inet.helpdesk.plugins.ticketprocess.client.data.CreateFolderResponse;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ProcessFolderDescription;
import com.inet.helpdesk.plugins.ticketprocess.client.handler.AbstractTicketProcessHandler;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CreateProcessFolder
extends AbstractTicketProcessHandler<CreateFolderRequest, CreateFolderResponse> {
    @Override
    public CreateFolderResponse handle(HttpServletRequest req, HttpServletResponse resp, CreateFolderRequest payload) throws IOException {
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        if (StringFunctions.isEmpty((String)payload.getParentFolderId())) {
            GUID createFolderGuid = ticketProcessManager.createFolder(ticketProcessManager.getRootFolder().getId(), payload.getFolderName());
            ProcessFolderDescription folder = new ProcessFolderDescription(createFolderGuid.toString(), payload.getFolderName(), true, false);
            return new CreateFolderResponse(folder);
        }
        GUID parentFolder = GUID.valueOf((String)payload.getParentFolderId());
        GUID createFolderGuid = ticketProcessManager.createFolder(parentFolder, payload.getFolderName());
        ProcessFolderDescription folder = new ProcessFolderDescription(createFolderGuid.toString(), payload.getFolderName(), true, false);
        return new CreateFolderResponse(folder);
    }

    public String getMethodName() {
        return "ticketprocess.createfolder";
    }
}

