/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ticketupdate;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.event.TicketRelatedChangeEventDispatcher;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketRelatedChangeListener;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.ticketupdate.TicketUpdateListener;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class TicketUpdateDispatcher
implements TicketEventListener {
    private final HashMap<String, TypeSpecificListeners> typeListeners = new HashMap();
    private static TicketUpdateDispatcher INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static TicketUpdateDispatcher getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TicketUpdateDispatcher> clazz = TicketUpdateDispatcher.class;
        synchronized (TicketUpdateDispatcher.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TicketUpdateDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private TicketUpdateDispatcher() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String pollingID) {
            }

            public void connectionClosed(String pollingID) {
                TicketUpdateDispatcher.this.removeAll(pollingID);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String type, String clientID) {
        HashMap<String, TypeSpecificListeners> hashMap = this.typeListeners;
        synchronized (hashMap) {
            TicketRelatedChangeListener relatedChangeListener;
            Set<String> clients;
            TypeSpecificListeners typeListener = this.typeListeners.computeIfAbsent(type, t -> new TypeSpecificListeners());
            typeListener.listenerMap.remove(clientID);
            typeListener.userMap.remove(clientID);
            Integer ticketID = typeListener.insertMap.remove(clientID);
            if (ticketID != null && (clients = typeListener.extractMap.get(ticketID)) != null) {
                clients.remove(clientID);
                if (clients.isEmpty()) {
                    typeListener.extractMap.remove(ticketID);
                }
            }
            if ((relatedChangeListener = typeListener.ticketRelatedListenerMap.remove(clientID)) != null) {
                TicketRelatedChangeEventDispatcher.getInstance().removeChangeListener(relatedChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String clientID) {
        HashMap<String, TypeSpecificListeners> hashMap = this.typeListeners;
        synchronized (hashMap) {
            for (String type : this.typeListeners.keySet()) {
                this.remove(type, clientID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getClientsforTicketAndUser(String type, int ticketId, GUID userId) {
        HashMap<String, TypeSpecificListeners> hashMap = this.typeListeners;
        synchronized (hashMap) {
            HashSet<String> clientIds = new HashSet<String>();
            TypeSpecificListeners typeListener = this.typeListeners.computeIfAbsent(type, t -> new TypeSpecificListeners());
            Set<String> clients = typeListener.extractMap.get(ticketId);
            if (clients != null) {
                for (String clientID : clients) {
                    GUID registeredUserId = typeListener.userMap.get(clientID);
                    if (registeredUserId == null || !registeredUserId.equals((Object)userId)) continue;
                    clientIds.add(clientID);
                }
            }
            return clientIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String type, String clientID, GUID userId, int ticketID, TicketUpdateListener listener) {
        HashMap<String, TypeSpecificListeners> hashMap = this.typeListeners;
        synchronized (hashMap) {
            TypeSpecificListeners typeListener = this.typeListeners.computeIfAbsent(type, t -> new TypeSpecificListeners());
            Integer ticketIDInstance = ticketID;
            typeListener.insertMap.put(clientID, ticketIDInstance);
            Set clients = typeListener.extractMap.computeIfAbsent(ticketIDInstance, k -> new HashSet());
            clients.add(clientID);
            typeListener.listenerMap.put(clientID, listener);
            typeListener.userMap.put(clientID, userId);
            TicketRelatedChangeListener relatedChangeListener = event -> {
                switch (event.getType()) {
                    case "ticketField": {
                        this.sendReloadTicketData(clientID, ticketID, listener, typeListener);
                        break;
                    }
                    case "ticketOwner": {
                        this.sendReloadTicketData(clientID, ticketID, listener, typeListener);
                        break;
                    }
                    case "ticketLink": {
                        break;
                    }
                    case "lastEditor": {
                        this.sendReloadTicketData(clientID, ticketID, listener, typeListener);
                        break;
                    }
                    case "userField": {
                        this.sendReloadTicketData(clientID, ticketID, listener, typeListener);
                        break;
                    }
                    case "reaSteps": {
                        GUID accountID = typeListener.userMap.get(clientID);
                        if (accountID == null) break;
                        try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)accountID);){
                            listener.ticketChanged(clientID, TicketManager.getReader().getTicket(ticketID), null);
                            break;
                        }
                    }
                    default: {
                        TicketListServerPlugin.LOGGER.debug((Object)("No action on ticket related change of type or unknown type: " + event.getType()));
                    }
                }
            };
            TicketRelatedChangeEventDispatcher.getInstance().addListener(ticketID, relatedChangeListener);
            typeListener.ticketRelatedListenerMap.put(clientID, relatedChangeListener);
        }
    }

    private void sendReloadTicketData(String clientID, int ticketID, TicketUpdateListener listener, TypeSpecificListeners typeListener) {
        GUID accountID = typeListener.userMap.get(clientID);
        if (accountID != null) {
            try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)accountID);){
                listener.ticketChanged(clientID, TicketManager.getReader().getTicket(ticketID), Set.of());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(TicketEvent event) {
        for (ChangedTicketVO changed : event.getChangedTickets()) {
            TicketVO newTicket = changed.getNewTicket();
            int id = changed.getTicketID();
            HashMap<String, TypeSpecificListeners> hashMap = this.typeListeners;
            synchronized (hashMap) {
                for (TypeSpecificListeners typeListener : this.typeListeners.values()) {
                    Set<String> clients = typeListener.extractMap.get(id);
                    if (clients == null) continue;
                    for (String clientID : clients) {
                        TicketUpdateListener listener = typeListener.listenerMap.get(clientID);
                        if (listener == null) continue;
                        UserAccountScope userAccountScope = UserAccountScope.create((GUID)typeListener.userMap.get(clientID));
                        try {
                            listener.ticketChanged(clientID, newTicket, changed.getReaStepIDs());
                        }
                        finally {
                            if (userAccountScope == null) continue;
                            userAccountScope.close();
                        }
                    }
                }
            }
        }
    }

    private static final class TypeSpecificListeners {
        private final HashMap<String, Integer> insertMap = new HashMap();
        private final HashMap<String, GUID> userMap = new HashMap();
        private final HashMap<Integer, Set<String>> extractMap = new HashMap();
        private final HashMap<String, TicketUpdateListener> listenerMap = new HashMap();
        private final HashMap<String, TicketRelatedChangeListener> ticketRelatedListenerMap = new HashMap();

        private TypeSpecificListeners() {
        }
    }
}

