/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewVisibility;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.SaveTicketViewSortSettingsRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.data.SortDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketViewDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketViewGroups;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.logging.LogManager;
import com.inet.usersandgroups.api.ui.fields.values.MemberEntry;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SaveTicketViewSortSettingsHandler
extends AbstractTicketListHandler<SaveTicketViewSortSettingsRequestData, Void> {
    public String getMethodName() {
        return "ticketlist.saveticketviewsortsettings";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, SaveTicketViewSortSettingsRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        TicketViewManager tvm = TicketViewManager.getInstance();
        ArrayList<String> newCreatedIds = input.getNewCreatedIds();
        ArrayList<SortDescription> sortDescriptions = input.getTicketViewSortDescriptions();
        ArrayList<TicketViewDescription> putTicketViewDescriptions = input.getPutTicketViewDescriptions();
        ArrayList<String> removeViewSortDescriptionIDs = input.getRemoveViewSortDescriptionIDs();
        AttachmentDescription[] attachments = input.getAttachments();
        ArrayList<String> viewIconReset = input.getViewIconReset();
        List viewDefinitions = tvm.getViewDefinitions();
        ArrayList changedDefinitions = new ArrayList();
        viewDefinitions.stream().filter(d -> viewIconReset.contains(d.getID())).forEach(d -> changedDefinitions.add(d));
        changedDefinitions.stream().filter(d -> d instanceof CustomTicketViewDefinition).forEach(d -> ((CustomTicketViewDefinition)d).resetViewIcon());
        changedDefinitions.stream().filter(d -> d instanceof CustomTicketViewDefinition).forEach(d -> tvm.putView((CustomTicketViewDefinition)d));
        HashMap<String, byte[]> imagemap = new HashMap<String, byte[]>();
        if (attachments != null && attachments.length > 0) {
            try {
                for (int i = 0; i < attachments.length; ++i) {
                    TicketViewDescription viewDesc = putTicketViewDescriptions.get(i);
                    Part part = request.getPart("attachment" + i);
                    if (part == null) continue;
                    try (InputStream stream = part.getInputStream();){
                        byte[] scaledImage = SaveTicketViewSortSettingsHandler.createScaledImage(stream, 16, 16);
                        imagemap.put(viewDesc.getId(), scaledImage);
                        continue;
                    }
                    catch (Exception e) {
                        TicketListServerPlugin.LOGGER.error((Throwable)e);
                    }
                }
            }
            catch (ServletException e) {
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.viewsettings.noimage", new Object[0]));
            }
            catch (IOException e) {
                TicketListServerPlugin.LOGGER.error((Throwable)e);
            }
        }
        newCreatedIds.forEach(id -> {
            String newID = GUID.generateNew().toString();
            if (putTicketViewDescriptions != null) {
                putTicketViewDescriptions.forEach(d -> {
                    if (d.getId().equals(id)) {
                        d.setId(newID);
                        imagemap.put(newID, (byte[])imagemap.get(id));
                    }
                });
            }
            if (sortDescriptions != null) {
                sortDescriptions.forEach(d -> {
                    if (d.getId().equals(id)) {
                        d.setId(newID);
                    }
                });
            }
        });
        if (putTicketViewDescriptions != null) {
            putTicketViewDescriptions.stream().forEach(o -> {
                String subViewGroupingKey = o.getSubGrouping();
                tvm.putView(tvm.createCustomView(o.getId(), o.getParentId(), o.getRawDisplayName(), o.getRawDescription(), o.getSearchCommand(), subViewGroupingKey, o.isTokenizeGroupingValues(), o.isHideSubnodeTickets(), o.getGroups() == null ? null : this.toGroupsModel(o.getGroups()), imagemap.get(o.getId()) != null ? (byte[])imagemap.get(o.getId()) : null, o.getOriginalCreator()));
            });
        }
        if (removeViewSortDescriptionIDs != null) {
            removeViewSortDescriptionIDs.stream().forEach(o -> tvm.removeView(o));
        }
        ArrayList visibility = new ArrayList();
        sortDescriptions.stream().forEach(o -> visibility.add(new TicketViewVisibility(o.getId(), o.isVisible())));
        tvm.setViewVisibilities(visibility);
        return null;
    }

    private ArrayList<String> toGroupsModel(TicketViewGroups groups) {
        if (groups.getValue() == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String jvalue = groups.getValue();
        ArrayList targetValue = (ArrayList)new Json().fromJson(jvalue, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{MemberEntry.class}));
        targetValue.stream().forEach(o -> result.add(o.getGuid().toString()));
        return result;
    }

    public static byte[] createScaledImage(InputStream imageStream, int width, int height) throws Exception {
        ByteArrayOutputStream out;
        block32: {
            out = new ByteArrayOutputStream();
            BufferedImage image = null;
            if (imageStream != null) {
                int orientation = -1;
                try (ImageInputStream stream = ImageIO.createImageInputStream(imageStream);){
                    block31: {
                        ImageReader next;
                        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
                        if (imageReaders != null && imageReaders.hasNext() && (next = imageReaders.next()) != null) {
                            next.setInput(stream);
                            int imageCount = next.getNumImages(true);
                            if (imageCount > 0) {
                                image = next.read(0);
                            }
                            try {
                                IIOMetadata imageMetadata = next.getImageMetadata(0);
                                if (!imageMetadata.isStandardMetadataFormatSupported()) break block31;
                                Node metaTree = imageMetadata.getAsTree("javax_imageio_jpeg_image_1.0");
                                NodeList childNodes = metaTree.getChildNodes();
                                for (int i = 0; i < childNodes.getLength(); ++i) {
                                    if ("markerSequence".equals(childNodes.item(i).getNodeName())) {
                                        NodeList markerSequenceChildren = childNodes.item(i).getChildNodes();
                                        for (int j = 0; j < markerSequenceChildren.getLength(); ++j) {
                                            IIOMetadataNode metadataNode = (IIOMetadataNode)markerSequenceChildren.item(j);
                                            byte[] bytes = (byte[])metadataNode.getUserObject();
                                            if (bytes == null) continue;
                                            byte[] magicNumber = new byte[4];
                                            ByteBuffer.wrap(bytes).get(magicNumber);
                                            if (orientation != -1) break;
                                        }
                                    }
                                    if (orientation == -1) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable iae) {
                                LogManager.getApplicationLogger().debug((Object)"Error reading user image meta data");
                                LogManager.getApplicationLogger().debug((Object)iae);
                            }
                        }
                    }
                    if (image != null) {
                        int oldw = image.getWidth();
                        int oldh = image.getHeight();
                        if (orientation != -1) {
                            AffineTransform t = new AffineTransform();
                            switch (orientation) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    t.scale(-1.0, 1.0);
                                    t.translate(-oldw, 0.0);
                                    break;
                                }
                                case 3: {
                                    t.translate(oldw, oldh);
                                    t.rotate(Math.PI);
                                    break;
                                }
                                case 4: {
                                    t.scale(1.0, -1.0);
                                    t.translate(0.0, -oldh);
                                    break;
                                }
                                case 5: {
                                    t.rotate(-1.5707963267948966);
                                    t.scale(-1.0, 1.0);
                                    break;
                                }
                                case 6: {
                                    t.translate(oldh, 0.0);
                                    t.rotate(1.5707963267948966);
                                    break;
                                }
                                case 7: {
                                    t.scale(-1.0, 1.0);
                                    t.translate(-oldh, 0.0);
                                    t.translate(0.0, oldw);
                                    t.rotate(4.71238898038469);
                                    break;
                                }
                                case 8: {
                                    t.translate(0.0, oldw);
                                    t.rotate(4.71238898038469);
                                    break;
                                }
                            }
                            AffineTransformOp op = new AffineTransformOp(t, 3);
                            BufferedImage tempImage = op.createCompatibleDestImage(image, image.getType() == 10 ? image.getColorModel() : null);
                            Graphics2D g = (Graphics2D)tempImage.getGraphics();
                            g.setTransform(t);
                            g.drawImage((Image)image, 0, 0, null);
                            g.dispose();
                            image = tempImage;
                            oldw = image.getWidth();
                            oldh = image.getHeight();
                        }
                        double widthRatio = (double)oldw / (double)width;
                        double heightRatio = (double)oldh / (double)height;
                        if (widthRatio > 1.0 || heightRatio > 1.0) {
                            double finalRatio = 0.0;
                            finalRatio = widthRatio >= heightRatio ? heightRatio / widthRatio : widthRatio / heightRatio;
                            BufferedImage tempImage = new BufferedImage(width, height, 2);
                            Graphics2D tg = (Graphics2D)tempImage.getGraphics();
                            tg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                            tg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                            tg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            tg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            if (widthRatio >= heightRatio) {
                                int h = Double.valueOf((double)height * finalRatio).intValue();
                                tg.drawImage(image, 0, (height - h) / 2, width, h + (height - h) / 2, 0, 0, oldw, oldh, null);
                            } else {
                                int w = Double.valueOf((double)width * finalRatio).intValue();
                                tg.drawImage(image, (width - w) / 2, 0, w + (width - w) / 2, height, 0, 0, oldw, oldh, null);
                            }
                            tg.dispose();
                            image = tempImage;
                        } else {
                            BufferedImage tempImage = new BufferedImage(width, height, 2);
                            Graphics2D tg = (Graphics2D)tempImage.getGraphics();
                            Double hw = (width - oldw) / 2;
                            Double hh = (height - oldh) / 2;
                            tg.drawImage(image, hw.intValue(), hh.intValue(), Double.valueOf((double)oldw + hw).intValue(), Double.valueOf((double)oldh + hh).intValue(), 0, 0, oldw, oldh, null);
                            tg.dispose();
                            image = tempImage;
                        }
                        ImageIO.write((RenderedImage)image, "PNG", out);
                        break block32;
                    }
                    byte[] byArray = null;
                    return byArray;
                }
            }
        }
        return out.toByteArray();
    }
}

