/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.PageSettings;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketFieldVisibility;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageSettingsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.event.FieldDisplayHelper;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettingManager;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class TicketPageSettings
extends TicketListWebSocketEvent<Void> {
    public String getEventName() {
        return "ticketlist.ticketpagesettings";
    }

    @Override
    protected void handleEvent(String clientID, Void payload) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        PageSettings pageSetting = TicketPageSettings.getPageSettings(currentUserAccount);
        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData(this.getEventName(), (Object)new TicketPageSettingsResponse(pageSetting)));
    }

    @Nonnull
    public static PageSettings getPageSettings(UserAccount userAccount) {
        String pageSettingValueUser = userAccount == null ? null : (String)userAccount.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_PAGESETTING);
        String pageSettingValueDefault = UserFieldsWithClientSettingManager.getInstance().getDefaultValueForUserField(TicketListServerPlugin.USERFIELD_TICKETLIST_PAGESETTING);
        PageSettings pageSetting = new PageSettings();
        if (!StringFunctions.isEmpty((String)pageSettingValueDefault)) {
            pageSetting.merge((PageSettings)new Json().fromJson(pageSettingValueDefault, PageSettings.class));
        }
        if (!StringFunctions.isEmpty((String)pageSettingValueUser)) {
            pageSetting.merge((PageSettings)new Json().fromJson(pageSettingValueUser, PageSettings.class));
        }
        ArrayList<TicketFieldVisibility> newHiddenTicketFields = FieldDisplayHelper.getHiddenTicketTicketFields(pageSetting);
        pageSetting.setHiddenTicketFields(newHiddenTicketFields);
        ArrayList<TicketFieldVisibility> newHiddenTicketOwnerFields = FieldDisplayHelper.getHiddenTicketOwnerFields(pageSetting);
        pageSetting.setHiddenTicketOwnerFields(newHiddenTicketOwnerFields);
        return pageSetting;
    }
}

