/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.ticketlist.server.data.SidebarSettings;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketFieldVisibility;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.UsersAndGroups;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonData
public class PageSettings {
    private String stepsFilter = "none";
    private String extension_timeline_highlight = null;
    private List<String> extension_timeline_visibleStepDetails = new ArrayList<String>(){
        {
            this.add("description");
            this.add("emailSenderAddress");
            this.add("emailReceiverAddresses");
        }
    };
    private boolean extension_timeline_wrapdetails = false;
    private String extension_attachments_layout = "tiles";
    private String extension_attachments_sorting = "-lastModified";
    private boolean extension_attachments_showembedded = false;
    private boolean extension_attachments_showduplicates = false;
    private boolean showExtensions = true;
    private boolean hideDuplicateContent = true;
    private int extensionsPanelWidth = 30;
    private int editorPanelHeight = 65;
    private boolean relativeTime = true;
    private SidebarSettings sidebarsettings = new SidebarSettings();
    private HashMap<String, Boolean> collapsedExtensions = new HashMap();
    private ArrayList<TicketFieldVisibility> hiddenTicketFields = new ArrayList<TicketFieldVisibility>(){
        {
            this.add(new TicketFieldVisibility(Tickets.FIELD_OWNER_GUID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_INQUIRY_DATE.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_LAST_CHANGED.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_LAST_CHANGED_BY_GUID.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_LAST_EDITOR_GUID.getKey(), true));
            this.add(new TicketFieldVisibility("ticketid", true));
            this.add(new TicketFieldVisibility("ticketid-reference", true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_ATTACHMENTS.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_STATUS_ID.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.FIELD_SUBJECT.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_PRIORITY_ID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_CATEGORY_ID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_RESOURCE_GUID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_CLASSIFICATION_ID.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_ITIL_ID.getKey(), false));
            this.add(new TicketFieldVisibility("itillinkcount", true));
            this.add(new TicketFieldVisibility("custom1", false));
            this.add(new TicketFieldVisibility("custom2", false));
            this.add(new TicketFieldVisibility("custom3", false));
            this.add(new TicketFieldVisibility("custom4", false));
            this.add(new TicketFieldVisibility("custom5", false));
            this.add(new TicketFieldVisibility("custom6", false));
            this.add(new TicketFieldVisibility("custom7", false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_IDENTIFIER.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_AUTO_CC.getKey(), true));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_SUM_TIME.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_TARGET_TIME.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.FIELD_DEADLINE.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_WIEDERVORLAGEDATE.getKey(), false));
            this.add(new TicketFieldVisibility(Tickets.ATTRIBUTE_TERMINVEREINBARUNG.getKey(), false));
            this.add(new TicketFieldVisibility("processid", false));
            this.add(new TicketFieldVisibility("processtask", false));
            this.add(new TicketFieldVisibility("preview", true));
        }
    };
    private ArrayList<TicketFieldVisibility> hiddenTicketOwnerFields = new ArrayList<TicketFieldVisibility>(){
        {
            this.add(new TicketFieldVisibility("ticketowner." + UsersAndGroups.FIELD_FIRSTNAME.getKey(), false));
            this.add(new TicketFieldVisibility("ticketowner." + UsersAndGroups.FIELD_LASTNAME.getKey(), false));
            this.add(new TicketFieldVisibility("ticketowner." + UsersAndGroups.FIELD_TELEPHONE.getKey(), true));
            this.add(new TicketFieldVisibility("ticketowner." + UsersAndGroups.FIELD_EMAIL.getKey(), true));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_CLASS_ID.getKey(), false));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_LOCATION_ID.getKey(), false));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_LOCATION_ID.getKey() + ".info", true));
            this.add(new TicketFieldVisibility("ticketowner.department", false));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_COST_CENTRE.getKey(), false));
            this.add(new TicketFieldVisibility("ticketowner." + HDUsersAndGroups.FIELD_COMPUTER_NAME.getKey(), false));
            this.add(new TicketFieldVisibility("ticketowner.custom1", false));
            this.add(new TicketFieldVisibility("ticketowner.custom2", false));
            this.add(new TicketFieldVisibility("ticketowner.custom3", false));
            this.add(new TicketFieldVisibility("ticketowner.custom4", true));
            this.add(new TicketFieldVisibility("ticketowner.custom5", true));
            this.add(new TicketFieldVisibility("ticketowner.custom6", true));
        }
    };

    public ArrayList<TicketFieldVisibility> getHiddenTicketFields() {
        return this.hiddenTicketFields;
    }

    public void setHiddenTicketFields(ArrayList<TicketFieldVisibility> hiddenTicketFields) {
        this.hiddenTicketFields = hiddenTicketFields;
    }

    public ArrayList<TicketFieldVisibility> getHiddenTicketOwnerFields() {
        return this.hiddenTicketOwnerFields;
    }

    public void setHiddenTicketOwnerFields(ArrayList<TicketFieldVisibility> hiddenTicketOwnerFields) {
        this.hiddenTicketOwnerFields = hiddenTicketOwnerFields;
    }

    public String getStepFilter() {
        return this.stepsFilter;
    }

    public boolean isHideDuplicateContent() {
        return this.hideDuplicateContent;
    }

    public void merge(PageSettings p) {
        this.collapsedExtensions = p.collapsedExtensions;
        this.extension_attachments_layout = p.extension_attachments_layout;
        this.extension_attachments_showduplicates = p.extension_attachments_showduplicates;
        this.extension_attachments_showembedded = p.extension_attachments_showembedded;
        this.extension_attachments_sorting = p.extension_attachments_sorting;
        this.extension_timeline_highlight = p.extension_timeline_highlight;
        this.extensionsPanelWidth = p.extensionsPanelWidth;
        this.editorPanelHeight = p.editorPanelHeight;
        this.extension_timeline_visibleStepDetails = p.extension_timeline_visibleStepDetails;
        this.extension_timeline_wrapdetails = p.extension_timeline_wrapdetails;
        ArrayList<TicketFieldVisibility> oldHiddenField = this.hiddenTicketFields;
        this.hiddenTicketFields = p.hiddenTicketFields;
        if (oldHiddenField != null && this.hiddenTicketFields != null) {
            for (TicketFieldVisibility tfv : oldHiddenField) {
                if (this.hiddenTicketFields.contains(tfv)) continue;
                this.hiddenTicketFields.add(tfv);
            }
        }
        oldHiddenField = this.hiddenTicketOwnerFields;
        this.hiddenTicketOwnerFields = p.hiddenTicketOwnerFields;
        if (oldHiddenField != null && this.hiddenTicketOwnerFields != null) {
            for (TicketFieldVisibility tfv : oldHiddenField) {
                if (this.hiddenTicketOwnerFields.contains(tfv)) continue;
                this.hiddenTicketOwnerFields.add(tfv);
            }
        }
        this.showExtensions = p.showExtensions;
        this.hideDuplicateContent = p.hideDuplicateContent;
        this.sidebarsettings = p.sidebarsettings;
        this.stepsFilter = p.stepsFilter;
        this.relativeTime = p.relativeTime;
    }
}

