/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ai.suggest;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.plugins.knowledgebase.api.Article;
import com.inet.helpdesk.plugins.knowledgebase.api.KnowledgeBaseConnector;
import com.inet.helpdesk.plugins.ticketlist.server.ai.TicketListAIStructureProvider;
import com.inet.helpdesk.plugins.ticketlist.server.ai.suggest.SuggestAIUtils;
import com.inet.helpdesk.plugins.ticketlist.server.ai.suggest.SuggestExecuter;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ai.api.AITool;
import com.inet.plugin.ai.api.AIToolException;
import com.inet.search.FuzzySearch;
import com.inet.search.SearchTag;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FindEmailAnswerPairsAITool
implements AITool {
    static final String NAME = "find_email_answer_pairs";
    private static final String KEYWORDS = "keywords";
    private static final int MAX_STEP_SIZE = 10000;
    private static final ConfigValue<String> SUGGEST_SOURCE = new ConfigValue(TicketListAIStructureProvider.AI_SUGGEST_SOURCE);
    private static final ConfigValue<Integer> SUGGEST_CONTEXT_SIZE = new ConfigValue(TicketListAIStructureProvider.AI_SUGGEST_CONTEXT_SIZE);
    private SuggestExecuter executer;

    FindEmailAnswerPairsAITool(SuggestExecuter executer) {
        this.executer = executer;
    }

    @Nonnull
    public String getName() {
        return NAME;
    }

    @Nonnull
    public String getDescription() {
        return "Searches content for answerable segments using indexed keyword matching";
    }

    @Nonnull
    public @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
    @Nonnull AITool.ParameterDescription> getRequiredParameters() {
        return List.of(new AITool.ParameterDescription(KEYWORDS, "The list of possible keywords. Also add synonyms for a better result.", AITool.ParameterType.string));
    }

    @Nonnull
    public @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
    @Nonnull AITool.ParameterDescription> getOptionalParameters() {
        return List.of();
    }

    @Nullable
    public String call(@Nonnull Map<String, Object> parameters) throws AIToolException {
        ArrayList<Pair> emailAnswers;
        String keywords = parameters.getOrDefault(KEYWORDS, "").toString();
        TicketListAIStructureProvider.LOGGER.debug("Keywords: ", (Object)keywords);
        ArrayList<Pair> kbAnswers = switch ((String)SUGGEST_SOURCE.get()) {
            case "ticketlist" -> new ArrayList<Pair>();
            default -> TicketListAIStructureProvider.KB_PLUGIN_ENABLED && SystemPermissionChecker.checkAccess((Permission)Permission.valueOf((String)"knowledgeBase")) ? this.getPairsFromKnowledgebase(keywords) : new ArrayList();
        };
        block10 : switch ((String)SUGGEST_SOURCE.get()) {
            case "knowledgebase": {
                emailAnswers = new ArrayList<Pair>();
                break;
            }
            default: {
                TicketReader ticketReader = TicketManager.getReader();
                IndexSearchEngine searchEngine = ticketReader.getSearchEngine();
                SearchTag reaStepSearchTag = Objects.requireNonNull(searchEngine.getTag("reastepids"));
                IndexSearchEngine reaStepSearchEngine = ticketReader.getReaStepSearchEngine();
                SearchCommand baseCommand = new SearchCommand("reastepactionid", SearchCondition.SearchTermOperator.IN, List.of(Integer.valueOf(-9), Integer.valueOf(4)));
                FuzzySearch search = new FuzzySearch(reaStepSearchEngine, baseCommand, new String[]{"reasteptext"});
                List steps = search.search(keywords);
                HashSet<Integer> knownTickets = new HashSet<Integer>();
                knownTickets.add(this.executer.getTicketId());
                emailAnswers = new ArrayList();
                for (Integer reaStepID : steps) {
                    Integer answerStepId;
                    String answer;
                    Set set;
                    String mail;
                    ReaStepVO reaStep;
                    if (this.executer.getReaStepID() == reaStepID.intValue()) continue;
                    try {
                        reaStep = ticketReader.getReaStep(reaStepID.intValue());
                    }
                    catch (AccessDeniedException ade) {
                        continue;
                    }
                    if (!knownTickets.add(reaStep.getBunID()) || (mail = SuggestAIUtils.getReaStepContent(reaStepID)) == null || (mail = HtmlConverter.html2text((String)mail)).isBlank() || mail.length() > 10000 || (set = searchEngine.simpleSearch(new SearchCommand("reastepids", SearchCondition.SearchTermOperator.Equals, (Object)reaStepID))).isEmpty()) continue;
                    Integer ticketID = (Integer)set.iterator().next();
                    HashSet<Integer> nextSteps = new HashSet<Integer>();
                    Iterator it = searchEngine.createValuesIterator(reaStepSearchTag, null, id -> ticketID.equals(id));
                    while (it.hasNext()) {
                        Integer next = (Integer)it.next();
                        if (next <= reaStepID) continue;
                        nextSteps.add(next);
                    }
                    SearchCommand cmd = new SearchCommand(new SearchExpression[]{new PrefilteredSearchExpression(nextSteps), new SearchCondition("reastepactionid", SearchCondition.SearchTermOperator.Equals, (Object)-7)});
                    set = reaStepSearchEngine.simpleSearch(cmd);
                    if (set.isEmpty() || (answer = SuggestAIUtils.getReaStepContent(answerStepId = (Integer)set.iterator().next())) == null || (answer = HtmlConverter.html2text((String)answer)).isBlank() || answer.length() > 10000) continue;
                    emailAnswers.add(new Pair(mail, answer));
                    if ((Integer)SUGGEST_CONTEXT_SIZE.get() > emailAnswers.size()) continue;
                    break block10;
                }
            }
        }
        this.executer.setKnowledgeBase(switch ((String)SUGGEST_SOURCE.get()) {
            case "knowledgebase" -> kbAnswers;
            case "ticketlist" -> emailAnswers;
            default -> this.merge(kbAnswers, emailAnswers);
        });
        return null;
    }

    @Nonnull
    private List<Pair> getPairsFromKnowledgebase(@Nonnull String keywords) throws AIToolException {
        KnowledgeBaseConnector knowledgebase = (KnowledgeBaseConnector)ServerPluginManager.getInstance().getSingleInstance(KnowledgeBaseConnector.class);
        FuzzySearch search = knowledgebase.createFuzzySearch(new Article.ArticleKeys[]{Article.ArticleKeys.ARTICLE_PROBLEM, Article.ArticleKeys.ARTICLE_TITLE});
        List articles = search.search(keywords);
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (Integer articleId : articles) {
            try {
                Article article = knowledgebase.getArticle(articleId.intValue());
                String problem = HtmlConverter.html2text((String)article.getProblem());
                String answer = HtmlConverter.html2text((String)article.getSolution());
                if (StringFunctions.isEmpty((String)problem)) {
                    problem = article.getTitle();
                }
                pairs.add(new Pair(problem, answer));
                if ((Integer)SUGGEST_CONTEXT_SIZE.get() > pairs.size()) continue;
                break;
            }
            catch (ServerDataException ex) {
                throw (RuntimeException)ErrorCode.throwAny((Throwable)ex);
            }
        }
        return pairs;
    }

    @Nonnull
    private List<Pair> merge(List<Pair> list1, List<Pair> list2) {
        if (list1 == null) {
            list1 = List.of();
        }
        if (list2 == null) {
            list2 = List.of();
        }
        ArrayList<Pair> merged = new ArrayList<Pair>();
        int maxSize = Math.max(list1.size(), list2.size());
        for (int i = 0; i < maxSize; ++i) {
            if (i < list1.size()) {
                merged.add(list1.get(i));
            }
            if (i >= list2.size()) continue;
            merged.add(list2.get(i));
        }
        if ((Integer)SUGGEST_CONTEXT_SIZE.get() < merged.size()) {
            merged.subList((Integer)SUGGEST_CONTEXT_SIZE.get(), merged.size()).clear();
        }
        return merged;
    }

    @JsonData
    record Pair(@Nonnull String customerQuestion, @Nonnull String supporterAnswer) {
    }
}

