/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.api.handler;

import com.inet.annotations.InternalApi;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.data.SelectOptionsRequest;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@InternalApi
public class GetSelectOptions
extends ServiceMethod<SelectOptionsRequest, SelectOptionResult> {
    public String getMethodName() {
        return "ticketlist.selectoptions";
    }

    public SelectOptionResult invoke(HttpServletRequest request, HttpServletResponse response, SelectOptionsRequest input) {
        FieldEditDefinition editDefinition;
        TicketFieldDefinition fieldDefinition = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class).stream().filter(tfd -> tfd.getKey().equals(input.getFieldKey())).findFirst().orElse(null);
        if (fieldDefinition != null && (editDefinition = fieldDefinition.getEditDefinition()) instanceof SelectEditDefinition) {
            List tickets = null;
            List<Integer> ticketIds = input.getTicketIds();
            if (ticketIds != null && !ticketIds.isEmpty()) {
                tickets = ticketIds.stream().filter(tId -> tId != null).map(tId -> TicketManager.getReader().getTicket(tId.intValue())).collect(Collectors.toList());
            }
            return ((SelectEditDefinition)editDefinition).getSelectOptions(tickets, input.getSearchTerm(), input.getChunkSize(), input.getCurrentSize());
        }
        return new SelectOptionResult(0, Collections.emptyList());
    }

    public short getMethodType() {
        return 1;
    }
}

