/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.reporting;

import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.PageSettings;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketFieldVisibility;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageExtensionDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout.TicketPageLayoutManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettingManager;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ReportingTicketListFunctions
implements UserDefinedFunction {
    private static MemoryStoreMap<UserAccount, List<String>> mapVisiblityTicketList = new MemoryStoreMap(30, false);
    private static MemoryStoreMap<UserAccount, List<String>> mapVisiblityTicketPage = new MemoryStoreMap(30, false);

    public String[] getAllAvailableColumns() throws ServerDataException {
        List<TicketListColumnDescription> allAvailableColumns = TicketListLayoutManager.getInstance().getAllAvailableColumns(true);
        ArrayList allColumnsNames = new ArrayList();
        allAvailableColumns.forEach(c -> allColumnsNames.add(c.getDisplayName()));
        return allColumnsNames.toArray(new String[0]);
    }

    public String[] getVisibleColumns() throws ServerDataException {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return new String[0];
        }
        TicketListLayoutDescription currentLayout = TicketListLayoutManager.getInstance().getCurrentLayout(currentUserAccount.getID());
        ArrayList<TicketListColumnDescription> columnsNames = new ArrayList<TicketListColumnDescription>();
        if (currentLayout.getIdentifierColumns() != null && currentLayout.getIdentifierColumns().size() > 0) {
            columnsNames.addAll(currentLayout.getIdentifierColumns());
        }
        if (currentLayout.getAdditionalColumns() != null && currentLayout.getAdditionalColumns().size() > 0) {
            columnsNames.addAll(currentLayout.getAdditionalColumns());
        }
        if (currentLayout.getFixedColumns() != null && currentLayout.getFixedColumns().size() > 0) {
            columnsNames.addAll(currentLayout.getFixedColumns());
        }
        return columnsNames.toArray(new String[0]);
    }

    private static void initVisibilitiesForTicketPage(UserAccount currentUserAccount) {
        ArrayList<TicketFieldVisibility> hiddenTicketOwnerFields;
        if (mapVisiblityTicketPage.containsKey((Object)currentUserAccount)) {
            return;
        }
        TicketPageLayoutDescription currentLayout = TicketPageLayoutManager.getInstance().getCurrentLayout(currentUserAccount.getID());
        boolean ticketPageExtension = false;
        for (TicketPageExtensionDescription ext : currentLayout.getExtensions()) {
            if (!ext.getId().equalsIgnoreCase("ticketdetails")) continue;
            ticketPageExtension = true;
            break;
        }
        if (!ticketPageExtension) {
            return;
        }
        List ticketFieldDefinitions = Tickets.getFieldsVisibleForUser();
        ArrayList defList = new ArrayList();
        ticketFieldDefinitions.forEach(entry -> defList.add(entry.getKey()));
        String pageSettingValueUser = (String)currentUserAccount.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_PAGESETTING);
        String pageSettingValueDefault = UserFieldsWithClientSettingManager.getInstance().getDefaultValueForUserField(TicketListServerPlugin.USERFIELD_TICKETLIST_PAGESETTING);
        PageSettings pageSetting = new PageSettings();
        if (!StringFunctions.isEmpty((String)pageSettingValueDefault)) {
            pageSetting.merge((PageSettings)new Json().fromJson(pageSettingValueDefault, PageSettings.class));
        }
        if (!StringFunctions.isEmpty((String)pageSettingValueUser)) {
            pageSetting.merge((PageSettings)new Json().fromJson(pageSettingValueUser, PageSettings.class));
        }
        ArrayList fieldKeys = new ArrayList();
        ArrayList<TicketFieldVisibility> hiddenTicketFields = pageSetting.getHiddenTicketFields();
        if (hiddenTicketFields != null) {
            hiddenTicketFields.forEach(field -> {
                if (!field.isHidden() && defList.contains(field.getTicketFieldKey())) {
                    fieldKeys.add(field.getTicketFieldKey());
                }
            });
        }
        if ((hiddenTicketOwnerFields = pageSetting.getHiddenTicketOwnerFields()) != null) {
            hiddenTicketOwnerFields.forEach(field -> {
                if (!field.isHidden() && defList.contains(field.getTicketFieldKey())) {
                    fieldKeys.add(field.getTicketFieldKey());
                }
            });
        }
        mapVisiblityTicketPage.put((Object)currentUserAccount, fieldKeys);
    }

    public static boolean isTicketDetailsVisible() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        TicketPageLayoutDescription currentLayout = TicketPageLayoutManager.getInstance().getCurrentLayout(currentUserAccount.getID());
        boolean ticketPageExtension = currentLayout.getExtensions().stream().anyMatch(ext -> "ticketdetails".equalsIgnoreCase(ext.getId()));
        if (!ticketPageExtension) {
            return false;
        }
        ReportingTicketListFunctions.initVisibilitiesForTicketPage(currentUserAccount);
        ticketPageExtension = ((List)mapVisiblityTicketPage.get((Object)currentUserAccount)).stream().anyMatch(ext -> !ext.startsWith("ticketowner.") && !ext.startsWith("subject"));
        return ticketPageExtension;
    }

    public static boolean isFieldVisibleInTicketPage(String column) {
        if (column == null) {
            return false;
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        ReportingTicketListFunctions.initVisibilitiesForTicketPage(currentUserAccount);
        if (mapVisiblityTicketPage.get((Object)currentUserAccount) == null) {
            return false;
        }
        return ((List)mapVisiblityTicketPage.get((Object)currentUserAccount)).contains(column);
    }

    public static boolean isVisibleTicketOwnerExtension() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        TicketPageLayoutDescription currentLayout = TicketPageLayoutManager.getInstance().getCurrentLayout(currentUserAccount.getID());
        boolean ticketPageExtension = false;
        for (TicketPageExtensionDescription ext : currentLayout.getExtensions()) {
            if (!ext.getId().equalsIgnoreCase("ticketowner")) continue;
            ServerPluginManager spm = ServerPluginManager.getInstance();
            TicketPageExtension inst = (TicketPageExtension)spm.getSingleInstanceByName(TicketPageExtension.class, "ticketowner", false);
            ticketPageExtension = inst.isAvailable(currentUserAccount);
            break;
        }
        return ticketPageExtension;
    }

    public static boolean isFieldVisibleInTicketOwnerExtension(String column) {
        return Optional.ofNullable(column).map(c -> UserManager.getInstance().getCurrentUserAccount()).map(u -> {
            ReportingTicketListFunctions.initVisibilitiesForTicketPage(u);
            return (List)mapVisiblityTicketPage.get(u);
        }).map(visibilities -> visibilities.contains(column)).orElse(Boolean.FALSE);
    }

    private static void initVisibilitiesForTicketList(UserAccount currentUserAccount) {
        if (mapVisiblityTicketList.containsKey((Object)currentUserAccount)) {
            return;
        }
        ArrayList visibleCols = new ArrayList();
        TicketListLayoutDescription currentLayout = TicketListLayoutManager.getInstance().getCurrentLayout(currentUserAccount.getID());
        ArrayList<TicketListColumnDescription> columnsNames = new ArrayList<TicketListColumnDescription>();
        if (currentLayout.getIdentifierColumns() != null && currentLayout.getIdentifierColumns().size() > 0) {
            columnsNames.addAll(currentLayout.getIdentifierColumns());
        }
        if (currentLayout.getFixedColumns() != null && currentLayout.getFixedColumns().size() > 0) {
            columnsNames.addAll(currentLayout.getFixedColumns());
        }
        if (currentLayout.getAdditionalColumns() != null && currentLayout.getAdditionalColumns().size() > 0) {
            columnsNames.addAll(currentLayout.getAdditionalColumns());
        }
        columnsNames.forEach(col -> visibleCols.add(col.getKey()));
        mapVisiblityTicketList.put((Object)currentUserAccount, visibleCols);
    }

    public static boolean isFieldVisibleInTicketList(String column) {
        if (column == null) {
            return false;
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        ReportingTicketListFunctions.initVisibilitiesForTicketList(currentUserAccount);
        return ((List)mapVisiblityTicketList.get((Object)currentUserAccount)).contains(column);
    }

    public static Integer[] getVisibleReaStepIDs(Integer ticketID) throws ServerDataException {
        PageSettings settings;
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null || ticketID == null) {
            return new Integer[]{0};
        }
        TicketReader ticketReader = TicketManager.getReader();
        List reaStepVOs = ticketReader.getReaStepsForTicket(ticketID.intValue(), BundleStepsFilter.WITH_BUNDLE_STEPS);
        String value = (String)currentUserAccount.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_PAGESETTING);
        String stepFilter = "none";
        if (value != null && !value.isEmpty() && (settings = (PageSettings)new Json().fromJson(value, PageSettings.class)) != null) {
            stepFilter = settings.getStepFilter();
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        block9: for (ReaStepVO step : reaStepVOs) {
            switch (stepFilter) {
                case "nonconversation": {
                    if (!step.hasText() && step.getActionID() != 4) continue block9;
                    ids.add(step.getID());
                    continue block9;
                }
                case "system": {
                    if (TicketFunctions.getUserIdentifierFromStep(step) == null && step.getActionID() != 4) continue block9;
                    ids.add(step.getID());
                    continue block9;
                }
            }
            ids.add(step.getID());
        }
        return ids.toArray(new Integer[ids.size()]);
    }

    public static boolean isSupporter() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        return HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public static boolean isSupporterNamesAllowed() {
        String string = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.CLIENT_ENDUSER_SHOWBEARBEITER);
        return Boolean.TRUE.toString().equalsIgnoreCase(string);
    }

    public static String getTicketStepContent(Integer ticketID, Integer stepID) {
        String content = "";
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return content;
        }
        TicketReader ticketReader = TicketManager.getReader();
        List reaStepVOs = ticketReader.getReaStepsForTicket(ticketID.intValue(), BundleStepsFilter.WITH_BUNDLE_STEPS);
        for (ReaStepVO step : reaStepVOs) {
            if (step.getID() != stepID.intValue()) continue;
            content = ticketReader.getReaStepText(step.getID()).getText();
            break;
        }
        return content;
    }

    public static String getLastTicketStepContent(Integer ticketID) {
        String content = "";
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return content;
        }
        TicketFunctions.PreviewInformation ticketPreviewInformation = TicketFunctions.getTicketPreviewInformation(ticketID, true, true);
        return ticketPreviewInformation.getPreviewText();
    }
}

