/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.help;

import com.inet.help.api.HelpPageContentProcessor;
import com.inet.help.api.HelpPageManipulationMethods;
import com.inet.help.api.utils.NodeIterator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.help.HelpPage;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HelpDeskSupporterHelpContentProcessor
implements HelpPageContentProcessor {
    private static final String HELPDESK_SUPPORTER_TAG = "helpdesk:supporter";

    public void process(@Nonnull String helpKey, @Nonnull Document helpPage, @Nonnull List<HelpPage> pages, @Nonnull Locale locale) {
        boolean isSupporter = HelpDeskSupporterHelpContentProcessor.isSupporter();
        NodeIterator nodeIterator = new NodeIterator((Element)helpPage);
        for (Element node : nodeIterator) {
            if (this.isHeaderNodeWithMissingTicketListPermission(isSupporter, node)) {
                HelpPageManipulationMethods.removeSectionNodes((Element)node, (NodeIterator)nodeIterator);
                continue;
            }
            if (!this.isNodeWithMissingTicketListPermission(isSupporter, node)) continue;
            nodeIterator.moveTo(node);
            nodeIterator.remove();
        }
    }

    private boolean isHeaderNodeWithMissingTicketListPermission(boolean isSupporter, Element node) {
        if (!HelpPageManipulationMethods.isHeaderNode((Element)node)) {
            return false;
        }
        String selector = !isSupporter ? "*[class*=helpdesk_supporter]" : "*[class*=helpdesk_enduser]";
        Elements productElems = node.select(selector);
        return !productElems.isEmpty();
    }

    private boolean isNodeWithMissingTicketListPermission(boolean isSupporter, Element node) {
        String selector;
        if (!node.tagName().equalsIgnoreCase("div")) {
            return false;
        }
        String string = selector = !isSupporter ? "helpdesk_supporter" : "helpdesk_enduser";
        return node.hasClass(selector);
    }

    private static boolean isSupporter() {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        return userAccount != null && HDUsersAndGroups.isSupporter((UserAccount)userAccount);
    }

    public static boolean isHelpPageVisible(HelpPage helpPage) {
        return !helpPage.getTags().contains(HELPDESK_SUPPORTER_TAG) || HelpDeskSupporterHelpContentProcessor.isSupporter();
    }

    public static void registerExtension() {
        HelpPageContentProcessor.register((HelpPageContentProcessor)new HelpDeskSupporterHelpContentProcessor());
    }
}

