/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.TryTicketLockData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class TryTicketLock
extends AbstractTicketListHandler<TryTicketLockData, Void> {
    public String getMethodName() {
        return "ticketpage.tryticketlock";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, TryTicketLockData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        TicketAccessInformationsProvider ticketAccessInformationsProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
        if (input.isWriteLock()) {
            boolean accessTicketWrite = ticketAccessInformationsProvider.accessTicketWrite(input.getClientID(), input.getTicketId());
            if (!accessTicketWrite) {
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.lock.failed", new Object[]{String.valueOf(input.getTicketId())}));
            }
        } else {
            ticketAccessInformationsProvider.accessTicketRead(input.getClientID(), input.getTicketId());
        }
        return null;
    }
}

