/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketAdditionalAccessValue;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.data.ModifyTicketShareRequestData;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class ModifyTicketShare
extends AbstractTicketListHandler<ModifyTicketShareRequestData, Void> {
    public String getMethodName() {
        return "ticketlist.modifyticketshare";
    }

    @Override
    protected Void handleRequest(HttpServletRequest request, HttpServletResponse response, ModifyTicketShareRequestData input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        if (!HDUsersAndGroups.isSupporter((UserAccount)currentUser)) {
            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.permissionrequired.supporter", new Object[0]));
        }
        TicketVO ticket = TicketManager.getReader().getTicket(input.getTicketID());
        if (ticket != null) {
            ActionCheckError checkAction = TicketManager.getTicketActionChecker().checkAction((ActionVO)ActionManager.getInstance().get(-38), input.getTicketID());
            if (checkAction != null) {
                throw new ClientMessageException(checkAction.getErrorMessage());
            }
            TicketAdditionalAccessValue accessValue = (TicketAdditionalAccessValue)ticket.getValue((TicketField)Tickets.FIELD_ADDITIONAL_ACCESS);
            if (accessValue == null) {
                accessValue = new TicketAdditionalAccessValue();
            }
            if (input.isRemove()) {
                accessValue.removeAccessFor(input.getHash());
            } else if (input.isWriteAccess()) {
                accessValue.setWriteAccessFor(input.getHash());
            } else {
                accessValue.setReadAccessFor(input.getHash());
            }
            TicketManager.getManipulator().changeTicketAdditionalAccess(input.getTicketID(), accessValue);
            return null;
        }
        throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.writepermission.failed", new Object[]{input.getTicketID()}));
    }
}

