/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererExtension;
import com.inet.helpdesk.plugins.ticketlist.api.editing.FieldEditDescription;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MandatoryFieldsEvaluatorForGetEditActionFields {
    public MandatoryFieldsList evaluate(ActionVO action, List<Integer> ticketIds, HashMap<String, String> mandatoryValues) {
        MandatoryFieldsManager mandatoryFieldsManager = (MandatoryFieldsManager)ServerPluginManager.getInstance().getSingleInstance(MandatoryFieldsManager.class);
        TicketReader reader = TicketManager.getReader();
        HashSet mandatoryTicketFieldKeys = new HashSet();
        HashMap<String, String> mandatoryTicketFieldValues = new HashMap<String, String>();
        ArrayList tickets = new ArrayList();
        if (ticketIds != null) {
            List aares = ServerPluginManager.getInstance().get(ApplyActionRendererExtension.class);
            Collections.sort(aares, (a, b) -> Integer.compare(a.getPriority(), b.getPriority()));
            for (Integer ticketId : ticketIds) {
                TicketVO ticket = reader.getTicket(ticketId.intValue());
                Map fieldsToChangeBeforeAction = mandatoryFieldsManager.getInfoAboutFieldsToChangeBeforeAction(ticket, action);
                fieldsToChangeBeforeAction.keySet().forEach(tf -> mandatoryTicketFieldKeys.add(tf.getKey()));
                for (ApplyActionRendererExtension aare : aares) {
                    Map<String, String> valuesOfFieldsToChangeBeforeAction;
                    Map<TicketField<?>, String> fieldsToChange = aare.getFieldsToChangeBeforeAction(ticket, action);
                    if (fieldsToChange != null) {
                        fieldsToChange.keySet().forEach(tf -> mandatoryTicketFieldKeys.add(tf.getKey()));
                    }
                    if ((valuesOfFieldsToChangeBeforeAction = aare.getValuesOfFieldsToChangeBeforeAction(ticket, action)) == null) continue;
                    mandatoryTicketFieldValues.putAll(valuesOfFieldsToChangeBeforeAction);
                }
            }
            tickets.addAll(TicketManager.getReader().getTickets(ticketIds));
        }
        MandatoryFieldsList result = new MandatoryFieldsList();
        List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        for (TicketFieldDefinition definition : fieldDefs) {
            FieldEditDefinition editDefinition;
            if (!mandatoryTicketFieldKeys.contains(definition.getKey()) || (editDefinition = definition.getEditDefinition()) == null) continue;
            String editHint = editDefinition.getEditHint(tickets);
            if (!StringFunctions.isEmpty((String)editHint)) {
                result.editHints.put(editDefinition.getFieldKey(), editHint);
            }
            if (!editDefinition.isAvailable(tickets)) continue;
            if (ticketIds == null) {
                editDefinition.updateCurrentValue(null, null, mandatoryValues);
            } else if (ticketIds.size() == 1) {
                editDefinition.updateCurrentValue(TicketManager.getReader().getTicket(ticketIds.get(0).intValue()), null, mandatoryValues);
            } else if (ticketIds.size() > 1) {
                boolean multiValues = false;
                String oldDisplayValue = null;
                for (int i = 0; i < ticketIds.size(); ++i) {
                    String displayValue = definition.getDisplayValue(TicketManager.getReader().getTicket(ticketIds.get(i).intValue()));
                    if (i > 0 && !Objects.equals(oldDisplayValue, displayValue)) {
                        multiValues = true;
                        break;
                    }
                    oldDisplayValue = displayValue;
                }
                if (multiValues) {
                    editDefinition.updateCurrentValue(null, null, mandatoryValues);
                } else {
                    editDefinition.updateCurrentValue(TicketManager.getReader().getTicket(ticketIds.get(0).intValue()), null, mandatoryValues);
                }
            }
            FieldEditDescription description = new FieldEditDescription(editDefinition.getFieldKey(), editDefinition.getDisplayType(), editDefinition.getDisplayName(), definition.getDescription(), definition.getProperties());
            result.fields.add(description);
        }
        mandatoryValues.putAll(mandatoryTicketFieldValues);
        return result;
    }

    public static final class MandatoryFieldsList {
        private ArrayList<FieldEditDescription> fields = new ArrayList();
        private HashMap<String, String> editHints = new HashMap();

        public ArrayList<FieldEditDescription> getFields() {
            return this.fields;
        }

        public HashMap<String, String> getEditHints() {
            return this.editHints;
        }
    }
}

