/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.ticketlist.api.data.TicketUser;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetUsersRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetUsersResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagActive;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;

public class GetUsersHandler
extends AbstractTicketListHandler<GetUsersRequest, GetUsersResponse> {
    private static final int MAX_ENTRIES = 5000;

    public String getMethodName() {
        return "ticketlist.getusers";
    }

    @Override
    public short getMethodType() {
        return 1;
    }

    @Override
    protected GetUsersResponse handleRequest(HttpServletRequest request, HttpServletResponse response, GetUsersRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            AccessDeniedException cause = new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
            throw new ClientMessageException(cause.getMessage(), (Throwable)cause);
        }
        boolean includeEmptyEntry = input.isIncludeEmptyEntry();
        int chunkSize = input.getChunkSize();
        int currentSize = input.getCurrentSize();
        String filter = input.getFilter();
        int requestNumber = input.getRequestNumber();
        SearchID searchID = new SearchID((Object)(this.getMethodName() + "_" + request.getSession().getId()));
        ArrayList<TicketUser> users = new ArrayList<TicketUser>();
        ArrayList boostingExpressions = new ArrayList();
        ArrayList<SearchCondition> additionalExpressions = new ArrayList<SearchCondition>();
        additionalExpressions.add(new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagActive.valueAsString((boolean)true)));
        additionalExpressions.add(new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Unequals, (Object)UserAccountType.Temp.name()));
        UserManager manager = UserManager.getInstance();
        SearchResult searchResult = manager.searchAsUser(filter, additionalExpressions, boostingExpressions, 10000, searchID);
        int count = 0;
        if (includeEmptyEntry && currentSize == 0 && StringFunctions.isEmpty((String)filter)) {
            ++count;
            users.add(new TicketUser(null, "", "", ""));
        }
        for (SearchResultEntry e : searchResult.getEntries()) {
            UserAccount userAccount;
            if (++count > currentSize && (userAccount = manager.getUserAccount((GUID)e.getId())) != null) {
                users.add(new TicketUser((GUID)e.getId(), userAccount.getDisplayName(), e.getFirstResultLine(), e.getSecondResultLine()));
            }
            if (users.size() < chunkSize) continue;
            break;
        }
        return new GetUsersResponse(requestNumber, users);
    }
}

