/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetItilTicketsRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.GetItilTicketsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.data.ItilLinkableTicket;
import com.inet.helpdesk.plugins.ticketlist.server.data.ItilTypeDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.SearchLinkableTicketsRequest;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class GetItilTickets
extends AbstractTicketListHandler<GetItilTicketsRequest, GetItilTicketsResponse> {
    public String getMethodName() {
        return "ticketlist.extension.itil.gettickets";
    }

    @Override
    protected GetItilTicketsResponse handleRequest(HttpServletRequest request, HttpServletResponse response, GetItilTicketsRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        ArrayList<ItilLinkableTicket> linkableTickets = new ArrayList<ItilLinkableTicket>();
        boolean hasMore = false;
        ItilLinkManager itilLinkManager = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);
        Set<Integer> alreadyLinkedIds = new HashSet();
        if (input.getMode() == SearchLinkableTicketsRequest.Mode.itilSlave) {
            alreadyLinkedIds = itilLinkManager.getItilSlavesLinkedTo(input.getTicketId());
        }
        if (input.getMode() == SearchLinkableTicketsRequest.Mode.itilMaster) {
            alreadyLinkedIds.add(itilLinkManager.getItilMasterOf(input.getTicketId()));
        }
        TicketReader reader = TicketManager.getReader();
        if (!input.getItilfilter().isEmpty()) {
            SearchCondition itilCondition = new SearchCondition(Tickets.FIELD_ITIL_ID.getKey(), SearchCondition.SearchTermOperator.IN, input.getItilfilter());
            SearchCommand command = null;
            if (StringFunctions.isEmpty((String)input.getSearchterm())) {
                command = new SearchCommand(ClientLocale.getThreadLocale(), new SearchExpression[]{itilCondition});
            } else {
                command = new TextSearchCommandBuilder(reader.getSearchEngine(), input.getSearchterm()).build(ClientLocale.getThreadLocale());
                command.getSearchExpression().add((SearchExpression)itilCondition);
            }
            SearchExpression globalSearchExpressionForAllVisibleTickets = reader.getGlobalSearchExpressionForAllVisibleTickets(currentUser.getID(), ClientLocale.getThreadLocale());
            if (globalSearchExpressionForAllVisibleTickets != null) {
                command.getSearchExpression().add(globalSearchExpressionForAllVisibleTickets);
            }
            List ticketIds = reader.getSearchEngine().search(command).getEntries().stream().map(SearchResultEntry::getId).collect(Collectors.toCollection(ArrayList::new));
            ticketIds.remove((Object)input.getTicketId());
            ticketIds.removeAll(alreadyLinkedIds);
            for (Integer ticketId : ticketIds) {
                TicketAttribute processAttribute;
                TicketVO ticket;
                if (linkableTickets.size() >= 100) {
                    hasMore = true;
                    break;
                }
                TicketPermissionContext permissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketId.intValue());
                if (permissionInfo == null || !permissionInfo.hasSupporterAccessToTicket() || (ticket = reader.getTicket(ticketId.intValue())) == null || !input.getItilfilter().contains(ticket.getItilID()) || (input.getMode() != SearchLinkableTicketsRequest.Mode.itilMaster || !((ItilVO)ItilManager.getInstance().get(ticket.getItilID())).isMasterType()) && (input.getMode() != SearchLinkableTicketsRequest.Mode.itilSlave || ((ItilVO)ItilManager.getInstance().get(ticket.getItilID())).isMasterType()) || TicketManager.getTicketActionChecker().checkAction((ActionVO)ActionManager.getInstance().get(-15), ticketId.intValue()) != null || (processAttribute = Tickets.getAttributeByKey((String)"process.activity")) != null && (ticket.getAttribute(processAttribute) != null || ticket.getAttribute(Tickets.getAttributeByKey((String)"process.mainticketid")) != null)) continue;
                linkableTickets.add(new ItilLinkableTicket(ticket.getID(), ticket.getStatusID(), ticket.getSubject(), ticket.getItilID()));
            }
            Collections.sort(linkableTickets, (t1, t2) -> t1.getItilId() - t2.getItilId());
        }
        ArrayList<ItilTypeDescription> itilTypes = new ArrayList<ItilTypeDescription>();
        block1: for (ItilVO vo : ItilManager.getInstance().getAll(false)) {
            if ((input.getMode() != SearchLinkableTicketsRequest.Mode.itilMaster || !vo.isMasterType()) && (input.getMode() != SearchLinkableTicketsRequest.Mode.itilSlave || vo.isMasterType())) continue;
            SearchCondition condition = new SearchCondition(Tickets.FIELD_ITIL_ID.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)vo.getId());
            SearchCommand cmd = new SearchCommand(ClientLocale.getThreadLocale(), new SearchExpression[]{condition});
            SearchExpression globalSearchExpressionForAllVisibleTickets = reader.getGlobalSearchExpressionForAllVisibleTickets(currentUser.getID(), ClientLocale.getThreadLocale());
            if (globalSearchExpressionForAllVisibleTickets != null) {
                cmd.getSearchExpression().add(globalSearchExpressionForAllVisibleTickets);
            }
            Set simpleSearch = reader.getSearchEngine().simpleSearch(cmd);
            simpleSearch.removeAll(alreadyLinkedIds);
            for (Integer id : simpleSearch) {
                TicketPermissionContext permissionInfo;
                if (TicketManager.getTicketActionChecker().checkAction((ActionVO)ActionManager.getInstance().get(-15), id.intValue()) != null || (permissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(id.intValue())) == null || !permissionInfo.hasSupporterAccessToTicket()) continue;
                itilTypes.add(new ItilTypeDescription(vo.getId(), vo.getDisplayValue()));
                continue block1;
            }
        }
        return new GetItilTicketsResponse(linkableTickets, itilTypes, hasMore);
    }
}

