/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.PriorityDescription;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ListDataUpdate
extends TicketListWebSocketEvent<Void>
implements GenericFieldsManager.DataChangeListener {
    private Set<String> listenerClients = new HashSet<String>();

    public ListDataUpdate() {
        PriorityManager.getInstance().addDataChangeListener((GenericFieldsManager.DataChangeListener)this);
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String clientID) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connectionClosed(String clientID) {
                Set<String> set = ListDataUpdate.this.listenerClients;
                synchronized (set) {
                    ListDataUpdate.this.listenerClients.remove(clientID);
                }
            }
        });
    }

    public String getEventName() {
        return "ticketlist.listdataupdate";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleEvent(String clientID, Void payload) {
        Set<String> set = this.listenerClients;
        synchronized (set) {
            this.listenerClients.add(clientID);
        }
        this.sendPriorities(clientID);
        this.sendSortableFields(clientID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheUpdated() {
        Set<String> set = this.listenerClients;
        synchronized (set) {
            this.sendPriorities(this.listenerClients.toArray(new String[this.listenerClients.size()]));
        }
    }

    private void sendPriorities(String ... clientIDs) {
        HashMap priorities = new HashMap();
        List validPriorities = PriorityManager.getInstance().getAll(true);
        long minPrio = validPriorities.stream().min(Comparator.comparing(FieldVO::getId)).get().getId();
        long maxPrio = validPriorities.stream().max(Comparator.comparing(FieldVO::getId)).get().getId();
        List allPriorities = PriorityManager.getInstance().getAll(false);
        allPriorities.forEach(p -> priorities.put(Long.valueOf(p.getId()), PriorityDescription.create(p, minPrio, maxPrio)));
        for (String clientID : clientIDs) {
            WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.priorities", (Object)priorities));
        }
    }

    private void sendSortableFields(String clientID) {
        HashMap<String, LocalizedKey> sortableFields = new HashMap<String, LocalizedKey>();
        List<TicketListColumnDescription> allAvailableColumns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false);
        for (TicketListColumnDescription column : allAvailableColumns) {
            sortableFields.put(column.getKey(), new LocalizedKey(column.getGrouping(), column.getDisplayName()));
        }
        WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData("ticketlist.sortablefields", (Object)sortableFields));
    }
}

