/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.PageSettings;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketFieldVisibility;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class FieldDisplayHelper {
    public static ArrayList<TicketFieldVisibility> getHiddenTicketTicketFields(PageSettings pageSetting) {
        List<TicketListColumnDescription> allAvailableColumns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false);
        Comparator<TicketListColumnDescription> compareByGroupAndDisplayName = Comparator.comparing(TicketListColumnDescription::getGroupingKey).thenComparing(TicketListColumnDescription::getDisplayName, String.CASE_INSENSITIVE_ORDER);
        ArrayList<TicketFieldVisibility> hiddenTicketFields = pageSetting.getHiddenTicketFields();
        ArrayList<TicketFieldVisibility> newHiddenTicketFields = new ArrayList<TicketFieldVisibility>();
        List columnKeysTicket = allAvailableColumns.stream().filter(c -> c.getGroupingKey().equals(TicketFieldDefinition.FIELD_GROUPING.TICKET.name())).sorted(compareByGroupAndDisplayName).map(TicketListColumnDescription::getKey).collect(Collectors.toList());
        for (TicketFieldVisibility hiddenField : hiddenTicketFields) {
            if (hiddenField == null || !columnKeysTicket.remove(hiddenField.getTicketFieldKey())) continue;
            newHiddenTicketFields.add(hiddenField);
        }
        for (String columnKey : columnKeysTicket) {
            newHiddenTicketFields.add(new TicketFieldVisibility(columnKey, false));
        }
        return newHiddenTicketFields;
    }

    public static ArrayList<TicketFieldVisibility> getHiddenTicketOwnerFields(PageSettings pageSetting) {
        List<TicketListColumnDescription> allAvailableColumns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false);
        Comparator<TicketListColumnDescription> compareByGroupAndDisplayName = Comparator.comparing(TicketListColumnDescription::getGroupingKey).thenComparing(TicketListColumnDescription::getDisplayName, String.CASE_INSENSITIVE_ORDER);
        ArrayList<TicketFieldVisibility> hiddenTicketOwnerFields = pageSetting.getHiddenTicketOwnerFields();
        ArrayList<TicketFieldVisibility> newHiddenTicketOwnerFields = new ArrayList<TicketFieldVisibility>();
        List columnKeysTicketOwner = allAvailableColumns.stream().filter(c -> c.getGroupingKey().equals(TicketFieldDefinition.FIELD_GROUPING.TICKET_OWNER.name())).sorted(compareByGroupAndDisplayName).map(TicketListColumnDescription::getKey).collect(Collectors.toList());
        for (TicketFieldVisibility hiddenField : hiddenTicketOwnerFields) {
            if (hiddenField == null || !columnKeysTicketOwner.remove(hiddenField.getTicketFieldKey())) continue;
            newHiddenTicketOwnerFields.add(hiddenField);
        }
        for (String columnKey : columnKeysTicketOwner) {
            newHiddenTicketOwnerFields.add(new TicketFieldVisibility(columnKey, false));
        }
        return newHiddenTicketOwnerFields;
    }
}

