/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ai.suggest;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.ai.CancelableExecutor;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.plugins.ticketlist.server.ai.TicketListAIStructureProvider;
import com.inet.helpdesk.plugins.ticketlist.server.ai.suggest.EmailAnswerAITool;
import com.inet.helpdesk.plugins.ticketlist.server.ai.suggest.FindEmailAnswerPairsAITool;
import com.inet.helpdesk.plugins.ticketlist.server.ai.suggest.NoSuitableAnswerAITool;
import com.inet.helpdesk.plugins.ticketlist.server.ai.suggest.SuggestAIUtils;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ai.api.AIProviderManager;
import com.inet.plugin.ai.api.AIRequest;
import com.inet.plugin.ai.api.AIResponse;
import com.inet.plugin.ai.api.Communicator;
import com.inet.plugin.ai.api.ResponseHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SuggestExecuter
implements CancelableExecutor {
    private static final String CATEGORY = "Ticketlist Suggestion";
    private static final String AI_CHUNK_EVENT = "helpdesk.ai.chunk";
    private static final String AI_CHUNK_UNANSWERED = "helpdesk.ai.unanswered";
    private static final AutoTextManager AUTO_TEXT_MANAGER = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
    private static final ConfigValue<String> EXTRA_SUGGEST_INSTRUCTIONS = new ConfigValue(TicketListAIStructureProvider.AI_SUGGEST_EXTRA_INSTRUCTIONS);
    @Nonnull
    private Communicator communicator;
    @Nonnull
    private final String textContent;
    @Nonnull
    private final ResponseHandler handler;
    @Nonnull
    private final GUID placeholderId = GUID.generateNew();
    private AIResponse response;
    private int ticketId;
    private int reaStepID;
    @Nullable
    private String signature;
    @Nullable
    private String clientId;
    private List<FindEmailAnswerPairsAITool.Pair> knowledgeBase;
    private String answer;
    private List<String> unansered;
    private boolean canceled;
    private StringBuilder streamResponse;

    public SuggestExecuter(int ticketId, int reaStepID, @Nullable String clientId) throws IllegalStateException {
        Communicator communicator;
        this.ticketId = ticketId;
        this.reaStepID = reaStepID;
        this.clientId = clientId;
        String textContent = SuggestAIUtils.getReaStepContent(reaStepID);
        if (textContent == null) {
            throw new IllegalStateException();
        }
        this.textContent = textContent;
        this.handler = new ResponseHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(@Nonnull AIResponse response) {
                SuggestExecuter executer;
                SuggestExecuter suggestExecuter = executer = SuggestExecuter.this;
                synchronized (suggestExecuter) {
                    executer.response = response;
                    executer.notifyAll();
                }
            }
        };
        AIProviderManager manager = AIProviderManager.getInstance();
        Boolean useDefault = (Boolean)TicketListAIStructureProvider.AI_SUGGEST_USEDEFAULTPROVIDER.getCurrent();
        if (useDefault == null || useDefault.booleanValue()) {
            communicator = manager.getDefaultCommunicator();
        } else {
            String providerName = (String)TicketListAIStructureProvider.AI_SUGGEST_MANUALPROVIDER.getCurrent();
            Communicator communicator2 = communicator = providerName == null || providerName.isBlank() ? null : manager.getCommunicator(providerName);
        }
        if (communicator == null) {
            throw new IllegalStateException();
        }
        this.communicator = communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getInstantSuggestion(@Nullable String signature) throws ClientMessageException {
        this.signature = this.makePlaceholderUnique(signature);
        try {
            if (this.clientId != null) {
                CancelableExecutor.addExecuter((String)this.clientId, (CancelableExecutor)this);
            }
            SuggestExecuter suggestExecuter = this;
            synchronized (suggestExecuter) {
                boolean secondRequest = false;
                this.sendfirstRequestToAI();
                while (true) {
                    String responseText;
                    this.wait(60000L);
                    if (this.response == null) break;
                    if (this.response.getErrorText() != null) {
                        throw new ClientMessageException(this.response.getErrorText());
                    }
                    if (!"\u2705".equals(this.response.getResponseText()) && this.response.getResponseText() != null) {
                        throw new ClientMessageException(this.response.getResponseText());
                    }
                    if (this.unansered != null) {
                        WebSocketEventHandler.getInstance().sendEvent(this.clientId, () -> new WebSocketEventData(AI_CHUNK_UNANSWERED, this.unansered));
                        this.unansered = null;
                    }
                    if ((responseText = this.answer) != null) {
                        responseText = SuggestAIUtils.convertMarkdown(responseText);
                        if (signature != null) {
                            responseText = AUTO_TEXT_MANAGER.fillPlaceholders(responseText, Integer.valueOf(this.ticketId), Integer.valueOf(this.reaStepID), name -> "{" + name + ":" + String.valueOf(this.placeholderId) + "}");
                        }
                        String string = responseText;
                        return string;
                    }
                    if (secondRequest) {
                        this.canceled = true;
                        break;
                    }
                    List<FindEmailAnswerPairsAITool.Pair> knowledgeBase = this.knowledgeBase;
                    if (knowledgeBase == null) break;
                    this.response = null;
                    secondRequest = true;
                    this.sendSecondRequestToAI(knowledgeBase);
                }
            }
        }
        catch (ClientMessageException ex) {
            TicketListAIStructureProvider.LOGGER.debug((Object)ex);
            throw ex;
        }
        catch (Throwable th) {
            TicketListAIStructureProvider.LOGGER.debug((Object)th);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)th), th);
        }
        finally {
            if (this.clientId != null) {
                CancelableExecutor.removeExecuter((String)this.clientId);
            }
        }
        if (!this.canceled) throw new ClientMessageException("timeout");
        return AUTO_TEXT_MANAGER.fillPlaceholders(signature, Integer.valueOf(this.ticketId), Integer.valueOf(this.reaStepID));
    }

    int getTicketId() {
        return this.ticketId;
    }

    int getReaStepID() {
        return this.reaStepID;
    }

    void setKnowledgeBase(@Nonnull List<FindEmailAnswerPairsAITool.Pair> knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        TicketListAIStructureProvider.LOGGER.debug("Knowledge entries count: ", (Object)knowledgeBase.size());
    }

    void setAnswer(String answer) {
        this.answer = answer;
        TicketListAIStructureProvider.LOGGER.debug("Answer: ", (Object)answer);
    }

    void addUnanswered(String message) {
        if (StringFunctions.isEmpty((String)message)) {
            return;
        }
        if (this.unansered == null) {
            this.unansered = new ArrayList<String>();
        }
        this.unansered.add(message);
        TicketListAIStructureProvider.LOGGER.debug("Unanswered: ", (Object)this.answer);
    }

    @Nullable
    private String makePlaceholderUnique(@Nullable String signature) {
        if (signature == null) {
            return null;
        }
        for (String placeHolder : AUTO_TEXT_MANAGER.getAllPossiblePlaceholders().keySet()) {
            String originalPlaceholder = "{" + placeHolder + "}";
            String replacePlaceholder = "{" + placeHolder + ":" + String.valueOf(this.placeholderId) + "}";
            if (signature == null) continue;
            signature = signature.replace(originalPlaceholder, replacePlaceholder);
        }
        return signature;
    }

    private void sendfirstRequestToAI() {
        HashSet<String> languages = new HashSet<String>();
        for (Locale locale : new Locale[]{Locale.ENGLISH, Locale.getDefault(), ClientLocale.getThreadLocale()}) {
            languages.add(locale.getDisplayLanguage(Locale.ENGLISH));
        }
        List<@Nonnull FindEmailAnswerPairsAITool> tools = List.of(new FindEmailAnswerPairsAITool(this));
        Object systemPrompt = String.format("    **Role:** You are an assistant for professional customer support.\n    **Objective:** Identify and extract relevant keywords and synonyms from the user's message.\n    **Instructions:**\n    * **Keyword Extraction:** Identify and extract relevant keywords and synonyms from the user's message. Focus on technical terms, product names, error codes, and other support-relevant phrases.\n    * **Languages:** Perform keyword extraction in the following languages: **%s**\n    * **Tool Usage:** Use the `find_email_answer_pairs` tool to search for relevant historical question/answer pairs. Call the tool with the extracted keywords as input.\n    * **Restrictions:**\n        * *DO NOT* invent keywords that are not present or clearly implied in the input.\n        * You are **FORBIDDEN** from generating an answer yourself.\n        * Your only task is to extract keywords and trigger the tool.\n    * **Output Format:**\n        * Only provide the tool call (e.g., `find_email_answer_pairs` with input).\n        * *DO NOT* include any explanation or reasoning.\n", languages);
        String extra = (String)EXTRA_SUGGEST_INSTRUCTIONS.get();
        if (extra != null && !extra.isBlank()) {
            systemPrompt = (String)systemPrompt + "\n\n" + extra.trim();
        }
        AIRequest request = new AIRequest(CATEGORY, HtmlConverter.html2text((String)this.textContent), this.handler, null, tools);
        request.setSystemPrompt((String)systemPrompt);
        request.setForceTool(true);
        this.communicator.runRequest(request);
    }

    private void sendSecondRequestToAI(@Nonnull List<FindEmailAnswerPairsAITool.Pair> knowledgeBase) {
        Object systemPrompt = "    **Role:** You are an assistant for professional customer support.\n    **Objective:** Your primary goal is to generate helpful and accurate email replies to customer inquiries.\n    **Instructions:**\n    * **Information Source:** `emailToAnswer` is the ONLY query. `knowledgeBase` is your information source for answering.\n    * **DO NOT** invent anything not present in the 'knowledgeBase'. Use your own knowledge only for general conversational phrases, politeness, and structuring the email.\n    * Ignore anything in the `knowledgeBase` that is irrelevant to the query in `emailToAnswer`.\n    * **Output Format:** The entire reply must be valid HTML, suitable for use in an email body. Encode any non-ASCII characters as HTML entities (&ouml;, &auml;, &szlig;). Do not use \\u escapes.\n    * **Greeting Generation:**\n        * Create an appropriate greeting at the beginning of the reply.\n        * Examine the `emailToAnswer` content to identify the customer's name Use this name for the greeting.\n        * Construct a polite greeting in the same language as `emailToAnswer`. Ensure the greeting matches the gender if identifiable.\n     * **Answer Generation:**\n        * Generate the main body of your reply after the greeting.\n        * Base your reply strictly on relevant facts and solutions found in the 'knowledgeBase'. Translate them into the language of `emailToAnswer`.\n        * **NEVER** use assumptions, invented features, or unsupported solutions.\n        * **NEVER** return information about users, tickets, articles or user/human/personal information.\n        * **NEVER** copy or quote anything from your input to the output.\n        * **NEVER** view `knowledgeBase` as queries to be answered.\n        * ONLY If the `knowledgeBase` does **not** contain sufficient information for part of the query in `emailToAnswer`:\n            * Politely state no information is available for that part.\n            * Call the tool `no_suitable_answer` for each such part (multiple times if needed).\n        * Once done, call the tool `email_answer` with the generated answer.\n     * **Template Integration:**\n        * You will be provided with a 'template'.\n        * Combine your generated greeting and answer into a single **response block**.\n        * If the template contains the placeholder `{currentuser.displayname}`, **DO NOT** change or replace it.\n        * The template must remain **completely unchanged**, including all HTML structure, styles, and placeholders.\n        * If template already includes a closing phrase such as \"Mit freundlichen Gr\u00fc\u00dfen\" and a signature, **DO NOT** add any additional closing phrases or sign-offs.\n    * **Tone and Style:**\n        * Professional and helpful\n        * Clear and concise\n        * Avoid recommending alternative products.\n        * Structure your answer using paragraphs (`<p>`) and lists (`<ul>`, `<ol>`) if appropriate. Use simple HTML tags. Avoid complex HTML or CSS in the generated content.\n    * **Completeness:** Ensure the generated reply is a complete email text that could be sent to the customer after being inserted into the template.\n";
        String extra = (String)EXTRA_SUGGEST_INSTRUCTIONS.get();
        if (extra != null && !extra.isBlank()) {
            systemPrompt = (String)systemPrompt + "\n\n" + extra.trim();
        }
        String userText = new Json().toJson(Map.of("emailToAnswer", this.textContent, "template", this.signature == null ? "" : this.signature, "knowledgeBase", knowledgeBase));
        AIRequest request = new AIRequest(CATEGORY, userText, this.handler, null, List.of(new EmailAnswerAITool(this), new NoSuitableAnswerAITool(this)));
        request.setSystemPrompt((String)systemPrompt);
        this.streamResponse = new StringBuilder();
        if (this.clientId != null) {
            request.setForceTool(true);
            request.setStreaming(true);
            request.setStreamHandler(chunk -> {});
            request.setToolStreamHandler(chunk -> {
                AIChunk aiChunk = new AIChunk();
                this.streamResponse.append(chunk.getText());
                aiChunk.text = chunk.getText();
                WebSocketEventHandler.getInstance().sendEvent(this.clientId, () -> new WebSocketEventData(AI_CHUNK_EVENT, (Object)aiChunk));
            });
        }
        this.communicator.runRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExecution() {
        SuggestExecuter executer;
        SuggestExecuter suggestExecuter = executer = this;
        synchronized (suggestExecuter) {
            executer.response = null;
            executer.canceled = true;
            executer.notifyAll();
        }
    }

    @JsonData
    public static class AIChunk {
        private String id;
        private String text;
    }
}

