/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPageLayoutSettingsResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout.TicketPageLayoutManager;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TicketPageLayoutSettings
extends AbstractTicketListHandler<Void, TicketPageLayoutSettingsResponse> {
    public String getMethodName() {
        return "ticketlist.ticketlayoutsettings";
    }

    @Override
    protected TicketPageLayoutSettingsResponse handleRequest(HttpServletRequest request, HttpServletResponse response, Void input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        TicketPageLayoutManager layoutManager = TicketPageLayoutManager.getInstance();
        List<TicketPageLayoutDescription> userLayouts = layoutManager.getLayouts(currentUser);
        Map<String, TicketPageLayoutDescription> userLayoutMap = userLayouts.stream().collect(Collectors.toMap(TicketPageLayoutDescription::getLayoutKey, ld -> ld));
        List<TicketPageLayoutDescription> defaultLayouts = layoutManager.getLayouts(null);
        Map<String, TicketPageLayoutDescription> defaultLayoutMap = defaultLayouts.stream().collect(Collectors.toMap(TicketPageLayoutDescription::getLayoutKey, ld -> ld));
        List<TicketListColumnDescription> allColumns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false);
        List<TicketListColumnDescription> columnsWithIcon = allColumns.stream().filter(TicketListColumnDescription::supportsIcon).collect(Collectors.toList());
        List<TicketListColumnDescription> columnsWithText = allColumns.stream().filter(TicketListColumnDescription::supportsText).collect(Collectors.toList());
        return new TicketPageLayoutSettingsResponse(layoutManager.getAllAvailableExtensions(currentUser), userLayoutMap, defaultLayoutMap, columnsWithIcon, columnsWithText);
    }
}

