/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.field.SelectOption;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.server.data.CategoryResourceTakeoverRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.CategoryResourceTakeoverResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CategoryResourceTakeover
extends AbstractTicketListHandler<CategoryResourceTakeoverRequest, CategoryResourceTakeoverResponse> {
    public String getMethodName() {
        return "ticketlist.categoryresourcetakeover";
    }

    @Override
    protected CategoryResourceTakeoverResponse handleRequest(HttpServletRequest request, HttpServletResponse response, CategoryResourceTakeoverRequest input, UserAccount currentUser) throws ClientMessageException, ServerDataException {
        UserGroupInfo resourceGroup;
        int resourceID;
        CategoryManager.RESOURCE_TAKEOVER takeOverValue = (CategoryManager.RESOURCE_TAKEOVER)CategoryManager.RESOURCE_TAKEOVER_SETTING.get();
        if (takeOverValue == CategoryManager.RESOURCE_TAKEOVER.never) {
            return null;
        }
        if (takeOverValue == CategoryManager.RESOURCE_TAKEOVER.newticketnotset) {
            return null;
        }
        List<Integer> ticketIds = input.getTicketIds();
        GUID currentResourceId = null;
        ActionVO forwardAction = (ActionVO)ActionManager.getInstance().get(8);
        TicketFieldDefinition resourceFieldDefinition = Tickets.getFieldDefinitionByKey((String)Tickets.FIELD_RESOURCE_GUID.getKey());
        if (!resourceFieldDefinition.isAvailable()) {
            return null;
        }
        FieldEditDefinition editDefinition = resourceFieldDefinition.getEditDefinition();
        if (ticketIds.isEmpty()) {
            if (editDefinition == null || !editDefinition.isAvailable(null)) {
                return null;
            }
            currentResourceId = (GUID)Tickets.FIELD_RESOURCE_GUID.getDefaultValue();
        } else {
            for (int i = 0; i < ticketIds.size(); ++i) {
                Integer ticketId = ticketIds.get(i);
                TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                if (ticket != null) {
                    ActionCheckError checkAction;
                    boolean fieldEditable;
                    boolean bl = fieldEditable = editDefinition != null && editDefinition.isAvailable(Collections.singletonList(ticket));
                    if (!fieldEditable && (checkAction = TicketManager.getTicketActionChecker().checkAction(forwardAction, ticketId.intValue())) != null) {
                        return null;
                    }
                    GUID resourceID2 = ticket.getResourceID();
                    if (i == 0) {
                        currentResourceId = resourceID2;
                        continue;
                    }
                    if (Objects.equals(currentResourceId, resourceID2)) continue;
                    currentResourceId = null;
                    continue;
                }
                return null;
            }
        }
        int categoryId = input.getCategoryId();
        CategoryVO categoryVO = (CategoryVO)CategoryManager.getInstance().get(categoryId);
        if (categoryVO != null && (resourceID = this.getTargetResource(categoryVO)) > 0 && (resourceGroup = HDUsersAndGroups.getResource((int)resourceID)) != null) {
            SelectOption resourceOption = new SelectOption(resourceGroup.getID().toString(), resourceGroup.getDisplayName(), HDUsersAndGroups.getResourceIconKey((UserGroupInfo)resourceGroup), this.getLevel(resourceGroup));
            return new CategoryResourceTakeoverResponse(resourceOption, currentResourceId, takeOverValue.name());
        }
        return new CategoryResourceTakeoverResponse(null, currentResourceId, takeOverValue.name());
    }

    private int getTargetResource(CategoryVO categoryVO) {
        CategoryVO parent;
        Integer parentCategoryID;
        int resourceId = categoryVO.getResourceID();
        if (resourceId <= 0 && (parentCategoryID = categoryVO.getParentCategoryID()) != null && (parent = (CategoryVO)CategoryManager.getInstance().get(parentCategoryID.intValue())) != null) {
            return this.getTargetResource(parent);
        }
        return resourceId;
    }

    private int getLevel(UserGroupInfo resourceGroup) {
        int level = 0;
        GUID parentId = resourceGroup.getParentID();
        while (parentId != null) {
            ++level;
            UserGroupInfo parent = UserGroupManager.getInstance().getGroup(parentId);
            if (parent != null) {
                parentId = parent.getParentID();
                continue;
            }
            parentId = null;
        }
        return level;
    }
}

