/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionWithHyperlink;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketListLayout;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.CacheKey;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.ColumnDisplayType;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnSetting;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutSettingsModel;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutSpecificSettingsModel;
import com.inet.helpdesk.plugins.ticketlist.server.ticketpagelayout.TicketPageLayoutManager;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettingManager;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class TicketListLayoutManager
implements UserEventListener,
UserGroupEventListener {
    public static final String DEFAULT_LAYOUT = "default";
    private static final MemoryStoreMap<CacheKey, TicketListLayoutDescription> layoutCache = new MemoryStoreMap(600, true);

    @Nonnull
    public static TicketListLayoutManager getInstance() {
        return Singleton.getInstance();
    }

    private TicketListLayoutManager() {
        TicketFieldSettingsManager.getInstance().addChangeListener((fieldKey, onlyPrioWasChanged) -> {
            MemoryStoreMap<CacheKey, TicketListLayoutDescription> memoryStoreMap = layoutCache;
            synchronized (memoryStoreMap) {
                layoutCache.clear();
            }
        });
    }

    public List<TicketListColumnDescription> getAllAvailableColumns(boolean ignoreEnduserCheck) {
        List ticketFieldDefinitions;
        ArrayList<TicketListColumnDescription> availableColumns = new ArrayList<TicketListColumnDescription>();
        if (ignoreEnduserCheck) {
            try (UserAccountScope pri = UserAccountScope.createPrivileged();){
                ticketFieldDefinitions = Tickets.getFieldsVisibleForUser();
            }
        } else {
            ticketFieldDefinitions = Tickets.getFieldsVisibleForUser();
        }
        for (TicketFieldDefinition fieldDefinition : ticketFieldDefinitions) {
            ColumnDisplayType displayType = ColumnDisplayType.text;
            if (fieldDefinition instanceof TicketFieldDefinitionWithHyperlink && ((TicketFieldDefinitionWithHyperlink)fieldDefinition).isLinkField()) {
                displayType = ColumnDisplayType.link;
            } else if (FieldSettingsType.TYPE_LINK.equals((Object)fieldDefinition.getDisplayType())) {
                displayType = ColumnDisplayType.link;
            } else if (fieldDefinition.supportsText() && fieldDefinition.supportsIcon()) {
                displayType = ColumnDisplayType.iconandtext;
            } else if (fieldDefinition.supportsIcon()) {
                displayType = ColumnDisplayType.icon;
            }
            availableColumns.add(new TicketListColumnDescription(fieldDefinition.getGrouping().name(), fieldDefinition.getGrouping().getDisplayName(), fieldDefinition.getKey(), fieldDefinition.getDisplayName(), fieldDefinition.getDescription(), displayType, null, fieldDefinition.supportsText(), fieldDefinition.supportsIcon()));
        }
        return availableColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TicketListLayoutDescription getCurrentLayout(GUID userID) {
        MemoryStoreMap<CacheKey, TicketListLayoutDescription> memoryStoreMap = layoutCache;
        synchronized (memoryStoreMap) {
            TicketListLayoutDescription ticketListLayoutDescription = (TicketListLayoutDescription)layoutCache.get((Object)CacheKey.of(userID));
            if (ticketListLayoutDescription != null) {
                return ticketListLayoutDescription;
            }
        }
        String layoutSettingsSerialized = (String)UserManager.getInstance().getUserAccount(userID).getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_LISTLAYOUTSETTINGS);
        String layoutSettingsSerializedDefault = UserFieldsWithClientSettingManager.getInstance().getDefaultValueForUserField(TicketListServerPlugin.USERFIELD_TICKETLIST_LISTLAYOUTSETTINGS);
        TicketListLayoutSettingsModel layoutSettings = new TicketListLayoutSettingsModel();
        if (!StringFunctions.isEmpty((String)layoutSettingsSerializedDefault)) {
            layoutSettings.merge((TicketListLayoutSettingsModel)new Json().fromJson(layoutSettingsSerializedDefault, TicketListLayoutSettingsModel.class, new HashMap()));
        }
        if (!StringFunctions.isEmpty((String)layoutSettingsSerialized)) {
            layoutSettings.merge((TicketListLayoutSettingsModel)new Json().fromJson(layoutSettingsSerialized, TicketListLayoutSettingsModel.class, new HashMap()));
        }
        String selectedLayout = null;
        HashMap<String, TicketListLayoutSpecificSettingsModel> layoutSettingsMap = null;
        selectedLayout = layoutSettings.getSelectedLayout();
        layoutSettingsMap = layoutSettings.getLayoutSettings();
        if (layoutSettingsMap == null) {
            layoutSettingsMap = new HashMap();
        }
        List ticketListLayouts = ServerPluginManager.getInstance().get(TicketListLayout.class);
        if (selectedLayout != null) {
            for (TicketListLayout layout : ticketListLayouts) {
                if (!layout.getKey().equals(selectedLayout)) continue;
                TicketListLayoutDescription fromTicketListLayout = TicketListLayoutDescription.fromTicketListLayout(layout, layoutSettingsMap.get(layout.getKey()));
                MemoryStoreMap<CacheKey, TicketListLayoutDescription> memoryStoreMap2 = layoutCache;
                synchronized (memoryStoreMap2) {
                    layoutCache.put((Object)CacheKey.of(userID), (Object)fromTicketListLayout);
                }
                return fromTicketListLayout;
            }
        }
        for (TicketListLayout layout : ticketListLayouts) {
            if (!layout.getKey().equals(DEFAULT_LAYOUT)) continue;
            TicketListLayoutDescription fromTicketListLayout = TicketListLayoutDescription.fromTicketListLayout(layout, layoutSettingsMap.get(layout.getKey()));
            MemoryStoreMap<CacheKey, TicketListLayoutDescription> memoryStoreMap3 = layoutCache;
            synchronized (memoryStoreMap3) {
                layoutCache.put((Object)CacheKey.of(userID), (Object)fromTicketListLayout);
            }
            return fromTicketListLayout;
        }
        return null;
    }

    public List<TicketListLayoutDescription> getLayouts(UserAccount user) {
        TicketListLayoutSettingsModel layoutSettings = null;
        String layoutSettingsSerialized = null;
        if (user != null) {
            layoutSettingsSerialized = (String)user.getValue(TicketListServerPlugin.USERFIELD_TICKETLIST_LISTLAYOUTSETTINGS);
        }
        if (!StringFunctions.isEmpty(layoutSettingsSerialized)) {
            layoutSettings = (TicketListLayoutSettingsModel)new Json().fromJson(layoutSettingsSerialized, TicketListLayoutSettingsModel.class, new HashMap());
        }
        HashMap<String, TicketListLayoutSpecificSettingsModel> layoutSettingsMap = null;
        if (layoutSettings != null) {
            layoutSettingsMap = layoutSettings.getLayoutSettings();
        }
        if (layoutSettingsMap == null) {
            layoutSettingsMap = new HashMap();
        }
        List ticketListLayouts = ServerPluginManager.getInstance().get(TicketListLayout.class);
        ArrayList<TicketListLayoutDescription> userLayouts = new ArrayList<TicketListLayoutDescription>();
        for (TicketListLayout layout : ticketListLayouts) {
            userLayouts.add(TicketListLayoutDescription.fromTicketListLayout(layout, layoutSettingsMap.get(layout.getKey())));
        }
        Collections.sort(userLayouts, new Comparator<TicketListLayoutDescription>(){

            @Override
            public int compare(TicketListLayoutDescription o1, TicketListLayoutDescription o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getLayoutKey(), o2.getLayoutKey());
            }
        });
        return userLayouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLayoutsForUser(UserAccount currentUser, String selectedLayout, Collection<TicketListLayoutDescription> layouts) {
        TicketListLayoutSettingsModel settingsModel = new TicketListLayoutSettingsModel();
        settingsModel.setSelectedLayout(selectedLayout);
        HashMap<String, TicketListLayoutSpecificSettingsModel> layoutSettings = new HashMap<String, TicketListLayoutSpecificSettingsModel>();
        for (TicketListLayoutDescription descr : layouts) {
            List<TicketListColumnDescription> idColumns;
            List<TicketListColumnDescription> fixColumns;
            if (selectedLayout.equals(descr.getLayoutKey())) {
                MemoryStoreMap<CacheKey, TicketListLayoutDescription> memoryStoreMap = layoutCache;
                synchronized (memoryStoreMap) {
                    layoutCache.put((Object)CacheKey.of(currentUser.getID()), (Object)descr);
                }
            }
            TicketListLayoutSpecificSettingsModel model = new TicketListLayoutSpecificSettingsModel();
            model.setPreviewLayout(descr.getPreviewLayout());
            model.setIdentifierColumnWidth(descr.getIdentifierColumnWidth());
            model.setGrouping(descr.isGrouping());
            List<TicketListColumnDescription> addColumns = descr.getAdditionalColumns();
            if (addColumns != null) {
                ArrayList<TicketListColumnSetting> additionalColumSettings = new ArrayList<TicketListColumnSetting>();
                for (TicketListColumnDescription ticketListColumnDescription : addColumns) {
                    additionalColumSettings.add(new TicketListColumnSetting(ticketListColumnDescription.getKey(), ticketListColumnDescription.getDisplayType(), ticketListColumnDescription.getWidth()));
                }
                model.setAdditionalColumSettings(additionalColumSettings);
            }
            if ((fixColumns = descr.getFixedColumns()) != null) {
                ArrayList<TicketListColumnSetting> fixedColumSettings = new ArrayList<TicketListColumnSetting>();
                for (TicketListColumnDescription col2 : fixColumns) {
                    fixedColumSettings.add(new TicketListColumnSetting(col2.getKey(), col2.getDisplayType(), col2.getWidth()));
                }
                model.setFixedColumSettings(fixedColumSettings);
            }
            if ((idColumns = descr.getIdentifierColumns()) != null) {
                ArrayList<TicketListColumnSetting> arrayList = new ArrayList<TicketListColumnSetting>();
                for (TicketListColumnDescription col : idColumns) {
                    arrayList.add(new TicketListColumnSetting(col.getKey(), col.getDisplayType(), col.getWidth()));
                }
                model.setIdentifierColumSettings(arrayList);
            }
            layoutSettings.put(descr.getLayoutKey(), model);
        }
        settingsModel.setLayoutSettings(layoutSettings);
        MutableUserData userData = new MutableUserData();
        userData.put(TicketListServerPlugin.USERFIELD_TICKETLIST_LISTLAYOUTSETTINGS, (Object)new Json().toJson((Object)settingsModel));
        UserManager.getInstance().updateUserData(currentUser.getID(), userData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllCacheEntriesForUser(GUID id) {
        MemoryStoreMap<CacheKey, TicketListLayoutDescription> memoryStoreMap = layoutCache;
        synchronized (memoryStoreMap) {
            Iterator iterator = layoutCache.keySet().iterator();
            while (iterator.hasNext()) {
                CacheKey key = (CacheKey)iterator.next();
                if (!key.getId().equals((Object)id)) continue;
                iterator.remove();
            }
        }
        TicketPageLayoutManager.getInstance().removeAllCacheEntriesForUser(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllCacheEntriesForGroup(UserGroupInfo group) {
        MemoryStoreMap<CacheKey, TicketListLayoutDescription> memoryStoreMap = layoutCache;
        synchronized (memoryStoreMap) {
            if (UsersAndGroups.GROUPID_ALLUSERS.equals((Object)group.getID())) {
                layoutCache.clear();
            } else {
                Set memberIDs = group.getMemberIDs();
                Iterator iterator = layoutCache.keySet().iterator();
                while (iterator.hasNext()) {
                    CacheKey key = (CacheKey)iterator.next();
                    if (!memberIDs.contains(key.getId())) continue;
                    iterator.remove();
                }
            }
        }
        TicketPageLayoutManager.getInstance().removeAllCacheEntriesForGroup(group);
    }

    public void userAccountCreated(@Nonnull UserAccount userAccount) {
    }

    public void userAccountBeforeUpdate(@Nonnull UserAccount userAccount) {
    }

    public void userAccountUpdated(@Nonnull UserAccount userAccountBefore, @Nonnull UserAccount userAccountAfter) {
        this.removeAllCacheEntriesForUser(userAccountAfter.getID());
    }

    public void userAccountDeactivated(@Nonnull UserAccount userAccount) {
        this.removeAllCacheEntriesForUser(userAccount.getID());
    }

    public void userAccountReactivated(@Nonnull UserAccount userAccount) {
        this.removeAllCacheEntriesForUser(userAccount.getID());
    }

    public void userAccountBeforeDeleted(@Nonnull UserAccount userAccount) {
    }

    public void userAccountDeleted(@Nonnull UserAccount userAccount) {
        this.removeAllCacheEntriesForUser(userAccount.getID());
    }

    public void groupCreated(@Nonnull UserGroupInfo groupInfo) {
    }

    public void groupRenamed(@Nonnull String previousGroupName, @Nonnull UserGroupInfo groupInfo) {
    }

    public void groupParentChanged(@Nonnull UserGroupInfo groupInfo) {
        this.removeAllCacheEntriesForGroup(groupInfo);
    }

    public void groupDataUpdated(@Nonnull UserGroupInfo groupInfo) {
        this.removeAllCacheEntriesForGroup(groupInfo);
    }

    public void groupMembersUpdated(@Nonnull UserGroupInfo groupInfo, @Nonnull Map<GUID, Set<MembershipType>> addedMemberships, @Nonnull Map<GUID, Set<MembershipType>> removedMemberships) {
        this.removeAllCacheEntriesForGroup(groupInfo);
    }

    public void groupDeleted(@Nonnull UserGroupInfo groupInfo) {
        this.removeAllCacheEntriesForGroup(groupInfo);
    }

    public void groupDeactivated(@Nonnull UserGroupInfo groupInfo) {
        this.removeAllCacheEntriesForGroup(groupInfo);
    }

    static class Singleton {
        private static TicketListLayoutManager INSTANCE;

        Singleton() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nonnull
        public static TicketListLayoutManager getInstance() {
            if (INSTANCE != null) return INSTANCE;
            Class<TicketListLayoutManager> clazz = TicketListLayoutManager.class;
            synchronized (TicketListLayoutManager.class) {
                if (INSTANCE != null) return INSTANCE;
                INSTANCE = new TicketListLayoutManager();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }
    }
}

