/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.api.fieldconditions;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.editing.FieldEditDescription;
import com.inet.helpdesk.plugins.ticketlist.api.fieldconditions.FieldCondition;
import com.inet.helpdesk.plugins.ticketlist.api.fieldconditions.FieldConditionAction;
import com.inet.helpdesk.plugins.ticketlist.api.fieldconditions.FieldConditionProvider;
import com.inet.helpdesk.plugins.ticketlist.api.fieldconditions.FieldConditionsDescription;
import com.inet.plugin.DynamicExtensionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class FieldConditionManager {
    public FieldConditionsDescription getConditionsForAction(@Nonnull ActionVO action, @Nullable List<Integer> ticketIds) {
        HashMap<String, FieldEditDescription> fields = new HashMap<String, FieldEditDescription>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>();
        HashSet keysOfFields = new HashSet();
        List providers = DynamicExtensionManager.getInstance().get(FieldConditionProvider.class);
        for (FieldConditionProvider provider : providers) {
            List<FieldCondition> additionalConditions = provider.getConditionsForAction(action, ticketIds);
            if (additionalConditions == null) continue;
            conditions.addAll(additionalConditions);
            keysOfFields.addAll(additionalConditions.stream().map(c -> c.getActions().stream().map(FieldConditionAction::getFieldKey).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet()));
        }
        if (!keysOfFields.isEmpty()) {
            ArrayList tickets = new ArrayList();
            if (ticketIds != null) {
                tickets.addAll(TicketManager.getReader().getTickets(ticketIds));
            }
            List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            for (TicketFieldDefinition definition : fieldDefs) {
                FieldEditDefinition editDefinition;
                if (!keysOfFields.contains(definition.getKey()) || (editDefinition = definition.getEditDefinition()) == null || !editDefinition.isAvailable(tickets)) continue;
                if (ticketIds == null) {
                    editDefinition.updateCurrentValue(null, null, fieldValues);
                } else if (ticketIds.size() == 1) {
                    editDefinition.updateCurrentValue(TicketManager.getReader().getTicket(ticketIds.get(0).intValue()), null, fieldValues);
                } else if (ticketIds.size() > 1) {
                    boolean multiValues = false;
                    String oldDisplayValue = null;
                    for (int i = 0; i < ticketIds.size(); ++i) {
                        String displayValue = definition.getDisplayValue(TicketManager.getReader().getTicket(ticketIds.get(i).intValue()));
                        if (i > 0 && !Objects.equals(oldDisplayValue, displayValue)) {
                            multiValues = true;
                            break;
                        }
                        oldDisplayValue = displayValue;
                    }
                    if (multiValues) {
                        editDefinition.updateCurrentValue(null, null, fieldValues);
                    } else {
                        editDefinition.updateCurrentValue(TicketManager.getReader().getTicket(ticketIds.get(0).intValue()), null, fieldValues);
                    }
                }
                FieldEditDescription description = new FieldEditDescription(editDefinition.getFieldKey(), editDefinition.getDisplayType(), editDefinition.getDisplayName(), definition.getDescription(), definition.getProperties());
                fields.put(editDefinition.getFieldKey(), description);
            }
        }
        return new FieldConditionsDescription(fields, fieldValues, conditions);
    }
}

