/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ticketlistlayout;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketListLayout;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.ColumnDisplayType;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnSetting;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutSpecificSettingsModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ExpertTicketListLayout
implements TicketListLayout {
    @Override
    public String getKey() {
        return "expert";
    }

    @Override
    public String getDisplayName() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.layout.expert", new Object[0]);
    }

    @Override
    public String getDescription() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.layout.expert.description", new Object[0]);
    }

    @Override
    public int getTicketListBlockSize() {
        return 75;
    }

    @Override
    @Nonnull
    public List<TicketListColumnDescription> getAdditionalColumns(Map<String, TicketListColumnDescription> allAvailableColumns, TicketListLayoutSpecificSettingsModel userSpecificSettings) {
        ArrayList<TicketListColumnSetting> additionalColumnSettings;
        ArrayList<TicketListColumnDescription> additionalColumns = new ArrayList<TicketListColumnDescription>();
        ArrayList<TicketListColumnSetting> arrayList = additionalColumnSettings = userSpecificSettings != null ? userSpecificSettings.getAdditionalColumSettings() : null;
        if (additionalColumnSettings != null) {
            for (TicketListColumnSetting columnSetting : additionalColumnSettings) {
                TicketListColumnDescription colDesrc = allAvailableColumns.get(columnSetting.getColumnKey());
                if (colDesrc == null) continue;
                additionalColumns.add(colDesrc.clone(columnSetting.getDisplayType(), columnSetting.getWidth()));
            }
        } else {
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.FIELD_SUBJECT.getKey()));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.FIELD_OWNER_GUID.getKey()));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.FIELD_RESOURCE_GUID.getKey()));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.ATTRIBUTE_SUM_TIME.getKey()));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.FIELD_CATEGORY_ID.getKey()));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.FIELD_ITIL_ID.getKey()));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.ATTRIBUTE_INQUIRY_DATE.getKey()));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get("escalation"));
            this.cloneAndAddDescription(additionalColumns, allAvailableColumns.get(Tickets.FIELD_DEADLINE.getKey()));
        }
        return additionalColumns;
    }

    @Override
    public int getMaximumAdditionalColumnCount() {
        return -1;
    }

    @Override
    public int getMinimumAdditionalColumnCount() {
        return 3;
    }

    @Override
    @Nonnull
    public List<TicketListColumnDescription> getIdentifierColumns(Map<String, TicketListColumnDescription> allAvailableColumns, TicketListLayoutSpecificSettingsModel userSpecificSettings) {
        ArrayList<TicketListColumnSetting> identifierColumnSettings;
        ArrayList<TicketListColumnDescription> identityColumns = new ArrayList<TicketListColumnDescription>();
        ArrayList<TicketListColumnSetting> arrayList = identifierColumnSettings = userSpecificSettings != null ? userSpecificSettings.getIdentifierColumSettings() : null;
        if (identifierColumnSettings != null) {
            for (TicketListColumnSetting columnSetting : identifierColumnSettings) {
                TicketListColumnDescription colDesrc = allAvailableColumns.get(columnSetting.getColumnKey());
                if (colDesrc == null) continue;
                identityColumns.add(colDesrc.clone(columnSetting.getDisplayType(), columnSetting.getWidth()));
            }
        } else {
            this.cloneAndAddDescription(identityColumns, allAvailableColumns.get(Tickets.FIELD_PRIORITY_ID.getKey()), ColumnDisplayType.icon);
            this.cloneAndAddDescription(identityColumns, allAvailableColumns.get(Tickets.ATTRIBUTE_ATTACHMENTS.getKey()), ColumnDisplayType.icon);
            this.cloneAndAddDescription(identityColumns, allAvailableColumns.get(Tickets.ATTRIBUTE_STATUS_ID.getKey()), ColumnDisplayType.icon);
            this.cloneAndAddDescription(identityColumns, allAvailableColumns.get("ticketid"), ColumnDisplayType.text);
        }
        return identityColumns;
    }

    @Override
    public int getMaximumIdentifierColumnCount() {
        return 5;
    }

    @Override
    public URL getLayoutTemplate() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/client/ticketlistlayout/expertlayout.html");
    }

    @Override
    public URL getPreviewTemplate() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/client/ticketlistlayout/expertpreview.html");
    }

    @Override
    public TicketListLayout.PreviewPosition getDefaultPreviewPosition() {
        return TicketListLayout.PreviewPosition.vertical;
    }
}

