/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDuplicator;
import com.inet.helpdesk.plugins.attachments.server.ticketlist.AttachmentData;
import com.inet.helpdesk.plugins.attachments.server.ticketlist.TicketAttachmentsContextDependentLoader;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.data.TicketActionCount;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererExtension;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.plugins.ticketlist.server.data.ExecuteActionRequest;
import com.inet.helpdesk.plugins.ticketlist.server.data.ExecuteActionResponse;
import com.inet.helpdesk.plugins.ticketlist.server.handler.AbstractTicketListHandler;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ExecuteActionHandler
extends AbstractTicketListHandler<ExecuteActionRequest, ExecuteActionResponse> {
    public String getMethodName() {
        return "ticketlist.executeaction";
    }

    @Override
    protected ExecuteActionResponse handleRequest(HttpServletRequest request, HttpServletResponse response, ExecuteActionRequest input, UserAccount currentUser) throws ClientMessageException {
        if (input.getActionId().equals("split")) {
            try {
                int firstTicketId = input.getTicketIds().get(0);
                final Integer stepId = input.getStepId();
                Map<String, String> values = input.getValues();
                ReaStepTextVO stepText = null;
                String stepContent = values.get(TicketFieldRendererId.htmleditor.name());
                boolean htmlContent = Boolean.valueOf(values.get(TicketFieldRendererId.htmlcontent.name()));
                stepContent = htmlContent ? TicketTextFunctions.prepareHtmlTextForSaving((String)TicketTextFunctions.correctAttachmentPathesForServer((String)stepContent)) : TicketTextFunctions.convertToPlainText((String)stepContent);
                stepText = ReaStepTextVO.of((String)stepContent, (boolean)htmlContent);
                final TicketVO ticket = TicketManager.getReaderForSystem().getTicket(firstTicketId);
                Set includedFields = ticket.getIncludedFields();
                MutableTicketData data = new MutableTicketData();
                for (TicketField ticketField : includedFields) {
                    if (ticketField.equals(Tickets.FIELD_LINKS)) continue;
                    data.put(ticketField, ticket.getValue(ticketField));
                }
                ExtensionArguments actionExtArgs = ExtensionArguments.create();
                actionExtArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, (Object)TicketDataConnector.MailNotification.NEVER);
                actionExtArgs.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.ofBooleanFlag((Boolean)ticket.isDispatched()));
                HashMap<String, String> mandatoryValues2 = input.getMandatoryValues();
                if (mandatoryValues2 != null && !mandatoryValues2.isEmpty()) {
                    List fieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                    for (TicketFieldDefinition def : fieldDefinitions) {
                        FieldEditDefinition editDefinition = def.getEditDefinition();
                        if (editDefinition == null || !mandatoryValues2.containsKey(editDefinition.getFieldKey())) continue;
                        editDefinition.updateTicketData(data, mandatoryValues2);
                    }
                    actionExtArgs.put(ExtensionArguments.EXTARG_TICKET_DATA, (Object)data);
                }
                final TicketVO createdTicket = TicketManager.getManipulator().createTicket(stepText, data, null, actionExtArgs);
                final int newTicketId = createdTicket.getID();
                ServerPluginManager spm = ServerPluginManager.getInstance();
                spm.runIfPluginLoaded("attachments", () -> new Executable(){

                    public void execute() {
                        ArrayList<Object> attachmentsToCopy = new ArrayList<Object>();
                        TicketAttachmentsContextDependentLoader.TicketAttachmentsContextDependentLoaderResult result = new TicketAttachmentsContextDependentLoader().load(ticket, Collections.singleton(stepId));
                        ArrayList attachments = result.getAttachments();
                        for (Object attachmentData : attachments) {
                            if (stepId.compareTo(attachmentData.getStepId()) != 0) continue;
                            attachmentsToCopy.add(attachmentData);
                        }
                        ArrayList<AttachmentKey> attachmentKeys = new ArrayList<AttachmentKey>();
                        attachmentsToCopy.removeIf(a -> a.isEmbedded());
                        for (AttachmentData attachmentData : attachmentsToCopy) {
                            attachmentKeys.add(new AttachmentKey(AttachmentOwnerType.getTypeForId((int)attachmentData.getTypeId()), attachmentData.getOwnerId(), stepId, Integer.valueOf(-1), attachmentData.getFileName()));
                        }
                        AttachmentDuplicator duplicator = (AttachmentDuplicator)ServerPluginManager.getInstance().getSingleInstance(AttachmentDuplicator.class);
                        try {
                            duplicator.duplicateAttachments(attachmentKeys, AttachmentOwnerType.TicketAttachment, newTicketId, createdTicket.getInitialReaStepID(), -1);
                        }
                        catch (SQLException sQLException) {
                            throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.createnewticket.attachment.failed", new Object[]{String.valueOf(createdTicket)}));
                        }
                    }
                });
                if (ServerOptions.isOptionSet((int)65536) && TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(-35) && TicketManager.getTicketActionChecker().checkAktionUpdateTicketData(newTicketId) == null && TicketManager.getTicketActionChecker().checkAktionUpdateTicketData(firstTicketId) == null) {
                    TicketManager.getTicketLinking().addBidirectionalLinkBetween(firstTicketId, newTicketId);
                }
                return new ExecuteActionResponse(newTicketId);
            }
            catch (Throwable t) {
                if (t instanceof ClientMessageException) {
                    throw (ClientMessageException)t;
                }
                TicketListServerPlugin.LOGGER.error(t);
                throw new ClientMessageException(t.getMessage());
            }
        }
        try {
            Optional<UserField> first;
            Map<String, String> values = input.getValues();
            MutableReaStepData stepData = new MutableReaStepData();
            MutableReaStepText stepText = null;
            String stepContent = values.get(TicketFieldRendererId.htmleditor.name());
            boolean htmlContent = Boolean.valueOf(values.get(TicketFieldRendererId.htmlcontent.name()));
            stepContent = htmlContent ? TicketTextFunctions.prepareHtmlTextForSaving((String)TicketTextFunctions.correctAttachmentPathesForServer((String)stepContent)) : TicketTextFunctions.convertToPlainText((String)stepContent);
            stepText = MutableReaStepText.of((String)stepContent, (boolean)htmlContent);
            ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(input.getActionId(), input.getTicketIds().get(0).intValue());
            ExtensionArguments extensionArgs = ExtensionArguments.create();
            if (action.getId() == -22) {
                extensionArgs.put(ExtensionArguments.EXTARG_CHANGED_REA_STEP, (Object)ExtensionArguments.EditReastepTextActionExtensionData.create((int)input.getStepId(), (ReaStepTextVO)stepText.toVO()));
            }
            HashMap<String, String> mandatoryValues = input.getMandatoryValues();
            MutableTicketData ticketData = new MutableTicketData();
            if (mandatoryValues != null && !mandatoryValues.isEmpty()) {
                List fieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                Iterator mandatoryValues2 = fieldDefinitions.iterator();
                while (mandatoryValues2.hasNext()) {
                    TicketFieldDefinition def = (TicketFieldDefinition)mandatoryValues2.next();
                    FieldEditDefinition editDefinition = def.getEditDefinition();
                    if (editDefinition == null || !mandatoryValues.containsKey(editDefinition.getFieldKey())) continue;
                    editDefinition.updateTicketData(ticketData, mandatoryValues);
                }
                extensionArgs.put(ExtensionArguments.EXTARG_TICKET_DATA, (Object)ticketData);
            }
            for (Integer ticketId : input.getTicketIds()) {
                TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                this.checkCustomMandatoryFields(ticket, ticketData, action);
            }
            List<String> additionalCloseActionKeys = input.getAdditionalCloseActionKeys();
            if (additionalCloseActionKeys.contains("suppressAutoMail") || additionalCloseActionKeys.contains("authorizeAndSuppressAutoMail")) {
                extensionArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, (Object)TicketDataConnector.MailNotification.NO_MAILS_TO_ENDUSER);
            }
            ApplyActionRendererProvider.getInstance().prepareReastepActionData(stepData, stepText, extensionArgs, action, values, request, input.getDuration(), input.getAttachments());
            if (extensionArgs.containsExtArg(ExtensionArguments.EXTARG_APPLY_ANSWER)) {
                ExtensionArguments.AdditionalEmailAction additionalAction = ExtensionArguments.AdditionalEmailAction.SEND_ONLY;
                if (additionalCloseActionKeys != null && !additionalCloseActionKeys.isEmpty()) {
                    for (String key : additionalCloseActionKeys) {
                        try {
                            additionalAction = ExtensionArguments.AdditionalEmailAction.valueOf((String)key);
                        }
                        catch (IllegalArgumentException iae) {}
                    }
                }
                extensionArgs.put(ExtensionArguments.EXTARG_APPLY_ANSWER, (Object)additionalAction);
                Integer stepId = input.getStepId();
                if (stepId != null) {
                    extensionArgs.put(ExtensionArguments.EXTARG_APPLY_ANSWER_REFERENCED_STEP, (Object)stepId);
                }
            }
            TicketAccessInformationsProvider ticketAccessInformationsProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
            int newStatusId = action.getStatusID();
            boolean canReadTicket = true;
            for (Integer ticketId : input.getTicketIds()) {
                try {
                    if (input.isLeaveTicketAfterSuccess()) {
                        TicketManager.getManipulator().changeTicketStatusToRead(ticketId.intValue());
                    }
                    TicketManager.getManipulator().applyAction(ticketId.intValue(), stepData, stepText.toVO(), action, extensionArgs);
                }
                catch (IllegalArgumentException | IllegalStateException iae) {
                    TicketListServerPlugin.LOGGER.debug((Object)iae);
                    throw new ClientMessageException(iae.getMessage());
                }
                if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketId.intValue())) {
                    canReadTicket = false;
                } else {
                    TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                    if (ticket != null) {
                        newStatusId = ticket.getStatusID();
                    }
                }
                if (!input.isLeaveTicketAfterSuccess()) continue;
                ticketAccessInformationsProvider.leaveTickets(input.getClientID(), new int[]{ticketId});
            }
            String actionCountKey = input.getActionCountKey();
            if (!StringFunctions.isEmpty((String)actionCountKey) && (first = UserManager.getAllFields().stream().filter(f -> actionCountKey.equals(f.getKey())).findFirst()).isPresent()) {
                UserField ticketActionCountField = first.get();
                TicketActionCount actionCount = (TicketActionCount)currentUser.getValue(ticketActionCountField);
                if (actionCount == null) {
                    actionCount = new TicketActionCount();
                }
                actionCount.increaseActionCount(action.getUniqueID());
                MutableUserData userData = new MutableUserData();
                userData.put(ticketActionCountField, (Object)actionCount);
                UserManager.getInstance().updateUserData(UserManager.getInstance().getCurrentUserAccountID(), userData);
            }
            if (additionalCloseActionKeys.contains("leaveTicket")) {
                canReadTicket = false;
            }
            return new ExecuteActionResponse(canReadTicket, newStatusId);
        }
        catch (Throwable t) {
            if (t instanceof ClientMessageException) {
                throw (ClientMessageException)t;
            }
            if (t instanceof FieldValidationException) {
                throw new ClientMessageException(t.getMessage());
            }
            TicketListServerPlugin.LOGGER.error(t);
            throw new ClientMessageException(t.getMessage());
        }
    }

    private void checkCustomMandatoryFields(TicketVO ticket, MutableTicketData data, ActionVO action) {
        List aares = ServerPluginManager.getInstance().get(ApplyActionRendererExtension.class);
        Collections.sort(aares, (a, b) -> Integer.compare(a.getPriority(), b.getPriority()));
        TicketVOSingle ticketForFieldCheck = TicketVOSingle.create((int)ticket.getID(), (MutableTicketAttributes)new MutableTicketAttributes(), (MutableTicketData)data);
        for (ApplyActionRendererExtension aare : aares) {
            Optional<String> findFirst;
            Map<TicketField<?>, String> fieldsToChange = aare.getFieldsToChangeBeforeAction((TicketVO)ticketForFieldCheck, action);
            if (fieldsToChange == null || !(findFirst = fieldsToChange.values().stream().filter(e -> !StringFunctions.isEmpty((String)e)).findFirst()).isPresent()) continue;
            throw new ClientMessageException(findFirst.get());
        }
    }
}

