/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.export;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.server.ticketlist.AttachmentData;
import com.inet.helpdesk.plugins.attachments.server.ticketlist.TicketAttachmentsContextDependentLoader;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.cache.Cache;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;

public class TicketExporter {
    public void exportTicketToStream(@Nonnull TicketVO ticket, @Nonnull OutputStream outStream) throws IOException, ReportException, SQLException {
        this.exportTicketToStream(ticket, outStream, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportTicketToStream(@Nonnull TicketVO ticket, @Nonnull OutputStream outStream, boolean includeSteps, boolean includeAttachments) throws IOException, ReportException, SQLException {
        boolean hadAnyEntries;
        block23: {
            if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticket.getID())) {
                throw new ClientMessageException(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.export.noaccesstoticket", new Object[0]));
            }
            hadAnyEntries = false;
            try (ZipOutputStream zipStream = new ZipOutputStream(outStream);){
                ServerPluginManager spm;
                UserManager userManager = UserManager.getInstance();
                UserAccount currentUserAccount = userManager.getCurrentUserAccount();
                TicketReader ticketReader = TicketManager.getReader();
                List reaStepVOs = ticketReader.getReaStepsForTicket(ticket.getID(), BundleStepsFilter.WITH_BUNDLE_STEPS);
                Set availableStepsIds = reaStepVOs.stream().map(step -> step.getID()).collect(Collectors.toSet());
                if (includeSteps) {
                    Engine eng = this.createRenderEngine(ticket, currentUserAccount);
                    ZipEntry zre = new ZipEntry(ticket.getID() + ".pdf");
                    try {
                        zre.setTime(System.currentTimeMillis());
                        zipStream.putNextEntry(zre);
                        hadAnyEntries = true;
                        for (int i = 1; i <= eng.getPageCount(); ++i) {
                            zipStream.write(eng.getPageData(i));
                        }
                    }
                    finally {
                        zipStream.closeEntry();
                    }
                }
                if (!(spm = ServerPluginManager.getInstance()).isPluginLoaded("attachments") || !includeAttachments) break block23;
                TicketAttachmentsContextDependentLoader.TicketAttachmentsContextDependentLoaderResult result = new TicketAttachmentsContextDependentLoader().load(ticket, availableStepsIds);
                ArrayList attachments = result.getAttachments();
                attachments.removeIf(a -> a.isDuplicate());
                AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
                if (attachments.isEmpty()) break block23;
                for (AttachmentData att : attachments) {
                    AttachmentFileRow attachmentFile;
                    Object fileName = att.getFileName();
                    if (att.getAdditionalId() != null && att.getAdditionalId() != -1) {
                        fileName = att.getAdditionalId() + "/" + (String)fileName;
                    }
                    if (att.getStepId() != null && att.getStepId() != -1) {
                        fileName = att.getStepId() + "/" + (String)fileName;
                    }
                    ZipEntry ze = new ZipEntry("attachments/" + (String)fileName);
                    AttachmentKey key = new AttachmentKey(AttachmentOwnerType.getTypeForId((int)att.getTypeId()), att.getOwnerId(), att.getStepId(), att.getAdditionalId(), att.getFileName());
                    AttachmentRow attachment = attService.getAttachment(key);
                    if (attachment == null || (attachmentFile = attService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength())) == null) continue;
                    try {
                        PersistenceEntry file = AppDataLocation.getAttachmentFile((String)attachmentFile.getFilePath());
                        ze.setTime(att.getLastModified());
                        ze.setSize(att.getFileLength());
                        zipStream.putNextEntry(ze);
                        hadAnyEntries = true;
                        InputStream attStream = file.getInputStream();
                        try {
                            IOFunctions.copyData((InputStream)attStream, (OutputStream)zipStream);
                        }
                        finally {
                            if (attStream == null) continue;
                            attStream.close();
                        }
                    }
                    finally {
                        zipStream.closeEntry();
                    }
                }
            }
        }
        return hadAnyEntries;
    }

    Engine createRenderEngine(TicketVO ticket, UserAccount currentUserAccount) throws ReportException {
        Properties props = new Properties();
        props.setProperty("export_fmt", "pdf");
        props.setProperty("locale", ClientLocale.getThreadLocale().toString());
        props.setProperty("timezone", ClientTimezone.getTimeZone().getID());
        props.setProperty("report", "ticketlist_inquirydetails.rpt");
        props.setProperty("promptticketid", "" + ticket.getID());
        props.setProperty("promptuserid", "" + HDUsersAndGroups.getUserID((GUID)currentUserAccount.getID()));
        props.setProperty("promptstepids", "");
        Cache.getPropertiesChecker().checkProperties(props, null);
        Engine eng = Cache.getEngineFactory().createEngine(props);
        eng.execute();
        return eng;
    }
}

