/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.event;

import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPreviewTextData;
import com.inet.helpdesk.plugins.ticketlist.server.data.TicketPreviewTextResponse;
import com.inet.helpdesk.plugins.ticketlist.server.event.TicketListWebSocketEvent;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;

public class TicketPreviewText
extends TicketListWebSocketEvent<TicketPreviewTextData> {
    public String getEventName() {
        return "ticketlist.ticketpreviewtext";
    }

    @Override
    protected void handleEvent(String clientID, TicketPreviewTextData payload) {
        if (payload.getTicketID() == null) {
            return;
        }
        TicketFunctions.PreviewInformation previewInformation = TicketFunctions.getTicketPreviewInformation(payload.getTicketID(), !payload.isLastText(), false);
        if (previewInformation != null) {
            WebSocketEventHandler.getInstance().sendEvent(clientID, () -> new WebSocketEventData(this.getEventName(), (Object)new TicketPreviewTextResponse(previewInformation.getUserIdentifier(), TicketFunctions.convertToActionDescription(previewInformation.getAction()), previewInformation.getEndDate(), previewInformation.getPreviewText(), previewInformation.getDescription(), previewInformation.getAttachments())));
        }
    }
}

