/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.ticketpageextensions.annotation;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageHint;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccount;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnnotationExtension
implements TicketPageExtension {
    public static final String EXTENSION_KEY = "ticketannotation";

    @Nonnull
    public String getExtensionName() {
        return EXTENSION_KEY;
    }

    public String getDisplayName() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.annotation.displayname", new Object[0]);
    }

    public String getDescription() {
        return TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.annotation.description", new Object[0]);
    }

    public URL getTemplateURL() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/ticketlist/client/ticketpage/extensions/annotationextension.html");
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public boolean isAvailable(UserAccount userAccount) {
        return HDUsersAndGroups.isSupporter((UserAccount)userAccount);
    }

    public boolean isVisibleForTicket(int ticketID) {
        return !TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketID).hasEnduserAccessToTicket();
    }

    public TicketPageHint getHint(UserAccount userAccount, TicketVO ticket) {
        if (ticket != null && !StringFunctions.isEmpty((String)ticket.getAnnotation())) {
            return new TicketPageHint(EXTENSION_KEY, this.getDisplayName(), EXTENSION_KEY, TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.annotation.hint.title", new Object[0]), TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.extension.annotation.hint.message", new Object[0]));
        }
        return null;
    }

    @Nullable
    public String getCountPreview(UserAccount userAccount, TicketVO ticket) {
        if (!StringFunctions.isEmpty((String)ticket.getAnnotation())) {
            return "\u2713";
        }
        return null;
    }
}

