/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.signing;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.utils.TicketValuesImageResolver;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.server.signing.TicketSigningValue;
import com.inet.helpdesk.shared.model.Status;
import com.inet.lib.util.IOFunctions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketSigning {
    public static final String TICKET_SIGNING_IMAGE = "ticketsigningimage";
    public static final int TICKET_SIGNING_ACTION_ID = -214;
    public static final ExtensionArguments.ExtArg<TicketSigningValue> EXTARG_TICKET_SIGNING_IMAGE = new ExtensionArguments.JsonizableAndImmutableExtArg("ticketsigningimage", TicketSigningValue.class);

    public static void registerSigningAction() {
        int statusId;
        ActionManager actionManager = ActionManager.getInstance();
        StatusManager statusManager = StatusManager.getInstance();
        ActionVO _actionVO = (ActionVO)actionManager.get(-214);
        if (_actionVO != null) {
            if (_actionVO.getStatusID() == -214) {
                try {
                    actionManager.update(new ActionVO(-214, "Unterschreiben", -100, false, 0, 0, 0.0, false, 0, false));
                }
                catch (SQLException e) {
                    TicketListServerPlugin.LOGGER.error((Throwable)e);
                    return;
                }
            } else {
                return;
            }
        }
        int[] iconSizes = new int[]{16, 24, 32, 48, 64};
        StatusVO _statusVO = (StatusVO)statusManager.get(-214);
        if (_statusVO != null) {
            try {
                statusManager.remove(-214);
            }
            catch (SQLException e) {
                TicketListServerPlugin.LOGGER.error((Throwable)e);
                return;
            }
        }
        for (statusId = 202; statusId <= 300 && statusManager.get(statusId) != null; ++statusId) {
        }
        if (statusId == 300) {
            TicketListServerPlugin.LOGGER.error((Object)"Could not find free status id between 202 and 299 for ticket signing");
            return;
        }
        try {
            String imageName = "signing";
            String newImageName = "data/0/" + statusId;
            for (int i = 0; i < iconSizes.length; ++i) {
                URL iconUrl = TicketSigning.class.getResource(imageName + "_" + iconSizes[i] + ".png");
                if (iconUrl == null) continue;
                try (InputStream openStream = iconUrl.openStream();){
                    byte[] readBytes = IOFunctions.readBytes((InputStream)openStream);
                    TicketValuesImageResolver.getInstance().storeIcon(newImageName, "data:image/png;base64," + Base64.getEncoder().encodeToString(readBytes), iconSizes[i]);
                    continue;
                }
                catch (IOException e) {
                    TicketListServerPlugin.LOGGER.error((Throwable)e);
                }
            }
            StatusVO newStatus = new StatusVO(statusId, "Unterschrieben", "signing", false, true);
            newStatus.setImageName(newImageName);
            statusManager.add((FieldVO)newStatus);
        }
        catch (SQLException e) {
            TicketListServerPlugin.LOGGER.error((Throwable)e);
            return;
        }
        ActionVO newAction = new ActionVO(-214, "Unterschreiben", statusId, false, 0, 0, 0.0, false, 32, false);
        if (_actionVO == null) {
            try {
                actionManager.add(newAction, false);
            }
            catch (SQLException e) {
                TicketListServerPlugin.LOGGER.error((Throwable)e);
            }
        } else {
            try {
                actionManager.update(newAction);
            }
            catch (SQLException e) {
                TicketListServerPlugin.LOGGER.error((Throwable)e);
            }
        }
    }

    public static TicketActionExtensionFactory getSigningExtension() {
        return new TicketActionExtensionFactory(){

            @Nullable
            public TicketActionExtension createIfApplicable(@Nonnull OperationChangedTicket ticket, @Nonnull ActionVO action, @Nonnull ExtensionArguments arguments, @Nonnull MutableReaStepData reaStepFields) {
                return null;
            }

            public String checkActionPreconditions(TicketVO ticket, ActionVO action, TicketPermissionContext ticketPermissionInfo) {
                if (action.getId() == -214 && Status.isClosedOrDeletedStatus((int)ticket.getStatusID())) {
                    return Tickets.MSG.getMsg("actionchecker.ticketNotOpen", new Object[0]);
                }
                return super.checkActionPreconditions(ticket, action, ticketPermissionInfo);
            }
        };
    }
}

