/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.api;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.ColumnDisplayType;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListColumnDescription;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutSpecificSettingsModel;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@InternalApi
public interface TicketListLayout {
    public String getKey();

    public String getDisplayName();

    public String getDescription();

    public int getTicketListBlockSize();

    public URL getLayoutTemplate();

    public URL getPreviewTemplate();

    default public PreviewPosition getDefaultPreviewPosition() {
        return PreviewPosition.horizontal;
    }

    public int getMaximumAdditionalColumnCount();

    default public int getMinimumAdditionalColumnCount() {
        return 0;
    }

    default public int getMaximumIdentifierColumnCount() {
        return 0;
    }

    @Nonnull
    public List<TicketListColumnDescription> getAdditionalColumns(Map<String, TicketListColumnDescription> var1, TicketListLayoutSpecificSettingsModel var2);

    @Nonnull
    default public List<TicketListColumnDescription> getFixedColumns(Map<String, TicketListColumnDescription> allAvailableColumns, TicketListLayoutSpecificSettingsModel userSpecificSettings) {
        return Collections.emptyList();
    }

    @Nonnull
    default public List<TicketListColumnDescription> getIdentifierColumns(Map<String, TicketListColumnDescription> allAvailableColumns, TicketListLayoutSpecificSettingsModel userSpecificSettings) {
        return Collections.emptyList();
    }

    default public void cloneAndAddDescription(List<TicketListColumnDescription> columns, TicketListColumnDescription description, ColumnDisplayType displayType) {
        if (description != null) {
            columns.add(description.clone(displayType, null));
        }
    }

    default public void cloneAndAddDescription(List<TicketListColumnDescription> columns, TicketListColumnDescription description) {
        this.cloneAndAddDescription(columns, description, null);
    }

    public static enum PreviewPosition {
        horizontal,
        vertical,
        fullscreen,
        nopreview;

    }
}

