/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.api;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDescription;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.DuplicateRange;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.attachments.server.ticketlist.TicketAttachmentsContextDependentLoader;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.AutoTextDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.plugins.ticketlist.api.data.StepDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.TicketActionCount;
import com.inet.helpdesk.plugins.ticketlist.api.data.UserIdentifier;
import com.inet.helpdesk.plugins.ticketlist.api.display.TicketTextRenderExtension;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Font;
import java.text.Collator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@InternalApi
public class TicketFunctions {
    private static final ConfigValue<Boolean> SHOW_SUPPORTER_NAMES = new ConfigValue(HDConfigKeys.CLIENT_ENDUSER_SHOWBEARBEITER);
    private static List<@Nonnull Integer> priorityActions = Arrays.asList(-12, 5, 1, 2, 8);
    private static Set<@Nonnull Integer> disabledActions = Stream.of(-1, -13).collect(Collectors.toSet());
    private static final int MAX_PREVIEW_LENGTH = 2000;
    private static ConcurrentHashMap<Locale, Collator> collators = new ConcurrentHashMap();
    private static final String DCM_PLAIN_PLACEHOLDER_START = "!!duplicate-content-container-start!!";
    private static final String DCM_PLAIN_PLACEHOLDER_END = "!!duplicate-content-container-end!!";

    public static String getPlainAndShortenedPreviewText(int ticketID) {
        PreviewInformation ticketPreviewInformation = TicketFunctions.getTicketPreviewInformation(ticketID, false, true);
        if (ticketPreviewInformation == null) {
            return null;
        }
        return ticketPreviewInformation.previewText;
    }

    public static String getStepContentAsHTML(int ticketId, int stepId) {
        ReaStepTextVO reaStepText;
        String textContent = "";
        TicketReader ticketReader = TicketManager.getReader();
        ReaStepVO reaStep = ticketReader.getReaStep(stepId);
        if (reaStep != null && (reaStepText = ticketReader.getReaStepText(stepId)) != null) {
            String uid;
            textContent = reaStepText.getText();
            boolean hasHtmlContent = reaStepText.hasHtmlContent();
            List duplicateContentRanges = (List)reaStep.getValue((ReaStepField)ReaStepVO.FIELD_DUPLICATED_CONTENT);
            if (duplicateContentRanges != null && !duplicateContentRanges.isEmpty()) {
                UserManager userManager = UserManager.getInstance();
                UserAccount currentUserAccount = userManager.getCurrentUserAccount();
                boolean isSupporter = currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
                List reaStepVOs = ticketReader.getReaStepsForTicket(ticketId, isSupporter ? BundleStepsFilter.WITH_BUNDLE_STEPS : BundleStepsFilter.WITHOUT_BUNDLE_STEPS);
                TicketFunctions.removeDuplicateRangesFromHiddenSteps(duplicateContentRanges, reaStepVOs);
            }
            HashMap<DuplicateRange, Boolean> withSwitchRanges = new HashMap<DuplicateRange, Boolean>();
            if (duplicateContentRanges != null && !duplicateContentRanges.isEmpty()) {
                duplicateContentRanges.sort((a, b) -> Integer.compare(a.getFrom(), b.getFrom()));
                TicketFunctions.concatenateOverlappingRanges(duplicateContentRanges);
                HashSet<String> knownUids = new HashSet<String>();
                for (DuplicateRange range : duplicateContentRanges) {
                    uid = range.getUid() != null ? range.getUid().toString() : String.valueOf(stepId);
                    Boolean withSwitch = knownUids.add(uid);
                    withSwitchRanges.put(range, withSwitch);
                }
                Collections.reverse(duplicateContentRanges);
                int textLength = textContent.length();
                for (int i = 0; i < duplicateContentRanges.size(); ++i) {
                    DuplicateRange range = (DuplicateRange)duplicateContentRanges.get(i);
                    if (range.getTo() > textLength) continue;
                    String uid2 = range.getUid() != null ? range.getUid().toString() : String.valueOf(stepId);
                    StringBuilder b2 = new StringBuilder();
                    b2.append(textContent.substring(0, range.getFrom()));
                    TicketFunctions.appendDuplicateContentStart(b2, hasHtmlContent, uid2, (Boolean)withSwitchRanges.get(range));
                    b2.append(textContent.substring(range.getFrom(), range.getTo()));
                    TicketFunctions.appendDuplicateContentEnd(b2, hasHtmlContent, i == 0);
                    int to = range.getTo();
                    if (hasHtmlContent && textContent.regionMatches(true, to, "<br>", 0, 4)) {
                        to += 4;
                    }
                    b2.append(textContent.substring(to));
                    textContent = b2.toString();
                }
            }
            if (!hasHtmlContent) {
                textContent = HtmlConverter.text2html((String)textContent, (Font)TicketTextFunctions.getDefaultFont());
                textContent = textContent.replace("<head>", "<head><style>p{margin: 0px;}</style>");
                if (duplicateContentRanges != null && !duplicateContentRanges.isEmpty()) {
                    Collections.reverse(duplicateContentRanges);
                    int duplCount = duplicateContentRanges.size();
                    for (int i = 0; i < duplCount; ++i) {
                        DuplicateRange range;
                        range = (DuplicateRange)duplicateContentRanges.get(i);
                        uid = range.getUid() != null ? range.getUid().toString() : String.valueOf(stepId);
                        StringBuilder b3 = new StringBuilder();
                        int idx1 = textContent.indexOf(DCM_PLAIN_PLACEHOLDER_START);
                        if (idx1 >= 0) {
                            b3.append(textContent.substring(0, idx1));
                            TicketFunctions.appendDuplicateContentStart(b3, true, uid, (Boolean)withSwitchRanges.get(range));
                            idx1 += DCM_PLAIN_PLACEHOLDER_START.length();
                        } else {
                            idx1 = 0;
                        }
                        int idx2 = textContent.indexOf(DCM_PLAIN_PLACEHOLDER_END, idx1);
                        if (idx2 >= 0) {
                            b3.append(textContent.substring(idx1, idx2));
                            TicketFunctions.appendDuplicateContentEnd(b3, true, i == duplCount - 1);
                            idx2 += DCM_PLAIN_PLACEHOLDER_END.length();
                        } else {
                            idx2 = idx1;
                        }
                        b3.append(textContent.substring(idx2));
                        textContent = b3.toString();
                    }
                }
            }
            textContent = TicketTextFunctions.getInlinedHtml((String)textContent, (boolean)true);
            textContent = textContent.trim();
            textContent = TicketTextRenderExtension.modifyForViewing(MutableReaStepText.of((String)textContent, (boolean)true)).getText();
        }
        return textContent;
    }

    public static void removeDuplicateRangesFromHiddenSteps(@Nonnull List<DuplicateRange> duplicateContentRanges, @Nonnull List<ReaStepVO> reaStepVOs) {
        HashSet<Integer> availableStepsIds = new HashSet<Integer>();
        for (ReaStepVO step : reaStepVOs) {
            availableStepsIds.add(step.getID());
        }
        Iterator<DuplicateRange> it = duplicateContentRanges.iterator();
        while (it.hasNext()) {
            DuplicateRange range = it.next();
            HashSet ids = range.getIds();
            ids.retainAll(availableStepsIds);
            if (!ids.isEmpty()) continue;
            it.remove();
        }
    }

    private static void concatenateOverlappingRanges(@Nonnull List<DuplicateRange> duplicateContentRanges) {
        DuplicateRange prev = null;
        int to = -1;
        for (int i = 0; i < duplicateContentRanges.size(); ++i) {
            DuplicateRange range = duplicateContentRanges.get(i);
            if (to < range.getFrom()) {
                prev = range;
            } else {
                GUID prevUid = prev.getUid();
                prev = new DuplicateRange(prev.getFrom(), Math.max(to, range.getTo()), null, prevUid);
                duplicateContentRanges.remove(i);
                duplicateContentRanges.set(--i, prev);
                GUID currentUid = range.getUid();
                if (!Objects.equals(prevUid, currentUid)) {
                    for (int n = 0; n < duplicateContentRanges.size(); ++n) {
                        range = duplicateContentRanges.get(n);
                        if (!Objects.equals(currentUid, range.getUid())) continue;
                        duplicateContentRanges.set(n, new DuplicateRange(range.getFrom(), range.getTo(), null, prevUid));
                    }
                }
            }
            to = prev.getTo();
        }
    }

    private static void appendDuplicateContentStart(@Nonnull StringBuilder builder, boolean hasHtmlContent, @Nonnull String uid, Boolean withSwitch) {
        if (hasHtmlContent) {
            builder.append("<div><duplicate-content-container uid=\"" + uid + "\">");
            if (withSwitch.booleanValue()) {
                builder.append("<duplicate-content-switcher title=\"" + StringFunctions.encodeHTML((String)TicketListServerPlugin.CLIENT_MSG.getMsg("ticketlist.duplicatecontent.switch", new Object[0])) + "\"></duplicate-content-switcher>");
            }
            builder.append("<duplicate-content>");
        } else {
            builder.append(DCM_PLAIN_PLACEHOLDER_START);
        }
    }

    private static void appendDuplicateContentEnd(@Nonnull StringBuilder builder, boolean hasHtmlContent, boolean lastItem) {
        if (hasHtmlContent) {
            builder.append("</duplicate-content>");
            if (lastItem) {
                builder.append("<br>");
            }
            builder.append("</duplicate-content-container></div>");
        } else {
            builder.append(DCM_PLAIN_PLACEHOLDER_END);
        }
    }

    public static String getAutoTextHtml(@Nonnull String htmlText) {
        return TicketTextFunctions.getInlinedHtml((String)htmlText, (boolean)false);
    }

    public static String getStepContentHtml(String htmlText) {
        return TicketTextFunctions.getInlinedHtml((String)htmlText, (boolean)true);
    }

    private static List<SavedAttachmentData> getAttachmentsOfStep(TicketVO ticket, int stepId) {
        List attachments = null;
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (spm.isPluginLoaded("attachments")) {
            List<Integer> availableStepsIds = Arrays.asList(stepId);
            TicketAttachmentsContextDependentLoader.TicketAttachmentsContextDependentLoaderResult result = new TicketAttachmentsContextDependentLoader().load(ticket, availableStepsIds);
            attachments = result.getAttachments().stream().filter(a -> a.getStepId() != null && !a.isEmbedded()).map(a -> new SavedAttachmentData(a.getOwnerId(), a.getStepId(), a.getAdditionalId(), a.getTypeId(), a.getFileName(), a.getMimeType(), a.getFileLength(), a.getLastModified(), a.isEmbedded(), a.isDuplicate())).collect(Collectors.toList());
        }
        return attachments;
    }

    public static PreviewInformation getTicketPreviewInformation(int ticketID, boolean inquiryText, boolean shortenedPlainText) {
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketID)) {
            return null;
        }
        TicketReader ticketReader = TicketManager.getReader();
        TicketVO ticket = ticketReader.getTicket(ticketID);
        if (ticket == null) {
            return null;
        }
        if (inquiryText) {
            int initialReaStepID = ticket.getInitialReaStepID();
            return TicketFunctions.convertPreviewStep(ticketReader.getReaStep(initialReaStepID), shortenedPlainText, TicketFunctions.getAttachmentsOfStep(ticket, initialReaStepID));
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        boolean isSupporter = currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
        List reaSteps = ticketReader.getReaStepsForTicket(ticketID, isSupporter ? BundleStepsFilter.WITH_BUNDLE_STEPS : BundleStepsFilter.WITHOUT_BUNDLE_STEPS);
        if (reaSteps != null && !reaSteps.isEmpty()) {
            for (int i = 0; i < reaSteps.size(); ++i) {
                boolean conversationStep;
                ReaStepVO reaStep = (ReaStepVO)reaSteps.get(i);
                boolean bl = conversationStep = reaStep.hasText() || reaStep.getActionID() == 4;
                if (!conversationStep) continue;
                return TicketFunctions.convertPreviewStep(reaStep, shortenedPlainText, TicketFunctions.getAttachmentsOfStep(ticket, reaStep.getID()));
            }
        }
        return null;
    }

    private static PreviewInformation convertPreviewStep(ReaStepVO step, boolean shortenedPlainText, List<SavedAttachmentData> attachments) {
        TicketReader ticketReader = TicketManager.getReader();
        PreviewInformation previewInformation = new PreviewInformation();
        previewInformation.action = (ActionVO)ActionManager.getInstance().get(step.getActionID());
        previewInformation.userIdentifier = TicketFunctions.getUserIdentifierFromStep(step);
        previewInformation.endDate = step.getEndDate();
        previewInformation.attachments = attachments;
        previewInformation.description = step.getDescription();
        ReaStepTextVO lastReaStepText = ticketReader.getReaStepText(step.getID());
        Object textContent = "";
        if (lastReaStepText != null) {
            textContent = lastReaStepText.getText();
            if (shortenedPlainText) {
                if (lastReaStepText.hasHtmlContent()) {
                    HtmlConverter.ConvertResult html2text = HtmlConverter.html2text((String)textContent, (int)2000);
                    textContent = html2text.getContent();
                    if (!html2text.isComplete()) {
                        textContent = (String)textContent + "...";
                    }
                } else if (((String)textContent).length() > 2000) {
                    textContent = ((String)textContent).substring(0, 2000) + "...";
                }
            } else {
                if (!lastReaStepText.hasHtmlContent()) {
                    textContent = HtmlConverter.text2html((String)textContent, (Font)TicketTextFunctions.getDefaultFont());
                }
                textContent = TicketTextFunctions.getInlinedHtml((String)textContent, (boolean)true);
            }
            textContent = ((String)textContent).trim();
            textContent = TicketTextRenderExtension.modifyForViewing(MutableReaStepText.of((String)textContent, (!shortenedPlainText ? 1 : 0) != 0)).getText();
        }
        previewInformation.previewText = textContent;
        return previewInformation;
    }

    public static StepDescription convertToStepDescription(ReaStepVO step, Set<Integer> availableStepsIds) {
        StepDescription result = new StepDescription();
        result.setId(step.getID());
        result.setDescription(step.getDescription());
        result.setStartDate(step.getStartDate());
        result.setEndDate(step.getEndDate());
        Duration duration = Duration.ofMillis(step.getEndDate() - step.getStartDate());
        if (!duration.isNegative() && !duration.isZero()) {
            result.setDuration(String.format("%02d:%02d", duration.toHours(), duration.toMinutesPart()));
        }
        String emailSenderAddress = step.getEmailSenderAddress();
        String displayName = step.getDisplayName();
        result.setEmailSenderAddress(emailSenderAddress);
        if (!(StringFunctions.isEmpty((String)emailSenderAddress) || "HDS".equals(displayName) || "HelpDesk".equals(displayName) || StringFunctions.isEmpty((String)displayName) || displayName.equals(emailSenderAddress) || emailSenderAddress.contains("<") || emailSenderAddress.contains(">"))) {
            result.setEmailSenderAddress(displayName + " <" + emailSenderAddress + ">");
        }
        result.setEmailReceiverAddresses(step.getEmailReceiverAddresses());
        result.setEmailCCAdresses(step.getEmailCCAdresses());
        result.setEmailBCCAdresses(step.getEmailBCCAdresses());
        ActionVO action = (ActionVO)ActionManager.getInstance().get(step.getActionID());
        ActionDescription actionDescription = TicketFunctions.convertToActionDescription(action);
        String alternativeActionLabel = (String)step.getValue((ReaStepField)ReaStepVO.FIELD_ACTION_LABEL);
        if (!StringFunctions.isEmpty((String)alternativeActionLabel)) {
            actionDescription.setDisplayName(alternativeActionLabel);
        }
        result.setAction(actionDescription);
        UserIdentifier userIdentifier = TicketFunctions.getUserIdentifierFromStep(step);
        result.setUserIdentifier(userIdentifier);
        result.setSystemStep(userIdentifier == null && step.getActionID() != 4);
        boolean conversationStep = step.hasText() || step.getActionID() == 4;
        result.setConversationStep(conversationStep);
        Integer parentStepId = (Integer)step.getValue((ReaStepField)ReaStepVO.FIELD_PARENT_REASTEP);
        if (parentStepId != null && availableStepsIds.contains(parentStepId)) {
            result.setParentStepId(parentStepId);
        }
        ArrayList<AdditionalReaStepFieldDescription> fieldDescriptions = new ArrayList<AdditionalReaStepFieldDescription>();
        List stepFieldDefinitions = ServerPluginManager.getInstance().get(AdditionalReaStepFieldDefinition.class);
        for (AdditionalReaStepFieldDefinition stepFieldDefinition : stepFieldDefinitions) {
            List descriptions;
            if (!stepFieldDefinition.isAvailable(step) || (descriptions = stepFieldDefinition.convertToDescriptions(step, availableStepsIds)) == null) continue;
            fieldDescriptions.addAll(descriptions);
        }
        result.setAdditionalFieldDescriptions(fieldDescriptions);
        return result;
    }

    public static String createPublicDisplayName(String displayName, String fallBackDisplayName) {
        if (StringFunctions.isEmpty((String)displayName) || "HDS".equals(displayName) || "HelpDesk".equals(displayName)) {
            displayName = fallBackDisplayName;
        }
        return displayName;
    }

    public static UserIdentifier getUserIdentifierFromStep(ReaStepVO step) {
        GUID userID = step.getUserID();
        if (userID != null) {
            UserAccount userAccount = UserManager.getInstance().getUserAccount(userID);
            if (userAccount != null) {
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                if (!(currentUserAccount == null || userID.equals((Object)currentUserAccount.getID()) || ((Boolean)SHOW_SUPPORTER_NAMES.get()).booleanValue() || HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount))) {
                    return new UserIdentifier(TicketListServerPlugin.SERVER_MSG.getMsg("ticketlist.ticketpage.anonymous.supporter", new Object[0]), "");
                }
                return new UserIdentifier(userID, userAccount.getDisplayName());
            }
        } else {
            String displayName = step.getDisplayName();
            if (!StringFunctions.isEmpty((String)displayName)) {
                String emailSenderAddress = step.getEmailSenderAddress();
                if (!StringFunctions.isEmpty((String)emailSenderAddress)) {
                    return new UserIdentifier(TicketFunctions.createPublicDisplayName(displayName, emailSenderAddress), emailSenderAddress);
                }
                String publicDisplayName = TicketFunctions.createPublicDisplayName(displayName, null);
                if (publicDisplayName != null) {
                    return new UserIdentifier(publicDisplayName, null);
                }
            }
        }
        return null;
    }

    public static ActionDescription convertToActionDescription(ActionVO action) {
        if (action == null) {
            return new ActionDescription(-1, "", "DELETED", 100, true);
        }
        return new ActionDescription(action.getId(), action.getUniqueID(), action.getDisplayValue(), action.getStatusID(), action.isInternal());
    }

    public static List<ActionDescription> convertTicketActions(Collection<ActionVO> allPossibleActions, UserField<TicketActionCount> userfieldTicketlistActioncount) {
        ArrayList<Integer> allPossibleActionIds = new ArrayList<Integer>();
        ArrayList<ActionDescription> editActions = new ArrayList<ActionDescription>();
        if (allPossibleActions == null) {
            return editActions;
        }
        UserAccount currentUser = UserManager.getInstance().getCurrentUserAccount();
        for (ActionVO action : allPossibleActions) {
            Integer actionId = action.getId();
            if (disabledActions.contains(actionId)) continue;
            allPossibleActionIds.add(actionId);
            if (action.isInternal() || action.isDeleted()) continue;
            editActions.add(TicketFunctions.convertToActionDescription(action));
        }
        TicketActionCount actionCount = userfieldTicketlistActioncount == null || currentUser == null ? null : (TicketActionCount)currentUser.getValue(userfieldTicketlistActioncount);
        Collections.sort(editActions, (a, b) -> {
            boolean isBPrio;
            int bb;
            int aa;
            if (actionCount != null && (aa = actionCount.getCount(a.getUid()) / 3) != (bb = actionCount.getCount(b.getUid()) / 3)) {
                return bb - aa;
            }
            int indexA = priorityActions.indexOf(a.getId());
            int indexB = priorityActions.indexOf(b.getId());
            boolean isAPrio = indexA >= 0;
            boolean bl = isBPrio = indexB >= 0;
            if (isAPrio != isBPrio) {
                return isAPrio ? -1 : 1;
            }
            if (isAPrio) {
                return indexA < indexB ? -1 : 1;
            }
            Locale threadLocale = ClientLocale.getThreadLocale();
            Collator collator = collators.get(threadLocale);
            if (collator == null) {
                collator = Collator.getInstance(threadLocale);
                collator.setStrength(0);
                collators.put(threadLocale, collator);
            }
            return collator.compare(a.getDisplayName(), b.getDisplayName());
        });
        return editActions;
    }

    public static List<AutoTextDescription> convertAutoTexts(List<AutoTextVO> autoTexts) {
        ArrayList<AutoTextDescription> result = new ArrayList<AutoTextDescription>();
        if (autoTexts != null) {
            for (AutoTextVO autoText : autoTexts) {
                result.add(new AutoTextDescription(autoText.getId(), autoText.getGroupLabel(), autoText.getLabel(), autoText.getShortcut(), TicketFunctions.getAutoTextHtml(autoText.getContentText())));
            }
        }
        return result;
    }

    public static class PreviewInformation {
        private String previewText;
        private long endDate;
        private UserIdentifier userIdentifier;
        private ActionVO action;
        private String description;
        private List<SavedAttachmentData> attachments;

        public ActionVO getAction() {
            return this.action;
        }

        public UserIdentifier getUserIdentifier() {
            return this.userIdentifier;
        }

        public String getPreviewText() {
            return this.previewText;
        }

        public long getEndDate() {
            return this.endDate;
        }

        public List<SavedAttachmentData> getAttachments() {
            return this.attachments;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

