/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketlist.server.handler;

import com.inet.cache.MemoryStoreMap;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.ticketlist.TicketListServerPlugin;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class AttachmentPreview
extends ServiceMethod<Void, Void> {
    private static final MemoryStoreMap<String, byte[]> imagePreviewCache = new MemoryStoreMap(3600, true);
    private static final MemoryStoreMap<String, byte[]> mimetypePreviewCache = new MemoryStoreMap(3600, true);

    public String getMethodName() {
        return "ticketlist.attachmentpreview";
    }

    public short getMethodType() {
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Void invoke(HttpServletRequest request, HttpServletResponse response, Void input) {
        long lastModified;
        String filename;
        String style;
        block22: {
            Integer ownerId = Integer.valueOf(request.getParameter("ownerid"));
            Integer stepId = Integer.valueOf(request.getParameter("stepid"));
            String attType = request.getParameter("atttype");
            style = request.getParameter("style");
            filename = request.getParameter("filename");
            String mimeType = MimeTypes.getMimeType((String)filename);
            if (StringFunctions.isEmpty((String)style)) {
                style = "list";
            }
            if (StringFunctions.isEmpty((String)attType)) {
                attType = "ticket";
            }
            lastModified = -1L;
            try {
                AttachmentFileRow attachmentFile;
                String realFilePath;
                PersistenceEntry file;
                if (ownerId < 0) break block22;
                if (UserManager.getInstance().getCurrentUserAccountID() == null) {
                    throw new AccessDeniedException((ErrorCode)BaseErrorCode.UserLoginRequired, new Object[0]);
                }
                AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
                AttachmentRow attachment = attachmentService.getAttachment(new AttachmentKey(AttachmentOwnerType.getTypeForSubContext((String)attType), ownerId, stepId, Integer.valueOf(-1), filename));
                if (attachment == null) break block22;
                lastModified = attachment.getLastModified();
                if (!mimeType.toLowerCase().startsWith("image/") || !(file = AppDataLocation.getAttachmentFile((String)(realFilePath = (attachmentFile = attachmentService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength())).getFilePath()))).exists()) break block22;
                try (InputStream inputStream = file.getInputStream();){
                    if (inputStream != null) {
                        if (attachment.getFileLength() <= 262144L) {
                            AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)inputStream, (long)lastModified, (String)mimeType, (boolean)true);
                            Void void_ = null;
                            return void_;
                        }
                        byte[] cachedimage = (byte[])imagePreviewCache.get((Object)realFilePath);
                        if (cachedimage != null) {
                            AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)new FastByteArrayInputStream(cachedimage), (long)lastModified, (String)mimeType, (boolean)true);
                            Void void_ = null;
                            return void_;
                        }
                        BufferedImage image = ImageIO.read(inputStream);
                        if (image == null) {
                            this.serveMimetypeImage(request, response, style, filename, lastModified);
                            Void void_ = null;
                            return void_;
                        }
                        int imgWidth = image.getWidth();
                        int imgHeight = image.getHeight();
                        double ratio = (double)imgWidth / (double)imgHeight;
                        if (imgWidth > imgHeight) {
                            imgHeight = 360;
                            imgWidth = (int)Math.floor(360.0 * ratio);
                        } else {
                            imgWidth = 360;
                            imgHeight = (int)Math.floor(360.0 / ratio);
                        }
                        BufferedImage target = new BufferedImage(imgWidth, imgHeight, 2);
                        Graphics2D g = (Graphics2D)target.getGraphics();
                        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g.drawImage(image, 0, 0, imgWidth, imgHeight, null);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)target, "PNG", baos);
                        imagePreviewCache.put((Object)realFilePath, (Object)baos.toByteArray());
                        AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)new FastByteArrayInputStream(baos.toByteArray()), (long)lastModified, (String)mimeType, (boolean)true);
                        Void void_ = null;
                        return void_;
                    }
                }
            }
            catch (Throwable t) {
                TicketListServerPlugin.LOGGER.info((Object)t);
            }
        }
        try {
            this.serveMimetypeImage(request, response, style, filename, lastModified);
            return null;
        }
        catch (Throwable t) {
            TicketListServerPlugin.LOGGER.error(t);
        }
        return null;
    }

    private void serveMimetypeImage(HttpServletRequest request, HttpServletResponse response, String style, String filename, long lastModified) throws IOException {
        ImagesConnector imagesConnector = (ImagesConnector)ServerPluginManager.getInstance().getSingleInstance(ImagesConnector.class);
        URL urlToServe = imagesConnector.getMimetypeImageByFileName(filename, 32);
        if (urlToServe != null) {
            String mimeType = MimeTypes.getMimeType((String)urlToServe.getFile());
            byte[] cachedimage = (byte[])mimetypePreviewCache.get((Object)(style + " - " + urlToServe.toString()));
            if (cachedimage != null) {
                try (FastByteArrayInputStream resourceStream = new FastByteArrayInputStream(cachedimage);){
                    AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)resourceStream, (long)lastModified, (String)mimeType, (boolean)true);
                }
                return;
            }
            int targetWidth = 32;
            int targetHeight = 32;
            int yOffset = 0;
            if ("tiles".equals(style)) {
                targetWidth = 360;
                targetHeight = 80;
                yOffset = 10;
            }
            BufferedImage image = ImageIO.read(urlToServe);
            BufferedImage target = new BufferedImage(targetWidth, targetHeight, 2);
            Graphics2D g = (Graphics2D)target.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image, targetWidth / 2 - image.getWidth() / 2, yOffset > 0 ? yOffset : targetHeight / 2 - image.getHeight() / 2, image.getWidth(), image.getHeight(), null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)target, "PNG", baos);
            mimetypePreviewCache.put((Object)urlToServe.toString(), (Object)baos.toByteArray());
            AngularContentService.serveStaticContent((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)new FastByteArrayInputStream(baos.toByteArray()), (long)lastModified, (String)mimeType, (boolean)true);
        }
    }
}

