/*
 * Decompiled with CFR 0.152.
 */
package com.inet.theme.server;

import com.inet.annotations.InternalApi;
import com.inet.cache.HardDiskStoreMap;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.DebugUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.theme.server.LessGenerator;
import com.inet.theme.server.a;
import com.inet.thread.ThreadUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class ThemeEngine {
    public static final String THEMES_DIR = "themes";
    static final Logger e = LogManager.getLogger((String)"Theme");
    private HashSet<String> f = new HashSet();
    private final String g;
    private final boolean h;
    private boolean i = false;
    private HardDiskStoreMap<String, byte[]> j = new HardDiskStoreMap();

    public ThemeEngine(String appKey, boolean includeBootstrap) {
        if (appKey == null) {
            throw new NullPointerException("An appkey must be provided.");
        }
        this.h = includeBootstrap;
        this.g = appKey;
        this.j.setTimeout(DebugUtils.DEBUG ? 5 : 604800, true);
        a.b(Persistence.getInstance().resolve(THEMES_DIR));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private synchronized void b() {
        PersistenceEntry persistenceEntry2 = Persistence.getInstance().resolve(THEMES_DIR);
        @Nonnull List list = persistenceEntry2.getChildren();
        Set<@Nonnull T> set = list.stream().filter(persistenceEntry -> !persistenceEntry.getChildren().isEmpty()).map(PersistenceEntry::getName).collect(Collectors.toSet());
        this.f.clear();
        this.f.addAll(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAvailableThemes() {
        this.b();
        ArrayList<String> arrayList = new ArrayList<String>();
        ThemeEngine themeEngine = this;
        synchronized (themeEngine) {
            arrayList.addAll(this.f);
        }
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    private ByteArrayInputStream a(Throwable throwable) throws UnsupportedEncodingException {
        this.i = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#ErrorStartMarker { content: ''; }");
        stringBuilder.append("body{ display:flex; flex-direction: column; } body:before{ background-color:#faa; display:block; box-sizing:border-box; width:100%; white-space: pre-line; border-color: #ebb; color: #000; padding: 0.5em; z-index: 100000; content:\"");
        stringBuilder.append("A fatal error occured during compilation of the theme: ");
        stringBuilder.append(Objects.requireNonNullElse(throwable.getLocalizedMessage(), "").replace("\"", "'").replace("\r", "").replace("\n", "\\a").replace("\t", "    "));
        stringBuilder.append("\";}");
        stringBuilder.append("#ErrorEndMarker { content: ''; }");
        byte[] byArray = stringBuilder.toString().getBytes("UTF-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getCompiledTheme(String themeName) throws IOException {
        this.b();
        this.i = false;
        if (!this.f.contains(themeName)) {
            return null;
        }
        byte[] byArray = (byte[])this.j.get((Object)themeName);
        String string = themeName;
        synchronized (string) {
            if (byArray == null) {
                e.info((Object)("Compiling theme '" + themeName + "'"));
                PersistenceEntry persistenceEntry = Persistence.getInstance().resolve(THEMES_DIR).resolve(themeName);
                try {
                    long l = System.currentTimeMillis();
                    LessGenerator lessGenerator = new LessGenerator();
                    InputStream inputStream = lessGenerator.compileTheme(this.g, persistenceEntry, this.h);
                    FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
                    IOFunctions.copyData((InputStream)inputStream, (OutputStream)fastByteArrayOutputStream);
                    byArray = fastByteArrayOutputStream.toByteArray();
                    this.j.put((Object)themeName, (Object)byArray);
                    long l2 = System.currentTimeMillis();
                    e.info((Object)("Compiled theme '" + themeName + "' in " + (l2 - l) / 1000L + " seconds"));
                }
                catch (Throwable throwable) {
                    e.error("Compiling '" + themeName + "' failed.\n", throwable);
                    this.j.remove((Object)themeName);
                    return this.a(throwable);
                }
            }
        }
        return byArray == null ? null : new FastByteArrayInputStream(byArray);
    }

    public InputStream getCompiledThemeColors(Map<String, String> themeColors) throws IOException {
        return this.getCompiledThemeColors(themeColors, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getCompiledThemeColors(Map<String, String> themeColors, boolean forceRecompile, boolean pluginSnippet, boolean failOnError) throws IOException {
        this.i = false;
        String string = themeColors.toString();
        byte[] byArray = (byte[])this.j.get((Object)string);
        ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore(themeColors);
        try {
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                block15: {
                    if (byArray != null && !forceRecompile) break block15;
                    e.info((Object)("Compiling theme '" + String.valueOf(themeColors) + "'"));
                    try {
                        long l = System.currentTimeMillis();
                        LessGenerator lessGenerator = new LessGenerator();
                        InputStream inputStream = lessGenerator.compileThemeColors(this.g, themeColors, this.h, pluginSnippet);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        IOFunctions.copyData((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                        byArray = byteArrayOutputStream.toByteArray();
                        this.j.put((Object)string, (Object)byArray);
                        long l2 = System.currentTimeMillis();
                        e.info((Object)("Compiled theme '" + string + "' in " + (l2 - l) / 1000L + " seconds"));
                    }
                    catch (Throwable throwable) {
                        e.error((Object)("Compiling '" + string + "' failed."));
                        e.error(throwable);
                        this.j.remove((Object)string);
                        if (failOnError) {
                            throw new IOException(throwable);
                        }
                        ByteArrayInputStream byteArrayInputStream = this.a(throwable);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 7] lbl32 : MonitorExitStatement: MONITOREXIT : var8_8
                        if (semaphore != null) {
                            semaphore.close();
                        }
                        return byteArrayInputStream;
                    }
                }
            }
        }
        finally {
            if (semaphore != null) {
                try {
                    semaphore.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        return byArray == null ? null : new ByteArrayInputStream(byArray);
    }

    public HashMap<String, String> getDefaultColors() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                e.error((Object)"classLoader is null in public HashMap<String, String> getDefaultColors()");
                return null;
            }
            URL uRL = classLoader.getResource("com/inet/theme/server/less/default_theme.less");
            if (uRL == null) {
                e.error((Object)"URL of default theme resource is null");
                return null;
            }
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            String string = new String(LessGenerator.getDataFromInputStream(inputStream));
            String[] stringArray = string.split("\r?\n");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : stringArray) {
                if (string2.length() <= 0 || string2.indexOf(58) <= 0 || string2.indexOf(59) <= 0 || !string2.startsWith("@")) continue;
                if ((string2 = string2.trim()).endsWith(";")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (string2.endsWith("px") && string2.startsWith("@font-size:")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                int n = string2.indexOf(58);
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                hashMap.put(string3, string4);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            e.error(throwable);
            return null;
        }
    }

    public boolean isErrorOnLastCompile() {
        return this.i;
    }
}

