/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Expression;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.UrlUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;

class SelectorUtils {
    SelectorUtils() {
    }

    static String[] merge(@Nonnull String[] mainSelector, @Nonnull String[] base) {
        int count = 0;
        int[] counts = new int[base.length];
        for (int j = 0; j < base.length; ++j) {
            String selector = base[j];
            int andCount = 0;
            int idx = -1;
            while ((idx = selector.indexOf(38, idx + 1)) >= 0) {
                ++andCount;
            }
            counts[j] = (int)Math.pow(mainSelector.length, Math.max(1, andCount));
            count += counts[j];
        }
        String[] sel = new String[count];
        int t = 0;
        for (int j = 0; j < base.length; ++j) {
            String selector = base[j];
            int idx = selector.lastIndexOf(38);
            if (idx < 0) {
                for (String mainSel : mainSelector) {
                    sel[t++] = mainSel.isEmpty() ? selector : mainSel + ' ' + selector;
                }
                continue;
            }
            int off = t;
            count = counts[j];
            do {
                int a = t - off;
                int idx2 = idx;
                selector = base[j];
                do {
                    int x = a % mainSelector.length;
                    selector = selector.substring(0, idx2) + mainSelector[x] + selector.substring(idx2 + 1);
                    a /= mainSelector.length;
                } while ((idx2 = selector.lastIndexOf(38, idx2 - 1)) >= 0);
                sel[t++] = selector;
            } while (t - off < count);
        }
        return sel;
    }

    static String fastReplace(String str, String target, String replacement) {
        int targetLength = target.length();
        if (targetLength == 0) {
            return str;
        }
        int idx2 = str.indexOf(target);
        if (idx2 < 0) {
            return str;
        }
        StringBuilder buffer = new StringBuilder(targetLength > replacement.length() ? str.length() : str.length() * 2);
        int idx1 = 0;
        do {
            buffer.append(str, idx1, idx2);
            buffer.append(replacement);
        } while ((idx2 = str.indexOf(target, idx1 = idx2 + targetLength)) > 0);
        buffer.append(str, idx1, str.length());
        return buffer.toString();
    }

    static void appendToWithPlaceHolder(CssFormatter formatter, String str, int i, boolean isStringValue, LessObject caller) {
        int length;
        if (formatter.inlineMode()) {
            str = UrlUtils.removeQuote(str);
        }
        boolean isJavaScript = (length = str.length()) > 0 && str.charAt(0) == '`';
        int appendIdx = 0;
        char quote = '\u0000';
        while (i < length) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (quote == '\u0000') {
                        quote = ch;
                        break;
                    }
                    quote = '\u0000';
                    break;
                }
                case '@': {
                    String name;
                    int nextIdx;
                    if (str.length() > i + 1 && str.charAt(i + 1) == '{') {
                        nextIdx = str.indexOf(125, i);
                        name = '@' + str.substring(i + 2, nextIdx);
                    } else {
                        if (quote != '\u0000' || isStringValue) break;
                        block8: for (nextIdx = i + 1; nextIdx < str.length(); ++nextIdx) {
                            ch = str.charAt(nextIdx);
                            switch (ch) {
                                case ' ': 
                                case '\"': 
                                case '\'': 
                                case ')': 
                                case ',': {
                                    break block8;
                                }
                                default: {
                                    continue block8;
                                }
                            }
                        }
                        name = str.substring(i, nextIdx);
                    }
                    formatter.append(str.substring(appendIdx, i));
                    appendIdx = ++nextIdx;
                    Expression exp = formatter.getVariable(name);
                    if (exp == null) {
                        throw caller.createException("Undefined Variable: " + name + " in " + str);
                    }
                    if (isJavaScript) {
                        boolean isList;
                        boolean bl = isList = exp.getDataType(formatter) == 7;
                        if (isList) {
                            formatter.append('[');
                            ArrayList<Expression> values = exp.listValue(formatter).getOperands();
                            for (int j = 0; j < values.size(); ++j) {
                                if (j > 0) {
                                    formatter.append(", ");
                                }
                                ((Expression)values.get(j)).appendTo(formatter);
                            }
                            formatter.append(']');
                        } else {
                            exp.appendTo(formatter);
                        }
                    } else if (i == 0 || str.charAt(i - 1) != '=') {
                        formatter.setInlineMode(true);
                        exp.appendTo(formatter);
                        formatter.setInlineMode(false);
                    } else {
                        exp.appendTo(formatter);
                    }
                    i = nextIdx - 1;
                }
            }
            ++i;
        }
        formatter.append(str.substring(appendIdx));
    }

    static String replacePlaceHolder(CssFormatter formatter, String str, LessObject caller) {
        int pos;
        int n = pos = str.startsWith("@{") ? 0 : str.indexOf("@", 1);
        if (pos >= 0) {
            formatter.addOutput();
            SelectorUtils.appendToWithPlaceHolder(formatter, str, pos, false, caller);
            return formatter.releaseOutput();
        }
        return str;
    }

    static String[] split(String selectors) {
        ArrayList<String> result = null;
        int length = selectors.length();
        boolean quote = false;
        int off = 0;
        block4: for (int i = 0; i < length; ++i) {
            char ch = selectors.charAt(i);
            switch (ch) {
                case ',': {
                    if (result == null) {
                        result = new ArrayList<String>();
                    }
                    result.add(selectors.substring(off, i).trim());
                    off = i + 1;
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    while (++i < length && selectors.charAt(i) != ch) {
                    }
                    continue block4;
                }
            }
        }
        if (result == null) {
            return new String[]{selectors.trim()};
        }
        result.add(selectors.substring(off, length).trim());
        return result.toArray(new String[result.size()]);
    }
}

