/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.LessFilePosition;
import java.util.ArrayList;
import java.util.List;

public class LessException
extends RuntimeException {
    private List<LessFilePosition> positions = new ArrayList<LessFilePosition>();

    public LessException(String message) {
        super(message);
    }

    public LessException(Throwable cause) {
        super(cause);
    }

    public LessException(String message, Throwable cause) {
        super(message, cause);
    }

    void addPosition(String filename, int line, int column) {
        LessFilePosition pos = new LessFilePosition(filename, line, column);
        if (!this.positions.contains(pos)) {
            this.positions.add(pos);
        }
    }

    public List<LessFilePosition> getPositions() {
        return new ArrayList<LessFilePosition>(this.positions);
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder(super.getMessage());
        for (LessFilePosition pos : this.positions) {
            builder.append("\n\t on line ").append(pos.getLine()).append(", column ").append(pos.getColumn());
            if (pos.getFilename() == null) continue;
            builder.append(", file ").append(pos.getFilename());
        }
        return builder.toString();
    }
}

