/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.LessException;
import javax.annotation.Nonnull;

class LessObject {
    String filename;
    int line;
    int column;

    LessObject(String filename) {
        this.filename = filename;
    }

    LessObject(LessObject obj) {
        this.filename = obj.filename;
        this.line = obj.line;
        this.column = obj.column;
    }

    @Nonnull
    LessException createException(String msg) {
        LessException lessEx = new LessException(msg);
        lessEx.addPosition(this.filename, this.line, this.column);
        return lessEx;
    }

    @Nonnull
    LessException createException(String msg, Throwable cause) {
        LessException lessEx = new LessException(msg, cause);
        lessEx.addPosition(this.filename, this.line, this.column);
        return lessEx;
    }

    @Nonnull
    LessException createException(Throwable cause) {
        LessException lessEx = cause.getClass() == LessException.class ? (LessException)cause : new LessException(cause);
        lessEx.addPosition(this.filename, this.line, this.column);
        return lessEx;
    }

    String getFileName() {
        return this.filename;
    }
}

