/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.ColorUtils;
import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Expression;
import com.inet.lib.less.LessException;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.ValueExpression;
import java.util.ArrayList;
import java.util.HashMap;

class Operation
extends Expression {
    private final ArrayList<Expression> operands = new ArrayList();
    private final char operator;
    private int type;
    private static final HashMap<String, HashMap<String, Double>> UNIT_CONVERSIONS = new HashMap();

    private static void putConvertion(HashMap<String, Double> group, String unit, double factor) {
        UNIT_CONVERSIONS.put(unit, group);
        group.put(unit, factor);
    }

    Operation(LessObject obj, Expression left, char operator) {
        this(obj, operator);
        if (left != null) {
            this.operands.add(left);
        }
    }

    Operation(LessObject obj, char operator) {
        super(obj, String.valueOf(operator));
        this.operator = operator;
    }

    Operation(LessObject obj) {
        super(obj, ",");
        this.operator = (char)44;
    }

    char getOperator() {
        return this.operator;
    }

    ArrayList<Expression> getOperands() {
        return this.operands;
    }

    void addOperand(Expression right) {
        this.operands.add(right);
    }

    void addLeftOperand(Expression left) {
        this.operands.add(0, left);
    }

    @Override
    public int getDataType(CssFormatter formatter) {
        if (this.type == 0) {
            switch (this.operator) {
                case ' ': 
                case ',': {
                    this.type = 7;
                    break;
                }
                case '&': 
                case '<': 
                case '=': 
                case '>': 
                case '|': 
                case '\u2264': 
                case '\u2265': {
                    this.type = 1;
                    break;
                }
                default: {
                    this.type = this.maxOperadType(formatter);
                }
            }
        }
        return this.type;
    }

    void setDataType(int type) {
        this.type = type;
    }

    private int maxOperadType(CssFormatter formatter) {
        int dataType = this.operands.get(0).getDataType(formatter);
        for (int i = 1; i < this.operands.size(); ++i) {
            dataType = Math.max(dataType, this.operands.get(i).getDataType(formatter));
        }
        return dataType;
    }

    @Override
    public void appendTo(CssFormatter formatter) {
        switch (this.getDataType(formatter)) {
            case 1: {
                switch (this.operator) {
                    case '=': {
                        for (int i = 0; i < this.operands.size(); ++i) {
                            if (i > 0) {
                                formatter.append(this.operator);
                            }
                            this.operands.get(i).appendTo(formatter);
                        }
                        return;
                    }
                }
                break;
            }
            case 6: 
            case 7: {
                switch (this.operator) {
                    case ' ': {
                        for (int i = 0; i < this.operands.size(); ++i) {
                            if (i > 0) {
                                formatter.append(this.operator);
                            }
                            this.operands.get(i).appendTo(formatter);
                        }
                        return;
                    }
                    case ',': {
                        for (int i = 0; i < this.operands.size(); ++i) {
                            if (i > 0) {
                                formatter.append(this.operator).space();
                            }
                            this.operands.get(i).appendTo(formatter);
                        }
                        return;
                    }
                    case '+': {
                        for (int i = 0; i < this.operands.size(); ++i) {
                            this.operands.get(i).appendTo(formatter);
                        }
                        return;
                    }
                    case '/': {
                        for (int i = 0; i < this.operands.size(); ++i) {
                            if (i > 0) {
                                formatter.append(this.operator);
                            }
                            this.operands.get(i).appendTo(formatter);
                        }
                        return;
                    }
                    case '~': {
                        String str = this.operands.get(0).stringValue(formatter);
                        StringBuilder builder = new StringBuilder();
                        char quote = '\u0000';
                        block23: for (int i = 0; i < str.length(); ++i) {
                            char ch = str.charAt(i);
                            switch (ch) {
                                case '\"': 
                                case '\'': {
                                    if (quote == '\u0000') {
                                        quote = ch;
                                        continue block23;
                                    }
                                    if (quote == ch) {
                                        quote = '\u0000';
                                        continue block23;
                                    }
                                    builder.append(ch);
                                    continue block23;
                                }
                                case '\\': {
                                    builder.append(str.charAt(++i));
                                    continue block23;
                                }
                                default: {
                                    builder.append(ch);
                                }
                            }
                        }
                        formatter.append(builder.toString());
                        return;
                    }
                }
                StringBuilder builder = new StringBuilder("Not supported Operation '").append(this.operator).append("' for '");
                for (int i = 0; i < this.operands.size(); ++i) {
                    builder.append(this.operands.get(i));
                    if (i < this.operands.size() - 1) {
                        builder.append("' and '");
                        continue;
                    }
                    builder.append("'");
                }
                throw this.createException(builder.toString());
            }
        }
        super.appendTo(formatter);
    }

    static double unitFactor(String leftUnit, String rightUnit, boolean fail) {
        HashMap<String, Double> rightGroup;
        if (leftUnit.length() == 0 || rightUnit.length() == 0 || leftUnit.equals(rightUnit)) {
            return 1.0;
        }
        HashMap<String, Double> leftGroup = UNIT_CONVERSIONS.get(leftUnit);
        if (leftGroup != null && leftGroup == (rightGroup = UNIT_CONVERSIONS.get(rightUnit))) {
            return leftGroup.get(leftUnit) / leftGroup.get(rightUnit);
        }
        if (fail) {
            throw new LessException("Incompatible types");
        }
        return 1.0;
    }

    @Override
    public double doubleValue(CssFormatter formatter) {
        Expression leftOp = this.operands.get(0);
        int type = leftOp.getDataType(formatter);
        double value = leftOp.doubleValue(formatter);
        String unit = leftOp.unit(formatter);
        for (int i = 1; i < this.operands.size(); ++i) {
            Expression rightOp = this.operands.get(i);
            int rightType = rightOp.getDataType(formatter);
            double right = rightOp.doubleValue(formatter);
            switch (this.operator) {
                case '+': 
                case '-': {
                    right /= Operation.unitFactor(unit, rightOp.unit(formatter), false);
                }
            }
            if (type == 5) {
                if (rightType == 5) {
                    value = this.doubleValue2Colors(value, right);
                    continue;
                }
                value = this.doubleValueLeftColor(value, right);
                continue;
            }
            value = rightType == 5 ? this.doubleValueRightColor(value, right) : this.doubleValue(value, right);
        }
        return value;
    }

    private double doubleValue(double left, double right) {
        switch (this.operator) {
            case '+': {
                return left + right;
            }
            case '-': {
                return left - right;
            }
            case '*': {
                return left * right;
            }
            case '/': {
                return left / right;
            }
        }
        throw this.createException("Not supported Oprator '" + this.operator + "' for Expression '" + this.toString() + '\'');
    }

    private double doubleValueLeftColor(double color, double right) {
        return ColorUtils.rgba(this.doubleValue(ColorUtils.red(color), right), this.doubleValue(ColorUtils.green(color), right), this.doubleValue(ColorUtils.blue(color), right), 1.0);
    }

    private double doubleValueRightColor(double left, double color) {
        return ColorUtils.rgba(this.doubleValue(left, ColorUtils.red(color)), this.doubleValue(left, ColorUtils.green(color)), this.doubleValue(left, ColorUtils.blue(color)), 1.0);
    }

    private double doubleValue2Colors(double left, double right) {
        return ColorUtils.rgba(this.doubleValue(ColorUtils.red(left), ColorUtils.red(right)), this.doubleValue(ColorUtils.green(left), ColorUtils.green(right)), this.doubleValue(ColorUtils.blue(left), ColorUtils.blue(right)), 1.0);
    }

    @Override
    public boolean booleanValue(CssFormatter formatter) {
        Expression leftOp = this.operands.get(0);
        block1 : switch (this.operator) {
            case '&': 
            case '|': {
                boolean value = leftOp.booleanValue(formatter);
                block42: for (int i = 1; i < this.operands.size(); ++i) {
                    boolean right = this.operands.get(i).booleanValue(formatter);
                    switch (this.operator) {
                        case '&': {
                            value &= right;
                            continue block42;
                        }
                        case '|': {
                            value |= right;
                        }
                    }
                }
                return value;
            }
            case '!': {
                return !leftOp.booleanValue(formatter);
            }
            case ' ': {
                Expression op;
                if (leftOp instanceof ValueExpression && "not".equals(leftOp.toString())) {
                    return !this.operands.get(1).booleanValue(formatter);
                }
                if (this.operands.size() != 3 || !((op = this.operands.get(1)) instanceof ValueExpression)) break;
                Expression rightOp = this.operands.get(2);
                switch (op.toString()) {
                    case "and": {
                        return leftOp.booleanValue(formatter) & rightOp.booleanValue(formatter);
                    }
                    case "or": {
                        return leftOp.booleanValue(formatter) | rightOp.booleanValue(formatter);
                    }
                }
                break;
            }
            case '<': 
            case '=': 
            case '>': 
            case '\u2264': 
            case '\u2265': {
                int type = this.maxOperadType(formatter);
                switch (type) {
                    case 6: 
                    case 7: {
                        String left = this.normlizeQuotes(leftOp.stringValue(formatter));
                        String right = this.normlizeQuotes(this.operands.get(1).stringValue(formatter));
                        switch (this.operator) {
                            case '>': {
                                return left.compareTo(right) > 0;
                            }
                            case '<': {
                                return left.compareTo(right) < 0;
                            }
                            case '=': {
                                return left.compareTo(right) == 0;
                            }
                            case '\u2265': {
                                return left.compareTo(right) >= 0;
                            }
                            case '\u2264': {
                                return left.compareTo(right) <= 0;
                            }
                        }
                        break block1;
                    }
                    case 4: 
                    case 5: {
                        long left = Double.doubleToRawLongBits(leftOp.doubleValue(formatter));
                        long right = Double.doubleToRawLongBits(this.operands.get(1).doubleValue(formatter));
                        switch (this.operator) {
                            case '<': 
                            case '>': {
                                return false;
                            }
                            case '=': 
                            case '\u2264': 
                            case '\u2265': {
                                return left == right;
                            }
                        }
                    }
                }
                double left = leftOp.doubleValue(formatter);
                Expression rightOp = this.operands.get(1);
                double right = rightOp.doubleValue(formatter);
                try {
                    right /= Operation.unitFactor(leftOp.unit(formatter), rightOp.unit(formatter), true);
                    switch (this.operator) {
                        case '>': {
                            return left > right;
                        }
                        case '<': {
                            return left < right;
                        }
                        case '=': {
                            return left == right;
                        }
                        case '\u2265': {
                            return left >= right;
                        }
                        case '\u2264': {
                            return left <= right;
                        }
                    }
                    break;
                }
                catch (LessException ex) {
                    return false;
                }
            }
        }
        throw this.createException("Not supported Oprator '" + this.operator + "' for Expression '" + this.toString() + '\'');
    }

    private String normlizeQuotes(String str) {
        if (str.length() > 1 && str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'') {
            return '\"' + str.substring(1, str.length() - 1) + '\"';
        }
        return str;
    }

    private ArrayList<Unit> unit(CssFormatter formatter, ArrayList<Unit> list) {
        for (int i = 0; i < this.operands.size(); ++i) {
            Expression exp = this.operands.get(i);
            if (exp.getClass() == Operation.class) {
                Operation op = (Operation)exp;
                switch (op.operator) {
                    case '*': 
                    case '/': {
                        list = op.unit(formatter, list);
                        break;
                    }
                }
                continue;
            }
            String unitStr = exp.unit(formatter);
            if (unitStr.isEmpty()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            Unit unit = null;
            for (int j = 0; j < list.size(); ++j) {
                Unit unitLoop = list.get(j);
                if (!unitLoop.unit.equals(unitStr)) continue;
                unit = unitLoop;
                break;
            }
            if (unit == null) {
                unit = new Unit(unitStr);
                list.add(unit);
            }
            if (i == 0 || this.operator == '*') {
                unit.numerator++;
                continue;
            }
            unit.denominator++;
        }
        return list;
    }

    @Override
    public String unit(CssFormatter formatter) {
        switch (this.operator) {
            case '*': 
            case '/': {
                ArrayList<Unit> list = this.unit(formatter, null);
                if (list != null) {
                    Unit unit = list.get(0);
                    int useCount = unit.useCount();
                    for (int i = 1; i < list.size(); ++i) {
                        if (list.get(i).useCount() <= useCount) continue;
                        unit = list.get(i);
                    }
                    return unit.unit;
                }
                return "";
            }
        }
        for (int i = 0; i < this.operands.size(); ++i) {
            String unit = this.operands.get(i).unit(formatter);
            if (unit.isEmpty()) continue;
            return unit;
        }
        return "";
    }

    @Override
    public Operation listValue(CssFormatter formatter) {
        switch (this.operator) {
            case ' ': 
            case ',': {
                return this;
            }
        }
        return super.listValue(formatter);
    }

    @Override
    boolean isImportant() {
        return super.isImportant() || this.operands.get(this.operands.size() - 1).isImportant();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.operands.size(); ++i) {
            if (i > 0) {
                builder.append(' ').append(this.operator).append(' ');
            }
            builder.append(this.operands.get(i));
        }
        return builder.toString();
    }

    static int level(char operator) {
        switch (operator) {
            case ',': {
                return 1;
            }
            case ' ': {
                return 2;
            }
            case ':': {
                return 3;
            }
            case '<': 
            case '=': 
            case '>': {
                return 4;
            }
            case '+': 
            case '-': {
                return 5;
            }
            case '*': 
            case '/': {
                return 6;
            }
            case '~': {
                return 7;
            }
        }
        return 0;
    }

    static {
        HashMap<String, Double> length = new HashMap<String, Double>();
        Operation.putConvertion(length, "m", 1.0);
        Operation.putConvertion(length, "cm", 0.01);
        Operation.putConvertion(length, "mm", 0.001);
        Operation.putConvertion(length, "in", 0.0254);
        Operation.putConvertion(length, "px", 2.645833333333333E-4);
        Operation.putConvertion(length, "pt", 3.5277777777777776E-4);
        Operation.putConvertion(length, "pc", 0.004233333333333333);
        HashMap<String, Double> duration = new HashMap<String, Double>();
        Operation.putConvertion(duration, "s", 1.0);
        Operation.putConvertion(duration, "ms", 0.001);
        HashMap<String, Double> angle = new HashMap<String, Double>();
        Operation.putConvertion(angle, "rad", 0.15915494309189535);
        Operation.putConvertion(angle, "deg", 0.002777777777777778);
        Operation.putConvertion(angle, "grad", 0.0025);
        Operation.putConvertion(angle, "turn", 1.0);
    }

    private static class Unit {
        private int numerator;
        private int denominator;
        private final String unit;

        Unit(String unit) {
            this.unit = unit;
        }

        int useCount() {
            return this.numerator - this.denominator;
        }
    }
}

