/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.Comment;
import com.inet.lib.less.CssAtRule;
import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.DefaultedHashMap;
import com.inet.lib.less.Expression;
import com.inet.lib.less.Formattable;
import com.inet.lib.less.FormattableContainer;
import com.inet.lib.less.FunctionExpression;
import com.inet.lib.less.HashMultimap;
import com.inet.lib.less.JavaScriptExpression;
import com.inet.lib.less.LazyImport;
import com.inet.lib.less.LessException;
import com.inet.lib.less.LessExtend;
import com.inet.lib.less.LessLookAheadReader;
import com.inet.lib.less.Mixin;
import com.inet.lib.less.Operation;
import com.inet.lib.less.ReaderFactory;
import com.inet.lib.less.ReferenceInfo;
import com.inet.lib.less.Rule;
import com.inet.lib.less.RuleProperty;
import com.inet.lib.less.ValueExpression;
import com.inet.lib.less.VariableExpression;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;

class LessParser
implements FormattableContainer {
    private boolean strictMath;
    private int nesting;
    private URL baseURL;
    private ReaderFactory readerFactory;
    private URL relativeURL;
    private LessLookAheadReader reader;
    private HashMap<String, Expression> variables = new HashMap();
    private List<Formattable> rules = new ArrayList<Formattable>();
    private int rulesIdx;
    private HashMultimap<String, Rule> mixins = new HashMultimap();
    private final StringBuilder cachesBuilder = new StringBuilder();
    private ArrayDeque<Rule> ruleStack = new ArrayDeque();
    private HashSet<URL> imports = new HashSet();
    private List<LazyImport> lazyImports;

    LessParser() {
    }

    List<Formattable> getRules() {
        return this.rules;
    }

    @Override
    public HashMap<String, Expression> getVariables() {
        return this.variables;
    }

    @Override
    public HashMultimap<String, Rule> getMixins() {
        return this.mixins;
    }

    void parse(URL baseURL, Reader input, ReaderFactory readerFactory) throws MalformedURLException, LessException {
        this.baseURL = baseURL;
        this.readerFactory = readerFactory;
        this.relativeURL = new URL("file", null, "");
        this.reader = new LessLookAheadReader(input, null, false, false);
        this.parse(this);
    }

    void parseLazy(CssFormatter formatter) {
        if (this.lazyImports != null) {
            HashMap<String, Expression> vars = this.variables;
            formatter.addVariables(vars);
            for (int i = 0; i < this.lazyImports.size(); ++i) {
                LazyImport lazyImport = this.lazyImports.get(i);
                String filename = lazyImport.stringValue(formatter);
                this.baseURL = lazyImport.getBaseUrl();
                this.variables = lazyImport.getVariables();
                this.rulesIdx = lazyImport.lastRuleBefore() == null ? 0 : this.rules.indexOf(lazyImport.lastRuleBefore()) + 1;
                this.importFile(this, filename);
            }
            formatter.removeVariables(vars);
            this.variables = vars;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(FormattableContainer currentRule) {
        try {
            block8: while (true) {
                int ch = this.reader.nextBlockMarker();
                switch (ch) {
                    case -1: {
                        return;
                    }
                    case 59: {
                        this.parseSemicolon(currentRule);
                        continue block8;
                    }
                    case 123: {
                        this.parseBlock(currentRule);
                        continue block8;
                    }
                }
                break;
            }
            throw this.createException("Unrecognized input: '" + this.reader.getLookAhead() + "'");
        }
        catch (LessException ex) {
            ex.addPosition(this.reader.getFileName(), this.reader.getLine(), this.reader.getColumn());
            throw ex;
        }
        catch (RuntimeException ex) {
            LessException lessEx = new LessException(ex);
            lessEx.addPosition(this.reader.getFileName(), this.reader.getLine(), this.reader.getColumn());
            throw lessEx;
        }
    }

    private void parseSemicolon(FormattableContainer currentRule) {
        String selector = null;
        Operation params = null;
        StringBuilder builder = this.cachesBuilder;
        block13: while (true) {
            char ch;
            try {
                ch = this.read();
            }
            catch (Exception e) {
                ch = ';';
            }
            switch (ch) {
                case ':': {
                    if (LessParser.isMixin(builder)) {
                        builder.append(ch);
                        continue block13;
                    }
                    String name = LessParser.trim(builder);
                    this.strictMath = "font".equals(name);
                    Expression value = this.parseExpression('\u0000');
                    this.strictMath = false;
                    ch = this.read();
                    switch (ch) {
                        case '}': {
                            break;
                        }
                        case ';': {
                            break;
                        }
                        default: {
                            throw this.createException("Unrecognized input: '" + ch + "'");
                        }
                    }
                    currentRule.add(new RuleProperty(name, value));
                    return;
                }
                case '@': {
                    ch = this.read();
                    if (ch == '{') {
                        builder.append('@');
                        builder.append(ch);
                        do {
                            ch = this.read();
                            builder.append(ch);
                        } while (ch != 125);
                        break;
                    }
                    this.back(ch);
                    this.throwUnrecognizedInputIfAny(builder, ch);
                    this.variable(currentRule.getVariables(), currentRule);
                    return;
                }
                case '/': {
                    if (this.comment(LessParser.isWhitespace(builder) ? currentRule : null)) continue block13;
                    builder.append(ch);
                    break;
                }
                case '(': {
                    if (!this.reader.nextIsMixinParam(false) || builder.indexOf(":extend") >= 0) {
                        builder.append(ch);
                        break;
                    }
                    selector = LessParser.trim(builder);
                    params = this.parseParameterList();
                    break;
                }
                case ';': 
                case '}': {
                    String sel = LessParser.trim(builder);
                    if (!sel.isEmpty()) {
                        selector = selector == null ? sel : selector + ' ' + sel;
                    }
                    if (selector != null) {
                        if (selector.contains(":extend(")) {
                            LessExtend.addLessExtendsTo(currentRule, this.reader, selector);
                        } else {
                            Mixin mixin = new Mixin(this.reader, selector, params, currentRule.getMixins());
                            currentRule.add(mixin);
                        }
                    }
                    return;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
    }

    void parseBlock(FormattableContainer currentRule) {
        Operation expr = null;
        String name = null;
        Expression guard = null;
        StringBuilder builder = this.cachesBuilder;
        boolean wasWhite = false;
        block23: while (true) {
            char ch = this.reader.read();
            switch (ch) {
                case '{': {
                    String[] selectors;
                    String selector;
                    if (name == null) {
                        selector = LessParser.trim(builder);
                    } else {
                        selector = name;
                        name = null;
                        this.throwUnrecognizedInputIfAny(builder, ch);
                    }
                    if (selector.endsWith("@")) {
                        builder.append(selector);
                        builder.append(ch);
                        continue block23;
                    }
                    if (selector.contains(":extend(")) {
                        selector = LessExtend.addLessExtendsTo(currentRule, this.reader, selector);
                    }
                    Rule rule = this.rule(currentRule, selector, expr, guard);
                    currentRule.add(rule);
                    expr = null;
                    guard = null;
                    for (String sel : selectors = rule.getSelectors()) {
                        currentRule.getMixins().add(sel.trim(), rule);
                    }
                    return;
                }
                case '/': {
                    if (!this.comment(LessParser.isWhitespace(builder) ? currentRule : null)) {
                        builder.append(ch);
                    }
                    wasWhite = false;
                    continue block23;
                }
                case '\"': 
                case '\'': {
                    this.readQuote(ch, builder);
                    wasWhite = false;
                    continue block23;
                }
                case '(': {
                    char operator;
                    String cmd;
                    if (name == null) {
                        int idx = builder.lastIndexOf(" when");
                        if ((idx < 0 || idx + 5 != builder.length() && builder.indexOf(" when ") < 0) && (LessParser.isSelector(builder) || !this.reader.nextIsMixinParam(true))) {
                            builder.append(ch);
                            continue block23;
                        }
                        name = LessParser.trim(builder);
                        if (idx < 0) {
                            expr = this.parseParameterList();
                            continue block23;
                        }
                        cmd = name.substring(idx + 1);
                        name = name.substring(0, idx);
                    } else {
                        cmd = LessParser.trim(builder);
                    }
                    boolean isNot = false;
                    switch (cmd) {
                        case "when not": {
                            isNot = true;
                        }
                        case "when": {
                            operator = '\u0000';
                            break;
                        }
                        case "and not": {
                            isNot = true;
                        }
                        case "and": {
                            operator = '&';
                            break;
                        }
                        case ",not": 
                        case ", not": {
                            isNot = true;
                        }
                        case ",": {
                            operator = '|';
                            break;
                        }
                        default: {
                            throw this.createException("Unrecognized input: '" + cmd + "'");
                        }
                    }
                    Expression right = this.parseExpression('\u0000');
                    ch = this.read();
                    if (ch != ')') {
                        throw this.createException("Unrecognized input: '" + ch + "'");
                    }
                    if (isNot) {
                        right = new Operation(this.reader, right, '!');
                    }
                    guard = operator == '\u0000' ? right : this.concat(guard, operator, right);
                    continue block23;
                }
            }
            boolean isWhite = Character.isWhitespace(ch);
            if (isWhite) {
                if (builder.length() == 0 || wasWhite) continue;
                builder.append(' ');
                wasWhite = true;
                continue;
            }
            builder.append(ch);
            wasWhite = false;
        }
    }

    private void variable(HashMap<String, Expression> variables, FormattableContainer currentRule) {
        char ch;
        StringBuilder builder = this.cachesBuilder;
        builder.append('@');
        block4: while (true) {
            ch = this.read();
            switch (ch) {
                case ':': {
                    if (LessParser.isVariableName(builder)) break block4;
                    builder.append(ch);
                    continue block4;
                }
                case ';': {
                    String name = LessParser.trim(builder);
                    if (name.startsWith("@import ")) {
                        this.importFile(currentRule, name.substring(8).trim());
                        return;
                    }
                    if (name.endsWith("()")) {
                        currentRule.add(new VariableExpression(this.reader, name.substring(0, name.length() - 2)));
                    } else {
                        currentRule.add(new CssAtRule(this.reader, name + ';', true));
                    }
                    return;
                }
                default: {
                    builder.append(ch);
                    continue block4;
                }
            }
            break;
        }
        String name = LessParser.trim(builder);
        Expression value = this.parseExpression('\u0000');
        ch = this.read();
        if (ch == '}') {
            this.back(ch);
        } else if (ch != ';') {
            throw this.createException("Unrecognized input: '" + ch + "'");
        }
        variables.put(name, value);
    }

    private void importFile(FormattableContainer currentRule, String name) {
        int endIdx;
        String filename = name.trim();
        boolean isReference = this.reader.isReference();
        boolean isCss = false;
        boolean isLess = false;
        boolean isMultiple = this.reader.isMultiple();
        boolean isInline = false;
        boolean isOptional = false;
        if (filename.startsWith("(") && (endIdx = filename.indexOf(41, 1)) > 0) {
            StringTokenizer tokenizer = new StringTokenizer(filename.substring(1, endIdx), ",");
            filename = name.substring(endIdx + 1).trim();
            block35: while (tokenizer.hasMoreTokens()) {
                String keywordStr;
                switch (keywordStr = tokenizer.nextToken().trim()) {
                    case "inline": {
                        isInline = true;
                        continue block35;
                    }
                    case "optional": {
                        isOptional = true;
                        continue block35;
                    }
                    case "once": {
                        isMultiple = false;
                        continue block35;
                    }
                    case "multiple": {
                        isMultiple = true;
                        continue block35;
                    }
                    case "less": {
                        isLess = true;
                        isCss = false;
                        continue block35;
                    }
                    case "css": {
                        isCss = true;
                        isLess = false;
                        continue block35;
                    }
                    case "reference": {
                        isReference = true;
                        continue block35;
                    }
                }
                throw new LessException("Unknown @import keyword: " + keywordStr);
            }
        }
        Object[] old = new Object[]{this.reader, this.baseURL, this.relativeURL};
        try {
            boolean isURL;
            int i;
            if (filename.startsWith("url(")) {
                i = 4;
                isURL = true;
            } else {
                i = 0;
                isURL = false;
            }
            StringBuilder builder = this.cachesBuilder;
            String media = null;
            char quote = '\u0000';
            block36: while (i < filename.length()) {
                char ch = filename.charAt(i);
                switch (ch) {
                    case '\"': 
                    case '\'': {
                        if (quote == '\u0000') {
                            quote = ch;
                            break;
                        }
                        quote = '\u0000';
                        if (isURL) break;
                        break block36;
                    }
                    case '\\': {
                        builder.append(filename.charAt(++i));
                        break;
                    }
                    case ')': {
                        if (quote == '\u0000') break block36;
                    }
                    default: {
                        builder.append(ch);
                    }
                }
                ++i;
            }
            if (i < filename.length() - 1) {
                media = filename.substring(i + 1).trim();
                Rule rule = new Rule(this.reader, currentRule, "@media " + media, null, null);
                currentRule.add(rule);
                currentRule = rule;
            }
            String origFilename = filename;
            filename = LessParser.trim(builder);
            if (filename.contains("@{")) {
                if (currentRule != this) {
                    currentRule.add(new CssAtRule(this.reader, "@import " + name + ';', true));
                    return;
                }
                DefaultedHashMap<String, Expression> importVariables = new DefaultedHashMap<String, Expression>((Map<String, Expression>)this.variables);
                this.variables = new DefaultedHashMap<String, Expression>((Map<String, Expression>)importVariables);
                Formattable lastRuleBefore = this.rules.size() == 0 ? null : this.rules.get(this.rules.size() - 1);
                LazyImport lazy = new LazyImport(this.reader, this.baseURL, name, importVariables, lastRuleBefore);
                if (this.lazyImports == null) {
                    this.lazyImports = new ArrayList<LazyImport>();
                }
                this.lazyImports.add(lazy);
                return;
            }
            if (!isLess && !isInline && (isCss || filename.endsWith("css") || filename.contains("css?"))) {
                currentRule.add(new CssAtRule(this.reader, "@import " + origFilename + ';', true));
                return;
            }
            URL uRL = this.baseURL = this.baseURL == null ? new URL(filename) : new URL(this.baseURL, filename);
            if (!isLess && !isInline && this.baseURL.getPath().endsWith("css")) {
                currentRule.add(new CssAtRule(this.reader, "@import " + origFilename + ';', true));
                return;
            }
            if ("file".equals(this.baseURL.getProtocol()) && filename.lastIndexOf(46) <= filename.lastIndexOf(47)) {
                filename = filename + ".less";
                this.baseURL = (URL)old[1];
                this.baseURL = this.baseURL == null ? new URL(filename) : new URL(this.baseURL, filename);
            }
            this.relativeURL = new URL(this.relativeURL, filename);
            if (this.imports.add(this.baseURL) || isMultiple) {
                if (isReference != this.reader.isReference()) {
                    this.add(new ReferenceInfo(isReference));
                }
                Reader importReader = this.readerFactory.create(this.baseURL);
                if (isInline) {
                    Scanner scanner = new Scanner(importReader).useDelimiter("\\A");
                    if (scanner.hasNext()) {
                        currentRule.add(new CssAtRule(this.reader, scanner.next(), false));
                    }
                } else {
                    this.reader = new LessLookAheadReader(importReader, filename, isReference, isMultiple);
                    this.parse(currentRule);
                    this.reader.close();
                }
            }
        }
        catch (LessException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (!isOptional) {
                throw new LessException(ex);
            }
        }
        catch (Exception ex) {
            throw new LessException(ex);
        }
        finally {
            this.reader = (LessLookAheadReader)old[0];
            this.baseURL = (URL)old[1];
            this.relativeURL = (URL)old[2];
            if (isReference != this.reader.isReference()) {
                this.add(new ReferenceInfo(this.reader.isReference()));
            }
        }
    }

    @Nonnull
    private Rule rule(FormattableContainer parent, String selector, Operation params, Expression guard) {
        Rule rule = new Rule(this.reader, parent, selector, params, guard);
        this.parseRule(rule);
        return rule;
    }

    private void parseRule(Rule rule) {
        this.ruleStack.add(rule);
        block6: while (true) {
            int ch = this.reader.nextBlockMarker();
            switch (ch) {
                case -1: {
                    throw this.createException("Unexpected end of Less data");
                }
                case 59: {
                    this.parseSemicolon(rule);
                    continue block6;
                }
                case 123: {
                    this.parseBlock(rule);
                    continue block6;
                }
                case 125: {
                    this.parseSemicolon(rule);
                    this.ruleStack.removeLast();
                    return;
                }
            }
            break;
        }
        throw this.createException("Unrecognized input: '" + this.reader.getLookAhead() + "'");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Expression parseExpression(char leftOperator) {
        StringBuilder builder = this.cachesBuilder;
        Expression left = null;
        boolean wasWhite = false;
        block44: while (true) {
            char ch = this.read();
            switch (ch) {
                case '{': {
                    if (builder.length() > 0) {
                        left = this.concat(left, ' ', this.buildExpression(LessParser.trim(builder)));
                    }
                    Rule rule = this.rule(this, "", null, null);
                    left = this.concat(left, ' ', new ValueExpression(rule));
                    continue block44;
                }
                case '-': {
                    if (builder.length() == 0 && left == null) {
                        builder.append(ch);
                        wasWhite = false;
                        continue block44;
                    }
                    char ch2 = this.read();
                    if (Character.isWhitespace(ch2)) {
                        this.back(ch2);
                    } else {
                        if (wasWhite) {
                            if (Operation.level(leftOperator) >= Operation.level(' ')) {
                                this.back(ch2);
                                this.back(ch);
                                this.back(' ');
                                if (builder.length() <= 0) return left;
                                return this.concat(left, ' ', this.buildExpression(LessParser.trim(builder)));
                            }
                            if (builder.length() > 0) {
                                left = this.concat(left, ' ', this.buildExpression(LessParser.trim(builder)));
                            }
                            builder.append(ch);
                            this.back(ch2);
                            wasWhite = false;
                            continue block44;
                        }
                        if (LessParser.isIdentifier(builder)) {
                            builder.append(ch);
                            this.back(ch2);
                            wasWhite = false;
                            continue block44;
                        }
                        this.back(ch2);
                    }
                }
                case '+': {
                    if (ch == '+' && builder.length() == 1 && builder.charAt(0) == 'U') {
                        builder.append(ch);
                        continue block44;
                    }
                    if (builder.length() == 0 && left == null) {
                        builder.append(ch);
                        wasWhite = false;
                        continue block44;
                    }
                }
                case '*': 
                case ',': 
                case '/': 
                case '<': 
                case '=': 
                case '>': {
                    char ch2;
                    if (Operation.level(leftOperator) >= Operation.level(ch)) {
                        this.back(ch);
                        if (builder.length() > 0) {
                            left = this.concat(left, ' ', this.buildExpression(LessParser.trim(builder)));
                        }
                        if (left != null) return left;
                        throw this.createException("Unrecognized input: '" + ch + "'");
                    }
                    block13 : switch (ch) {
                        case '/': {
                            if (!this.comment(null)) break;
                            continue block44;
                        }
                        case '>': {
                            ch2 = this.read();
                            if (ch2 == '=') {
                                ch = '\u2265';
                                break;
                            }
                            this.back(ch2);
                            break;
                        }
                        case '<': {
                            ch2 = this.read();
                            if (ch2 == '=') {
                                ch = '\u2264';
                                break;
                            }
                            this.back(ch2);
                            break;
                        }
                        case '=': {
                            ch2 = this.read();
                            switch (ch2) {
                                case '<': {
                                    ch = '\u2264';
                                    break block13;
                                }
                                case '>': {
                                    ch = '\u2265';
                                    break block13;
                                }
                            }
                            this.back(ch2);
                            break;
                        }
                    }
                    wasWhite = false;
                    if (left == null) {
                        String str = LessParser.trim(builder);
                        if (str.isEmpty()) {
                            throw this.createException("Unrecognized input: '" + ch + "'");
                        }
                        left = this.buildExpression(str);
                    } else if (builder.length() > 0) {
                        left = this.concat(left, ' ', this.buildExpression(LessParser.trim(builder)));
                    }
                    left = this.concat(left, ch, this.parseExpression(ch));
                    if (!this.strictMath || this.nesting != 0 || ch != 47) continue block44;
                    ((Operation)left).setDataType(6);
                    continue block44;
                }
                case ':': {
                    if (left == null) {
                        if (builder.length() == 0 || builder.charAt(0) != '@') {
                            builder.append(':');
                            continue block44;
                        }
                        String str = LessParser.trim(builder);
                        left = this.buildExpression(str);
                    } else {
                        this.throwUnrecognizedInputIfAny(builder, ch);
                    }
                    left = this.concat(left, ch, this.parseExpression(ch));
                    continue block44;
                }
                case '(': {
                    void var8_13;
                    String str = LessParser.trim(builder);
                    if (wasWhite && str.length() > 0) {
                        left = this.concat(left, ' ', this.buildExpression(str));
                        str = "";
                    }
                    wasWhite = false;
                    switch (str) {
                        case "url": {
                            FunctionExpression functionExpression = new FunctionExpression(this.reader, str, this.parseUrlParam());
                            break;
                        }
                        case "data-uri": 
                        case "colorize-image": {
                            Operation op = this.parseParameterList();
                            op.addLeftOperand(new ValueExpression(this.reader, this.relativeURL.toString()));
                            FunctionExpression functionExpression = new FunctionExpression(this.reader, str, op);
                            break;
                        }
                        case "e": {
                            Operation op = this.parseParameterList();
                            Operation operation = new Operation(this.reader, op.getOperands().get(0), '~');
                            break;
                        }
                        case "calc": {
                            void var8_21;
                            int parenthesisCount = 0;
                            Object var8_17 = null;
                            block45: while (true) {
                                ch = this.read();
                                switch (ch) {
                                    case '~': {
                                        if (!LessParser.isWhitespace(builder)) break;
                                        Operation operation = new Operation(this.reader, this.parseExpression(ch), ch);
                                        continue block45;
                                    }
                                    case '(': {
                                        ++parenthesisCount;
                                        break;
                                    }
                                    case ')': {
                                        if (parenthesisCount == 0) {
                                            void var8_18;
                                            String val = LessParser.trim(builder);
                                            if (var8_18 != null) break block45;
                                            ValueExpression valueExpression = new ValueExpression(this.reader, val, 6);
                                            break block45;
                                        }
                                        --parenthesisCount;
                                    }
                                }
                                builder.append(ch);
                            }
                            Operation op = new Operation(this.reader, (Expression)var8_21, ';');
                            FunctionExpression functionExpression = new FunctionExpression(this.reader, str, op);
                            break;
                        }
                        default: {
                            FunctionExpression functionExpression = new FunctionExpression(this.reader, str, this.parseParameterList());
                        }
                    }
                    left = this.concat(left, ' ', (Expression)var8_13);
                    continue block44;
                }
                case ')': 
                case ';': 
                case '}': {
                    this.back(ch);
                    String str = LessParser.trim(builder);
                    if (!str.isEmpty()) {
                        left = this.concat(left, ' ', this.buildExpression(str));
                    }
                    if (left != null) return left;
                    if (leftOperator != '\u0000') {
                        throw this.createException("Unrecognized input: '" + leftOperator + "'");
                    }
                    if (ch == 41) return left;
                    return new ValueExpression(this.reader, "");
                }
                case '~': {
                    if (wasWhite && builder.length() > 0) {
                        left = this.concat(left, ' ', this.buildExpression(LessParser.trim(builder)));
                    } else {
                        this.throwUnrecognizedInputIfAny(builder, ch);
                    }
                    wasWhite = false;
                    left = this.concat(left, ' ', new Operation(this.reader, this.parseExpression(ch), ch));
                    continue block44;
                }
                case '\"': 
                case '\'': {
                    if (wasWhite && builder.length() > 0) {
                        left = this.concat(left, ' ', this.buildExpression(LessParser.trim(builder)));
                    } else {
                        this.throwUnrecognizedInputIfAny(builder, ch);
                    }
                    wasWhite = false;
                    left = this.concat(left, ' ', new ValueExpression(this.reader, this.readQuote(ch)));
                    continue block44;
                }
                case '`': {
                    left = this.concat(left, ' ', new JavaScriptExpression(this.reader, this.readQuote(ch)));
                    continue block44;
                }
                case '!': {
                    if (builder.length() > 0) {
                        left = this.concat(left, ' ', this.buildExpression(LessParser.trim(builder)));
                    }
                    if (left == null) break;
                    while (true) {
                        ch = this.read();
                        switch (ch) {
                            case ')': 
                            case ';': 
                            case '}': {
                                String str = LessParser.trim(builder);
                                if (str.equals("important")) {
                                    left.setImportant();
                                } else {
                                    left = this.concat(left, ' ', this.buildExpression('!' + str));
                                }
                                this.back(ch);
                                return left;
                            }
                        }
                        builder.append(ch);
                    }
                }
            }
            boolean isWhite = Character.isWhitespace(ch);
            if (isWhite) {
                if (builder.length() == 0 && left == null) continue;
                wasWhite = true;
                continue;
            }
            if (wasWhite) {
                if (builder.length() > 0) {
                    if (Operation.level(leftOperator) >= Operation.level(' ')) {
                        this.back(ch);
                        this.back(' ');
                        return this.buildExpression(LessParser.trim(builder));
                    }
                    left = this.concat(left, ' ', this.buildExpression(LessParser.trim(builder)));
                }
                if (left != null) {
                    this.back(ch);
                    left = this.concat(left, ' ', this.parseExpression(' '));
                    wasWhite = false;
                    continue;
                }
                wasWhite = false;
            }
            builder.append(ch);
        }
    }

    @Nonnull
    Operation parseParameterList() {
        char ch;
        Expression left = null;
        do {
            ++this.nesting;
            Expression expr = this.parseExpression('\u0000');
            --this.nesting;
            left = this.concat(left, ';', expr);
        } while ((ch = this.read()) == ';');
        if (ch != ')') {
            throw this.createException("Unrecognized input: '" + ch + "'");
        }
        if (left == null) {
            return new Operation(this.reader);
        }
        if (left.getClass() == Operation.class) {
            switch (((Operation)left).getOperator()) {
                case ',': 
                case ';': {
                    return (Operation)left;
                }
            }
        }
        return new Operation(this.reader, left, ',');
    }

    private String readQuote(char quote) {
        StringBuilder builder = this.cachesBuilder;
        builder.setLength(0);
        this.readQuote(quote, builder);
        String str = builder.toString();
        builder.setLength(0);
        return str;
    }

    private void readQuote(char quote, StringBuilder builder) {
        builder.append(quote);
        boolean isBackslash = false;
        while (true) {
            char ch = this.read();
            builder.append(ch);
            if (ch == quote && !isBackslash) {
                return;
            }
            isBackslash = ch == '\\' && !isBackslash;
        }
    }

    private Operation parseUrlParam() {
        StringBuilder builder = this.cachesBuilder;
        builder.setLength(0);
        Operation op = new Operation(this.reader, new ValueExpression(this.reader, this.relativeURL.getPath()), ';');
        block6: while (true) {
            char ch = this.read();
            switch (ch) {
                case '\"': 
                case '\'': {
                    String val = builder.toString();
                    String quote = this.readQuote(ch);
                    builder.append(val);
                    builder.append(quote);
                    continue block6;
                }
                case '\\': {
                    builder.append(ch);
                    builder.append(this.read());
                    continue block6;
                }
                case '@': {
                    if (builder.length() == 0) {
                        this.reader.back(ch);
                        op.addOperand(this.parseExpression('\u0000'));
                        this.read();
                        return op;
                    }
                    builder.append(ch);
                    continue block6;
                }
                case ')': {
                    String val = LessParser.trim(builder);
                    op.addOperand(new ValueExpression(this.reader, val, 6));
                    return op;
                }
            }
            builder.append(ch);
        }
    }

    private Expression concat(Expression left, char operator, Expression right) {
        Operation op;
        if (left == null) {
            return right;
        }
        if (left.getClass() == Operation.class && ((Operation)left).getOperator() == operator) {
            op = (Operation)left;
        } else {
            if (right != null && right.getClass() == Operation.class && ((Operation)right).getOperator() == operator) {
                Operation op2 = (Operation)right;
                op2.addLeftOperand(left);
                return op2;
            }
            op = new Operation(this.reader, left, operator);
        }
        if (right != null) {
            op.addOperand(right);
        }
        return op;
    }

    @Nonnull
    private Expression buildExpression(String str) {
        switch (str.charAt(0)) {
            case '@': {
                return new VariableExpression(this.reader, str);
            }
            case '-': {
                if (!str.startsWith("-@")) break;
                return new FunctionExpression(this.reader, "-", new Operation(this.reader, this.buildExpression(str.substring(1)), '\u0000'));
            }
        }
        return new ValueExpression(this.reader, str);
    }

    private boolean comment(FormattableContainer container) {
        char ch = this.read();
        switch (ch) {
            case '*': {
                StringBuilder builder = new StringBuilder();
                builder.append("/*");
                boolean wasAsterix = false;
                block7: while (true) {
                    ch = this.read();
                    builder.append(ch);
                    switch (ch) {
                        case '*': {
                            wasAsterix = true;
                            continue block7;
                        }
                        case '/': {
                            if (!wasAsterix) break;
                            if (container != null) {
                                container.add(new Comment(LessParser.trim(builder)));
                            }
                            return true;
                        }
                    }
                    wasAsterix = false;
                }
            }
        }
        this.back(ch);
        return false;
    }

    private char read() throws LessException {
        return this.reader.read();
    }

    private void back(char ch) {
        this.reader.back(ch);
    }

    private static String trim(StringBuilder builder) {
        String str = builder.toString().trim();
        builder.setLength(0);
        return str;
    }

    private static boolean isWhitespace(StringBuilder builder) {
        for (int i = 0; i < builder.length(); ++i) {
            if (Character.isWhitespace(builder.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isMixin(StringBuilder builder) {
        switch (LessParser.firstNonWhitespace(builder)) {
            case '#': 
            case '&': 
            case '.': {
                return true;
            }
        }
        return false;
    }

    private static boolean isSelector(StringBuilder builder) {
        int length = builder.length();
        if (length == 0) {
            return false;
        }
        switch (builder.charAt(0)) {
            case '#': 
            case '.': {
                break;
            }
            default: {
                return true;
            }
        }
        for (int i = 1; i < length; ++i) {
            char ch = builder.charAt(i);
            switch (ch) {
                case ':': 
                case '>': {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isIdentifier(StringBuilder builder) {
        char ch = '\u0000';
        int i = 0;
        while (i < builder.length() && Character.isWhitespace(ch = (char)builder.charAt(i++))) {
        }
        block6: while (true) {
            switch (ch) {
                case '#': 
                case '&': 
                case '.': 
                case '@': {
                    return true;
                }
                case '-': {
                    if (i < builder.length()) {
                        ch = builder.charAt(i++);
                        continue block6;
                    }
                    return true;
                }
                case 'U': {
                    if (builder.length() <= 1 || builder.charAt(1) != '+') break block6;
                    return true;
                }
            }
            break;
        }
        return Character.isLetter(ch);
    }

    private static boolean isVariableName(StringBuilder builder) {
        int i = 1;
        while (i < builder.length()) {
            char ch = builder.charAt(i++);
            switch (ch) {
                case '\"': 
                case '(': {
                    return false;
                }
            }
        }
        return true;
    }

    private static char firstNonWhitespace(StringBuilder builder) {
        for (int i = 0; i < builder.length(); ++i) {
            if (Character.isWhitespace(builder.charAt(i))) continue;
            return builder.charAt(i);
        }
        return ' ';
    }

    private void throwUnrecognizedInputIfAny(StringBuilder builder, int ch) {
        if (!LessParser.isWhitespace(builder)) {
            throw this.createException("Unrecognized input: '" + LessParser.trim(builder) + (char)ch + "'");
        }
        builder.setLength(0);
    }

    private LessException createException(String msg) {
        return this.reader.createException(msg);
    }

    @Override
    public void add(Formattable formattable) {
        if (formattable.getClass() == Rule.class && ((Rule)formattable).isMixin()) {
            return;
        }
        this.rules.add(this.rulesIdx++, formattable);
    }
}

