/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler.guid.viewtask;

import com.inet.annotations.JsonData;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.annotation.Nullable;

@Schema(description="Container for settings of a series task.")
@JsonData
public class SeriesDescription {
    @Schema(description="Unique identifier of the series.", example="series123")
    private String id;
    @Schema(description="Properties of the series.")
    private Map<String, String> properties;

    private SeriesDescription() {
    }

    public static SeriesDescription from(SeriesDefinition definition) {
        SeriesDescription seriesDescription = new SeriesDescription();
        seriesDescription.id = definition.getExtensionName();
        seriesDescription.properties = definition.getProperties();
        return seriesDescription;
    }

    public static SeriesDefinition toSeries(@Nullable SeriesDescription series) {
        if (series == null) {
            return null;
        }
        return new SeriesDefinition(series.id, series.properties);
    }
}

