/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler;

import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.annotation.AlternativePathInfo;
import com.inet.plugin.webapi.api.annotation.PathInfo;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.internalapi.TaskPlannerForUsers;
import com.inet.taskplanner.webapi.handler.guid.viewtask.TaskDescription;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class c
extends RequestHandler<Void, List<GUID>> {
    @AlternativePathInfo(pathInfo=@PathInfo(path="/taskplanner/import/{taskId}", description="Imports a single task from the provided JSON body. It updates the task defined by the path parameter.", summary="Update single task."), parameter={@Parameter(name="taskId", description="The GUID to import and update a specific, single task.", in=ParameterIn.PATH, schema=@Schema(implementation=GUID.class, example="000aIG6b0IaRVqazNR3j6Jelg"))})
    public c() {
        super(new String[]{"import"});
    }

    @Operation(summary="Import Tasks", description="Imports a single task or multiple tasks from the provided JSON body. Returns the GUIDs of the imported tasks.", requestBody=@RequestBody(description="JSON body containing task details. Can be a single task object or an array of task objects.", required=true, content={@Content(schema=@Schema(oneOf={TaskDescription.class, TaskDescription[].class}))}), responses={@ApiResponse(responseCode="200", description="Tasks imported successfully", content={@Content(schema=@Schema(implementation=GUID[].class), examples={@ExampleObject(name="GUID", summary="A Single GUID", value="['b6nmv97sutmnvhtw8hen0yh7y']"), @ExampleObject(name="GUID List", summary="A List of GUIDs", value="['b6nmv97sutmnvhtw8hen0yh7y','b6nmv97sutmnvhtw8hen0yh7y']")})}), @ApiResponse(responseCode="404", description="No content provided or task not found")})
    public List<GUID> a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Void void_, boolean bl) throws IOException {
        ArrayList<GUID> arrayList;
        block10: {
            TaskPlannerForUsers taskPlannerForUsers = TaskPlannerForUsers.getInstance();
            arrayList = new ArrayList<GUID>();
            try {
                TaskDescription taskDescription = (TaskDescription)this.jsonFromRequestWithType(httpServletRequest, (Type)((Object)TaskDescription.class));
                if (taskDescription != null && !taskDescription.isEmpty()) {
                    arrayList.add(c.a(taskPlannerForUsers, taskDescription, null, bl));
                }
            }
            catch (ClientMessageException | JsonException | ClassCastException throwable) {
                try {
                    TaskDescription[] taskDescriptionArray = (TaskDescription[])this.jsonFromRequestWithType(httpServletRequest, (Type)((Object)TaskDescription[].class));
                    if (taskDescriptionArray != null) {
                        for (TaskDescription taskDescription : taskDescriptionArray) {
                            if (taskDescription.isEmpty()) continue;
                            arrayList.add(c.a(taskPlannerForUsers, taskDescription, null, bl));
                        }
                    }
                }
                catch (ClientMessageException | JsonException | ClassCastException throwable2) {
                    if (throwable instanceof ClientMessageException) {
                        throw throwable;
                    }
                    if (throwable2 instanceof ClientMessageException) {
                        throw throwable2;
                    }
                    String string = StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable);
                    String string2 = StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable2);
                    TaskPlannerServerPlugin.LOGGER.debug((Object)string);
                    if (string.equals(string2)) break block10;
                    TaskPlannerServerPlugin.LOGGER.debug((Object)string2);
                }
            }
        }
        if (arrayList.isEmpty()) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse);
            throw new ClientMessageException(TaskPlannerServerPlugin.MSG.getMsg("noContentSet", new Object[]{TaskPlannerServerPlugin.MSG.getMsg("noContentSet.execute", new Object[0])}));
        }
        return arrayList;
    }

    public static GUID a(TaskPlannerForUsers taskPlannerForUsers, TaskDescription taskDescription, GUID gUID, boolean bl) {
        GUID gUID2;
        TaskDefinition taskDefinition = TaskDescription.toTask(taskDescription);
        GUID gUID3 = gUID2 = gUID != null ? gUID : taskDescription.getTaskId();
        if (StringFunctions.isEmpty((String)taskDefinition.getName())) {
            taskDefinition.setName(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.webapi.defaultImportName", new Object[0]));
        }
        if (bl) {
            return gUID2 != null ? gUID2 : GUID.generateNew();
        }
        if (gUID2 != null) {
            taskPlannerForUsers.updateTask(gUID2, taskDefinition);
            return gUID2;
        }
        return taskPlannerForUsers.addTask(taskDefinition);
    }

    public String getHelpPageKey() {
        return "taskplanner-webapi.import";
    }

    @Operation(summary="Import Tasks", description="Imports a single task or multiple tasks from the provided JSON body. Returns the GUIDs of the imported tasks.", requestBody=@RequestBody(description="JSON body containing task details. Can be a single task object or an array of task objects.", required=true, content={@Content(schema=@Schema(oneOf={TaskDescription.class, TaskDescription[].class}))}), responses={@ApiResponse(responseCode="200", description="Tasks imported successfully", content={@Content(schema=@Schema(implementation=GUID[].class), examples={@ExampleObject(name="GUID", summary="A Single GUID", value="['b6nmv97sutmnvhtw8hen0yh7y']"), @ExampleObject(name="GUID List", summary="A List of GUIDs", value="['b6nmv97sutmnvhtw8hen0yh7y','b6nmv97sutmnvhtw8hen0yh7y']")})}), @ApiResponse(responseCode="404", description="No content provided or task not found")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, bl);
    }
}

