/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.internalapi;

import com.inet.annotations.InternalApi;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.internalapi.NextExecutionDescription;
import java.time.ZonedDateTime;
import java.util.List;

@InternalApi
public class NextExecutionTimeChecker {
    public static NextExecutionDescription getNextExecution(TaskDefinition model) {
        long l2 = 0L;
        boolean bl = true;
        List<TriggerDefinition> list = model.getTriggers();
        for (TriggerDefinition triggerDefinition : list) {
            String string = triggerDefinition.getExtensionName();
            try {
                TriggerFactory triggerFactory = (TriggerFactory)ServerPluginManager.getInstance().getSingleInstanceByName(TriggerFactory.class, string, false);
                List<ZonedDateTime> list2 = triggerFactory.getNextExecutionTimes(triggerDefinition);
                if (list2 == null) {
                    bl = false;
                    continue;
                }
                if (list2.isEmpty()) continue;
                long l3 = list2.get(0).toEpochSecond() * 1000L;
                if (l2 != 0L && l3 >= l2) continue;
                l2 = l3;
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Throwable throwable) {
                TaskPlannerServerPlugin.LOGGER.error(throwable);
            }
        }
        return new NextExecutionDescription(l2, bl);
    }
}

