/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger.filechange;

import com.inet.permissions.Permission;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.trigger.filechange.FileChangeObserver;
import com.inet.taskplanner.server.api.trigger.filechange.FileChangeService;
import com.inet.taskplanner.server.api.trigger.filechange.b;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class c
implements FileChangeService {
    @Nonnull
    public String getExtensionName() {
        return "file";
    }

    @Override
    @Nullable
    public Permission getRequiredPermission() {
        return Permission.CONFIGURATION;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="It is called by components, which can only be run by users with required permissions.")
    public void validatePath(@Nonnull String pathAsString) throws ValidationException {
        Path path;
        try {
            path = Paths.get(pathAsString, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.error.invalidPath", new Object[]{invalidPathException.getMessage()})});
        }
        if (!path.isAbsolute()) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.error.notAbsolutePath", new Object[0])});
        }
    }

    @Override
    @Nonnull
    public FileChangeObserver createObserver(@Nonnull String path, boolean folder) {
        return new b(path, folder);
    }
}

